/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.imports;

import com.freescale.s32ds.cross.wizard.pi.Messages;
import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.freescale.s32ds.cross.wizard.pi.imports.ImportPIPage;
import com.freescale.s32ds.cross.wizard.pi.imports.ProjectInfoImportSettings;
import com.freescale.s32ds.cross.wizard.pi.imports.ProjectInfoImporter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.ui.newui.CDTStatusInfo;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.datatransfer.ExternalProjectImportWizard;

public class ImportPIWizard
extends ExternalProjectImportWizard {
    protected static final String WORKSPACE = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
    private static final String CREATION_PROBLEM = Messages.ImportPIWizard_creation_problems;
    private static final String COPY_ERR = Messages.ImportPIWizard_copy_error;
    protected ImportPIPage page;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.ImportPIWizard_win_title);
        this.page = new ImportPIPage();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        return this.createProject(this.page.getSettings());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createProject(final ProjectInfoImportSettings settings) {
        String[] errors = new String[1];
        try {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) {
                    try {
                        new ProjectInfoImporter(settings).createProject((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        S32DSWizardPiPlugin.log(e);
                    }
                }
            };
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                S32DSWizardPiPlugin.logWarning(Messages.ImportPIWizard_interrupt);
                return false;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (!(t instanceof CoreException)) return false;
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.open((int)1, (Shell)this.getShell(), (String)CREATION_PROBLEM, (String)NLS.bind((String)Messages.ImportPIWizard_conflict, (Object)settings.getProjectName()), (int)0x10000000);
                    return false;
                }
                ErrorDialog.openError((Shell)this.getShell(), (String)CREATION_PROBLEM, null, (IStatus)((CoreException)t).getStatus());
                return false;
            }
            Thread.sleep(100L);
        }
        catch (Exception e) {
            Status status = new Status(4, "com.freescale.s32ds.cross.wizard.pi", 1, e.getMessage(), (Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.ImportPIWizard_title, (String)e.getMessage(), (IStatus)status);
            return false;
        }
        if (errors[0] == null) return true;
        ErrorDialog.openError((Shell)this.getShell(), (String)COPY_ERR, (String)errors[0], (IStatus)new CDTStatusInfo(4, COPY_ERR));
        return true;
    }
}

