/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne.RTVar;

import com.pemicro.debug.gdbjtag.pne.RTVar.CLIPtype;
import com.pemicro.debug.gdbjtag.pne.RTVar.CLIPtypeInfo;
import com.pemicro.debug.gdbjtag.pne.RTVar.CLISizeOf;
import com.pemicro.debug.gdbjtag.pne.RTVar.CLISizeOfInfo;
import com.pemicro.debug.gdbjtag.pne.RTVar.CPEType;
import com.pemicro.debug.gdbjtag.pne.RTVar.GdbMiConnection;
import com.pemicro.debug.gdbjtag.pne.RTVar.IPErefreshService;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.GDBTypeParser;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.TreeItem;
import org.osgi.framework.BundleContext;

public class PErefreshService
extends AbstractDsfService
implements IPErefreshService {
    private Map<String, CPEType> actualTypes;
    private boolean refreshValues = false;
    private GdbMiConnection backEndConnection;
    private GDBTypeParser fGDBTypeParser = new GDBTypeParser();
    private static final Color BLUE_COLOR = new Color(null, 0, 0, 255);
    private final ILaunchConfiguration fLaunchConfiguration;

    private GDBTypeParser getGDBTypeParser() {
        return this.fGDBTypeParser;
    }

    public Map<String, CPEType> getActualTypes() {
        return this.actualTypes;
    }

    public PErefreshService(DsfSession session, ILaunchConfiguration lc) {
        super(session);
        this.fLaunchConfiguration = lc;
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getDefault().getBundle().getBundleContext();
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            public void handleSuccess() {
                PErefreshService.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        int port;
        this.getSession().addServiceEventListener((Object)this, null);
        try {
            port = this.fLaunchConfiguration.getAttribute("com.pemicro.debug.gdbjtag.pne.gdbmiPortNumber", 6224);
        }
        catch (CoreException e) {
            e.printStackTrace();
            port = 6224;
        }
        this.backEndConnection = new GdbMiConnection(port);
        boolean success = this.backEndConnection.init();
        if (!success) {
            requestMonitor.cancel();
            return;
        }
        this.actualTypes = new HashMap<String, CPEType>();
        this.initBasicTypes();
        this.register(new String[]{IPErefreshService.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.refreshValues = false;
        this.backEndConnection.close();
        this.unregister();
        this.actualTypes.clear();
        super.shutdown(requestMonitor);
    }

    private void initBasicTypes() {
        this.storeType("char", "char");
        this.storeType("signed char", "signed char");
        this.storeType("unsigned char", "unsigned char");
        this.storeType("int", "int");
        this.storeType("signed", "signed");
        this.storeType("signed int", "signed int");
        this.storeType("unsigned", "unsigned");
        this.storeType("unsigned int", "unsigned int");
        this.storeType("long", "long");
        this.storeType("unsigned long", "unsigned long");
        this.storeType("long int", "long int");
        this.storeType("signed long", "signed long");
        this.storeType("signed long int", "signed long int");
        this.storeType("float", "float");
        this.storeType("double", "double");
        this.storeType("long double", "long double");
        this.storeType("long long", "long long");
        this.storeType("unsigned long long", "unsigned long long");
        this.storeType("signed long long", "signed long long");
        this.storeType("short", "short");
        this.storeType("short int", "short int");
        this.storeType("signed short", "signed short");
        this.storeType("signed short int", "signed short int");
        this.storeType("unsigned short", "unsigned short");
        this.storeType("unsigned short int", "unsigned short int");
    }

    private byte[] memoryBytesToByteArray(MemoryByte[] memoryByteArray) {
        byte[] byteArray = new byte[memoryByteArray.length];
        int index = 0;
        while (index < memoryByteArray.length) {
            byteArray[index] = memoryByteArray[index].getValue();
            ++index;
        }
        return byteArray;
    }

    @Override
    public void updateValue(int valueColumnInt, int addressColumnInt, int typeColumnInt, TreeItem item) {
        String declaredType = item.getText(typeColumnInt);
        if (declaredType.isEmpty()) {
            return;
        }
        CPEType tempType = this.getActualTypes().get(declaredType);
        if (tempType == null) {
            return;
        }
        String Value = "";
        String size = tempType.getSize();
        String address = item.getText(addressColumnInt);
        TypeSupported type = tempType.getTypeSupported();
        if (address.isEmpty() || size.isEmpty()) {
            return;
        }
        MemoryByte[] memBytes = this.backEndConnection.getMemory(Long.decode(address), Integer.decode(size));
        if (memBytes != null) {
            block0 : switch (type) {
                case TYPE_CHAR: 
                case TYPE_SIGNED_CHAR: {
                    byte byteValue = memBytes[0].getValue();
                    Value = String.valueOf(byteValue);
                    break;
                }
                case TYPE_UNSIGNED_CHAR: {
                    byte[] byArray = new byte[2];
                    byArray[0] = memBytes[0].getValue();
                    byte[] ucBytes = byArray;
                    short ucs = ByteBuffer.wrap(ucBytes).order(ByteOrder.LITTLE_ENDIAN).getShort();
                    Value = String.valueOf(ucs);
                    break;
                }
                case TYPE_SHORT: 
                case TYPE_SHORT_INT: 
                case TYPE_SIGNED_SHORT: 
                case TYPE_SIGNED_SHORT_INT: {
                    short shortValue = ByteBuffer.wrap(this.memoryBytesToByteArray(memBytes)).order(ByteOrder.LITTLE_ENDIAN).getShort();
                    Value = String.valueOf(shortValue);
                    break;
                }
                case TYPE_UNSIGNED_SHORT: 
                case TYPE_UNSIGNED_SHORT_INT: {
                    byte[] byArray = new byte[4];
                    byArray[0] = memBytes[0].getValue();
                    byArray[1] = memBytes[1].getValue();
                    byte[] usBytes = byArray;
                    int usi = ByteBuffer.wrap(usBytes).order(ByteOrder.LITTLE_ENDIAN).getInt();
                    Value = String.valueOf(usi);
                    break;
                }
                case TYPE_UNSIGNED: 
                case TYPE_UNSIGNED_INT: 
                case TYPE_UNSIGNED_LONG: {
                    byte[] byArray = new byte[8];
                    byArray[0] = memBytes[0].getValue();
                    byArray[1] = memBytes[1].getValue();
                    byArray[2] = memBytes[2].getValue();
                    byArray[3] = memBytes[3].getValue();
                    byte[] uiBytes = byArray;
                    long uil = ByteBuffer.wrap(uiBytes).order(ByteOrder.LITTLE_ENDIAN).getLong();
                    Value = String.valueOf(uil);
                    break;
                }
                case TYPE_INT: 
                case TYPE_SIGNED: 
                case TYPE_SIGNED_INT: 
                case TYPE_LONG: 
                case TYPE_LONG_INT: 
                case TYPE_SIGNED_LONG: 
                case TYPE_SIGNED_LONG_INT: {
                    int intValue = ByteBuffer.wrap(this.memoryBytesToByteArray(memBytes)).order(ByteOrder.LITTLE_ENDIAN).getInt();
                    Value = String.valueOf(intValue);
                    break;
                }
                case TYPE_LONG_LONG: 
                case TYPE_SIGNED_LONG_LONG: {
                    long longValue = ByteBuffer.wrap(this.memoryBytesToByteArray(memBytes)).order(ByteOrder.LITTLE_ENDIAN).getLong();
                    Value = String.valueOf(longValue);
                    break;
                }
                case TYPE_UNSIGNED_LONG_LONG: {
                    byte[] byArray = new byte[16];
                    byArray[8] = memBytes[7].getValue();
                    byArray[9] = memBytes[6].getValue();
                    byArray[10] = memBytes[5].getValue();
                    byArray[11] = memBytes[4].getValue();
                    byArray[12] = memBytes[3].getValue();
                    byArray[13] = memBytes[2].getValue();
                    byArray[14] = memBytes[1].getValue();
                    byArray[15] = memBytes[0].getValue();
                    byte[] ullBytes = byArray;
                    BigInteger ull = new BigInteger(1, ullBytes);
                    Value = ull.toString();
                    break;
                }
                case TYPE_FLOAT: {
                    float floatValue = ByteBuffer.wrap(this.memoryBytesToByteArray(memBytes)).order(ByteOrder.LITTLE_ENDIAN).getFloat();
                    Value = Float.toString(floatValue);
                    break;
                }
                case TYPE_DOUBLE: 
                case TYPE_LONGDOUBLE: {
                    double doubleValue = ByteBuffer.wrap(this.memoryBytesToByteArray(memBytes)).order(ByteOrder.LITTLE_ENDIAN).getDouble();
                    Value = Double.toString(doubleValue);
                    break;
                }
                case TYPE_ENUM: {
                    int enumValue = 0;
                    Map<String, Integer> enumMap = tempType.getEnumerations();
                    switch (Integer.valueOf(size.trim())) {
                        case 1: {
                            enumValue = ByteBuffer.wrap(this.memoryBytesToByteArray(memBytes)).order(ByteOrder.LITTLE_ENDIAN).get();
                            break;
                        }
                        case 2: {
                            enumValue = ByteBuffer.wrap(this.memoryBytesToByteArray(memBytes)).order(ByteOrder.LITTLE_ENDIAN).getShort();
                            break;
                        }
                        case 4: {
                            enumValue = ByteBuffer.wrap(this.memoryBytesToByteArray(memBytes)).order(ByteOrder.LITTLE_ENDIAN).getInt();
                        }
                    }
                    if (enumMap.containsValue(enumValue)) {
                        for (Map.Entry<String, Integer> entry : enumMap.entrySet()) {
                            if (enumValue != entry.getValue()) continue;
                            Value = entry.getKey();
                            break block0;
                        }
                        break;
                    }
                    Value = String.valueOf(enumValue);
                    break;
                }
                case TYPE_POINTER: {
                    long pointerValue = 0L;
                    ByteBuffer tempBuffer = ByteBuffer.wrap(this.memoryBytesToByteArray(memBytes)).order(ByteOrder.LITTLE_ENDIAN);
                    switch (Integer.valueOf(size.trim())) {
                        case 1: {
                            pointerValue = tempBuffer.get();
                            break;
                        }
                        case 2: {
                            pointerValue = tempBuffer.getShort();
                            break;
                        }
                        case 4: {
                            pointerValue = tempBuffer.getInt();
                            break;
                        }
                        case 8: {
                            pointerValue = tempBuffer.getLong();
                        }
                    }
                    Value = "0x" + Long.toHexString(pointerValue);
                    break;
                }
                default: {
                    Value = "";
                }
            }
            item.setText(valueColumnInt, Value);
            item.setForeground(valueColumnInt, BLUE_COLOR);
        }
    }

    private void storeSize(String declaredType, String sizeOfString) {
        if (!sizeOfString.isEmpty()) {
            CPEType currentType = this.getActualTypes().get(declaredType);
            currentType.setSize(sizeOfString);
        }
    }

    private void storeType(String declaredType, String ptypeString) {
        GDBTypeParser.GDBType gdbType = this.getGDBTypeParser().parse(ptypeString);
        String tempString = gdbType.getTypeName();
        if ((tempString = tempString.trim()).equals("char")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_CHAR, "char", "1", null));
        }
        if (tempString.equals("signed char")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_SIGNED_CHAR, "signed char", "1", null));
        }
        if (tempString.equals("unsigned char")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_UNSIGNED_CHAR, "unsigned char", "1", null));
        }
        if (tempString.equals("short")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_SHORT, "short", "2", null));
        }
        if (tempString.equals("short int")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_SHORT_INT, "short int", "2", null));
        }
        if (tempString.equals("signed short")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_SIGNED_SHORT, "signed short", "2", null));
        }
        if (tempString.equals("signed short int")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_SIGNED_SHORT_INT, "signed short int", "2", null));
        }
        if (tempString.equals("unsigned short")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_UNSIGNED_SHORT, "unsigned short", "2", null));
        }
        if (tempString.equals("unsigned short int")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_UNSIGNED_SHORT_INT, "unsigned short int", "2", null));
        }
        if (tempString.equals("int")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_INT, "int", "4", null));
        }
        if (tempString.equals("signed")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_SIGNED, "signed", "4", null));
        }
        if (tempString.equals("signed int")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_SIGNED_INT, "signed int", "4", null));
        }
        if (tempString.equals("long")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_LONG, "long", "4", null));
        }
        if (tempString.equals("long int")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_LONG_INT, "long int", "4", null));
        }
        if (tempString.equals("signed long")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_SIGNED_LONG, "signed long", "4", null));
        }
        if (tempString.equals("unsigned")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_UNSIGNED, "unsigned", "4", null));
        }
        if (tempString.equals("unsigned int")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_UNSIGNED_INT, "unsigned int", "4", null));
        }
        if (tempString.equals("unsigned long")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_UNSIGNED_LONG, "unsigned long", "4", null));
        }
        if (tempString.equals("signed long int")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_SIGNED_LONG_INT, "signed long int", "4", null));
        }
        if (tempString.equals("long long")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_LONG_LONG, "long long", "8", null));
        }
        if (tempString.equals("unsigned long long")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_UNSIGNED_LONG_LONG, "unsigned long long", "8", null));
        }
        if (tempString.equals("signed long long")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_SIGNED_LONG_LONG, "signed long long", "8", null));
        }
        if (tempString.equals("float")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_FLOAT, "float", "4", null));
        }
        if (tempString.equals("double")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_DOUBLE, "double", "8", null));
        }
        if (tempString.equals("long double")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_LONGDOUBLE, "long double", "8", null));
        }
        if (tempString.contains("enum")) {
            int startIndex = ptypeString.indexOf("{") + 1;
            int endIndex = ptypeString.indexOf("}");
            String enumerations = ptypeString.substring(startIndex, endIndex);
            String delims = "[,]";
            String[] tokens = enumerations.split(delims);
            HashMap<String, Integer> tempMap = new HashMap<String, Integer>();
            delims = "[=]";
            int previousEnumeratorValue = -1;
            int i = 0;
            while (i < tokens.length) {
                if (tokens[i].contains("=")) {
                    String[] stringValue = tokens[i].split(delims);
                    tempMap.put(stringValue[0], Integer.valueOf(stringValue[1].trim()));
                    previousEnumeratorValue = Integer.valueOf(stringValue[1].trim());
                } else {
                    tempMap.put(tokens[i].trim(), ++previousEnumeratorValue);
                }
                ++i;
            }
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_ENUM, "enum", "1", tempMap));
        }
        if (declaredType.contains("*")) {
            this.getActualTypes().put(declaredType, new CPEType(TypeSupported.TYPE_POINTER, declaredType, "4", null));
        }
    }

    @Override
    public void queryTypeAndStore(IDMContext dmc, String declaredType) {
        DsfSession session = DsfSession.getSession((String)dmc.getSessionId());
        final String tempString = declaredType;
        if (session.isActive()) {
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), session.getId());
            IMICommandControl connectionService = (IMICommandControl)tracker.getService(IMICommandControl.class);
            tracker.dispose();
            CPEType tempType = this.getActualTypes().get(declaredType);
            if (tempType == null) {
                DataRequestMonitor<CLIPtypeInfo> rm = new DataRequestMonitor<CLIPtypeInfo>((Executor)session.getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            CLIPtypeInfo ptypeInfo = (CLIPtypeInfo)((Object)this.getData());
                            String resultString = ptypeInfo.getResultString();
                            PErefreshService.this.storeType(tempString, resultString);
                        }
                    }
                };
                connectionService.queueCommand((ICommand)new CLIPtype(dmc, declaredType), (DataRequestMonitor)rm);
                DataRequestMonitor<CLISizeOfInfo> rm1 = new DataRequestMonitor<CLISizeOfInfo>((Executor)session.getExecutor(), null){

                    protected void handleCompleted() {
                        if (this.isSuccess()) {
                            CLISizeOfInfo sizeInfo = (CLISizeOfInfo)((Object)this.getData());
                            String resultString = sizeInfo.getResultString();
                            PErefreshService.this.storeSize(tempString, resultString);
                        }
                    }
                };
                connectionService.queueCommand((ICommand)new CLISizeOf(dmc, declaredType), (DataRequestMonitor)rm1);
            }
        }
    }

    @Override
    public boolean canRefresh() {
        return this.refreshValues;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.refreshValues = true;
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.refreshValues = false;
    }

    public static enum TypeSupported {
        TYPE_CHAR,
        TYPE_SIGNED_CHAR,
        TYPE_UNSIGNED_CHAR,
        TYPE_SHORT,
        TYPE_SHORT_INT,
        TYPE_SIGNED_SHORT,
        TYPE_SIGNED_SHORT_INT,
        TYPE_UNSIGNED_SHORT,
        TYPE_UNSIGNED_SHORT_INT,
        TYPE_INT,
        TYPE_SIGNED,
        TYPE_SIGNED_INT,
        TYPE_UNSIGNED,
        TYPE_UNSIGNED_INT,
        TYPE_LONG,
        TYPE_LONG_INT,
        TYPE_SIGNED_LONG,
        TYPE_SIGNED_LONG_INT,
        TYPE_UNSIGNED_LONG,
        TYPE_LONG_LONG,
        TYPE_SIGNED_LONG_LONG,
        TYPE_UNSIGNED_LONG_LONG,
        TYPE_FLOAT,
        TYPE_DOUBLE,
        TYPE_LONGDOUBLE,
        TYPE_ENUM,
        TYPE_POINTER;

    }
}

