/*========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/
ENTRY(Reset_Handler)

/*
To use "new" operator with EWL in C++ project the following symbol shall be defined
*/
/*EXTERN(_ZN10__cxxabiv119__terminate_handlerE)*/

STACK_SIZE = DEFINED(__stack_size__) ? __stack_size__ : 0x2000;
HEAP_SIZE  = DEFINED(__heap_size__)  ? __heap_size__  : 0x2000;

MEMORY {
    FLASH_A5            : ORIGIN = 0x19008000,              LENGTH = 0x8000
    SRAM                : ORIGIN = 0x3EF00000,              LENGTH = 0x100000
}
   
SECTIONS
{
    
    .init            : 
	{
	    *(.init*)
	}  > FLASH_A5
    
    /* Interrupt vectors area */
    .intvec            : 
	{
	    A5_1_VECTOR_TABLE = .;
		A5_1_VECTOR_RAM = .;
	    *(.vt*)
		A5_1_VECTOR_SIZE = .;
	}  > FLASH_A5
    
	.text 	          ALIGN(0)             : {*(.text*)}
    .syscall 	      ALIGN(0)             : {*(.syscall*)}
    .secinfo 	      ALIGN(0)             : {*(.secinfo*)}
	.fini    	      ALIGN(0)             : {*(.fini*)}
	.eh_frame  	      ALIGN(0)             : {*(.eh_frame*)}
	.init_array	      ALIGN(0)             : {*(.init_array*)}
	.jcr	          ALIGN(0)             : {*(.jcr*)}
	.ARM.extab        ALIGN(4)             : 
    {
     *(.ARM.extab*)
    }
	.ARM.exidx  	  ALIGN(0)             : 
	{
		__exidx_start = .;
		*(.ARM.exidx*)
		__exidx_end = .;
	}
    .rodata 	      ALIGN(0)             : {*(.rodata*)}

  __DATA_ROM = .; /* Symbol is used by startup for data initialization */

	.data  :   AT(__DATA_ROM)
	{
   		 . = ALIGN(4);
   		 __DATA_RAM = .;
  		  __data_start__ = .;      /* create a global symbol at data start */
	    *(.data*)
		__DATA_END = .;
		__data_end__ = .;        /* define a global symbol at data end */
	} > SRAM
	
	__DATA_END = __DATA_ROM + (__data_end__ - __data_start__);
	
	.bss ALIGN(16) :
    {
        _BSS_BEGIN = .;
                                __bss_start__ = .;
        *(.bss*)       /* Zero-filled run time allocate data memory */
        *(COMMON)        
                                __bss_end__ = .;
        _BSS_END = .;
    } > SRAM
    
   
    	/* stack and heap shall be located in the same memory region */
	.heap : 
    {
         . = ALIGN(8);
        __end__ = .;
        PROVIDE(_end = .);
    	PROVIDE(end = .);
    	. += HEAP_SIZE;
    }  > SRAM   

    .stack  :
    {
           . = ALIGN(8);
         _stack_s = .;
        . += STACK_SIZE;
        _stack_e = .;
    } > SRAM
	  
}