/*******************************************************************************
 * Copyright (c) 2002, 2005 Rational Software Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * 	   IBM Rational Software - Initial API and implementation
 *     John Cortell (Freescale) - code customized for Processor Expert
 * 
 *******************************************************************************/
package com.processorexpert.derivative.npw;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;


/**
 * Some EPL code we require from the PEx wizard plugins 
 */
public class Wizard {

	/** Callback interface driven by {@link Wizard#getRunnable(Shell, ICallback)} */
	public interface ICallback {
		
	    /**
		 * Returns the container of this wizard.
		 * 
		 * @return the wizard container, or <code>null</code> if this wizard has
		 *         yet to be added to a container
		 */
		IWizardContainer getContainer();

		/** Code that runs prior to {@link #doRun(IProgressMonitor)} */
		void doRunPrologue(IProgressMonitor monitor);
		
		/** The primary wizard post-processing logic */
		void doRun(IProgressMonitor monitor) throws CoreException;
		
		/** Code that runs after to {@link #doRun(IProgressMonitor)}, even if an exception was encountered */
		void doRunEpilogue(IProgressMonitor monitor);
	}

	/**
	 * Utility for creating a workspace operation object to be used for running
	 * the post wizard logic (typically project creation and configuration
	 * activity).
	 */
	public static WorkspaceModifyDelegatingOperation getRunnable(final Shell shell, final ICallback callback) {
		return new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress() {
			public void run(IProgressMonitor imonitor) throws InvocationTargetException, InterruptedException {
				final Exception except[] = new Exception[1];
				shell.getDisplay().syncExec(new Runnable() {
					public void run() {
						IRunnableWithProgress op= new WorkspaceModifyDelegatingOperation(new IRunnableWithProgress() {
							public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
								final IProgressMonitor fMonitor;
								if (monitor == null) {
									fMonitor= new NullProgressMonitor();
								} else {
									fMonitor = monitor;
								}
								fMonitor.beginTask("Running wizard logic", 3); //$NON-NLS-1$
								callback.doRunPrologue(new SubProgressMonitor(fMonitor, 1));
								try {
									callback.doRun(new SubProgressMonitor(fMonitor, 1));
								}
								catch (CoreException e) {
									except[0] = e;
								}
								callback.doRunEpilogue(new SubProgressMonitor(fMonitor, 1));
								fMonitor.done();
							}
						});
						try {
							callback.getContainer().run(false, true, op);
						} catch (InvocationTargetException e) {
							except[0] = e;
						} catch (InterruptedException e) {
							except[0] = e;
						}
					}
				});
				if (except[0] != null) {
					if (except[0] instanceof InvocationTargetException) {
						throw (InvocationTargetException)except[0];
					}
					if (except[0] instanceof InterruptedException) {
						throw (InterruptedException)except[0];
					}
					throw new InvocationTargetException(except[0]);
				}
			}
		});
	}
}
