package com.freescale.s32ds.cross.sdk.s32k14x_0_8_6.pexconf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKHook;

public class PExConfig implements ISDKHook {
	private static final int MODE = 258;
	private static final int MODE_ALL = ISDKHook.STATE_ATTACH + ISDKHook.TIME_AFTER;

	public PExConfig() {
	}

	@Override
	public void stateChange(int mode, ISDK sdk, Object cfg, String path) {

		if (mode == MODE) {
			IConfiguration[] confs = null;
			if (cfg instanceof ICConfigurationDescription) {
				ICConfigurationDescription cfgd = (ICConfigurationDescription) cfg;
				IProject project = cfgd.getProjectDescription().getProject();
				confs = ManagedBuildManager.getBuildInfo(project).getManagedProject().getConfigurations();
			} else if (cfg instanceof IConfiguration) {
				confs = ((IConfiguration) cfg).getManagedProject().getConfigurations();
			} else {
				Activator.log(new IllegalArgumentException("Fail to invoke PExConfig Hook"));
			}
			for (IConfiguration config : confs) {

				ITool[] tools = config.getTools();
				for (ITool tool : tools) {
					String toolName = tool.getBaseId();
					IOption opt = null;
					String c_cpp_tool;
					// GCC toolchain
					if ((toolName.indexOf(".linker") != -1)
					        && (toolName.indexOf("cortexm") != -1)) {
						c_cpp_tool = toolName.contains(".cpp") ? "cpp"
						        : (toolName.contains(".c") ? "c" : null);
						opt = tool
						        .getOptionBySuperClassId("com.freescale.s32ds.cross.gnu.tool."
						                + c_cpp_tool
						                + ".linker.option.scriptfile");
						if (opt != null) {
							List<String> curValueList;
							try {
								curValueList = new ArrayList<>(
								        Arrays.asList(opt
								                .getBasicStringListValue()));
								if (!curValueList.isEmpty()) {
									String oldName = "_100_";
									String newName = "_64_";
									List<String> curListRenamed = curValueList
									        .stream()
									        .map(s -> s.replaceAll(oldName,
									                newName))
									        .collect(Collectors.toList());
									if (opt.getBasicValueType() == IOption.STRING_LIST) {
										opt.setValue(curListRenamed);
									}
								}
							} catch (BuildException e) {
								Activator.log(e);
							}

						}
					}
					// IAR toolchain
					if ((toolName.indexOf(".linker") != -1)
					        && (toolName.indexOf("iar") != -1)) {
						opt = tool
						        .getOptionBySuperClassId("iar.arm.toolchain.linker.option.icfFile.v5.4.0");
						if (opt != null) {
							String oldName = "_100_";
							String newName = "_64_";
							String curValue;
							try {
								curValue = opt.getStringValue();
								if (!curValue.isEmpty()) {
									String curRenamed = curValue.replaceAll(
									        oldName, newName);
									if (opt.getBasicValueType() == IOption.STRING) {
										opt.setValue(curRenamed);
									}
								}
							} catch (BuildException e) {
								Activator.log(e);
							}
						}
					}

				}
			}
			IProject curProject = getProject(cfg);
			if (curProject != null) {
				ManagedBuildManager.saveBuildInfo(curProject, true);
			}
		}
		if (mode == MODE_ALL) {
			IProject curProject = getProject(cfg);
			if (curProject != null) {
				new PExConfigAdjuster(curProject).adjustPExConfiguration();
				ManagedBuildManager.saveBuildInfo(curProject, true);
			}
		}
	}

	private IProject getProject(Object cfg) {
		IProject curProject = null;
		if (cfg instanceof ICConfigurationDescription) {
			ICConfigurationDescription cfgd = (ICConfigurationDescription) cfg;
			curProject = cfgd.getProjectDescription().getProject();
		} else if (cfg instanceof IConfiguration) {
			curProject = (IProject) ((IConfiguration) cfg)
			        .getManagedProject().getOwner();
		} else {
			Activator.log(new IllegalArgumentException("Fail to invoke PExConfig Hook")); //$NON-NLS-1$
		}
		return curProject;
	}
}