/*****************************************************************************
 *
 * Copyright (c) 2015-2016 Freescale Semiconductor, Inc.
 * Copyright 2017-2019 NXP
 * All Rights Reserved
 *
 *****************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#include "derivative.h"

extern void Reset_Handler(void);

#if defined (__ICCARM__)
#pragma section = "flashConfig"
    const int  boot_header1[7] = {
#elif  defined(__GNUC__)
    const int __attribute__((section (".flashConfig"))) boot_header[7] = {
#elif defined (__ghs__)
#pragma ghs section rodata =".flashConfig"
    const int  boot_header1[7] = {
#endif

    0x005A0002,        // RCHW
    0x00000000,        // Reserved
    0x00000000,        // Secure boot start address
    0x00000000,        // Secure boot image length (in bytes)
    (int)Reset_Handler, // CM4 Entry Point
    0x00000000,        // Reserved
    0x00000000,        // Reserved
};

#if defined (__ghs__)
#pragma ghs section rodata =default
#endif
