; ---------------------------------------------------------------------------------------
;  @file:    startup_MAC57D54H_A5.s
;  @purpose: CMSIS Cortex-A5 Core Device Startup File
;            MAC57D54H
; ---------------------------------------------------------------------------------------
;
; Copyright (c) 1997 - 2015 , Freescale Semiconductor, Inc.
; Copyright 2017-2019 NXP
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without modification,
; are permitted provided that the following conditions are met:
;
; o Redistributions of source code must retain the above copyright notice, this list
;   of conditions and the following disclaimer.
;
; o Redistributions in binary form must reproduce the above copyright notice, this
;   list of conditions and the following disclaimer in the documentation and/or
;   other materials provided with the distribution.
;
; o Neither the name of Freescale Semiconductor, Inc. nor the names of its
;   contributors may be used to endorse or promote products derived from this
;   software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
; ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
; ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
; (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;*****************************************************************************
;* Version: GCC for ARM Embedded Processors                                  *
;*****************************************************************************
    .file "startup_MAC57D54H_A5.s"
        .export Reset_Handler

        .section .init
Reset_Handler:
        ;; set up SVC mode stack pointer
        .import __stack
        ldr     sp, =__stack

        .import init_data_bss
        bl      init_data_bss

#if (defined(__VFP__))
  /* Permit access to VFP/NEON, registers by modifying CPACR */
  mrc     p15,0,r1,c1,c0,2
  orr     r1,r1,#0x00f00000
  mcr     p15,0,r1,c1,c0,2

  /* Ensure that subsequent instructions occur in the context of VFP/NEON access permitted */
  isb

  /* Enable VFP/NEON */
  vmrs    r1,fpexc
  orr     r1,r1,#0x40000000
  vmsr    fpexc,r1

  /* Initialise VFP/NEON registers to 0 */
  mov     r2,#0

  /* Initialise D16 registers to 0 */
  vmov    d0, r2,r2
  vmov    d1, r2,r2
  vmov    d2, r2,r2
  vmov    d3, r2,r2
  vmov    d4, r2,r2
  vmov    d5, r2,r2
  vmov    d6, r2,r2
  vmov    d7, r2,r2
  vmov    d8, r2,r2
  vmov    d9, r2,r2
  vmov    d10,r2,r2
  vmov    d11,r2,r2
  vmov    d12,r2,r2
  vmov    d13,r2,r2
  vmov    d14,r2,r2
  vmov    d15,r2,r2

  /* Initialise FPSCR to a known state */
  vmrs    r1,fpscr
  /* Mask off all bits that do not have to be preserved. Non-preserved bits can/should be zero. */
  ldr     r2,=0x00086060
  and     r1,r1,r2
  vmsr    fpscr,r1
#endif

        ;; jump to main
        .import main
        bl      main

trap:
        b       trap
