; ---------------------------------------------------------------------------------------
;  @file:    startup_MAC57D54H_M0p.s
;  @purpose: CMSIS Cortex-M0p Core Device Startup File
;            MAC57D54H
; ---------------------------------------------------------------------------------------
;
; Copyright (c) 1997 - 2015 , Freescale Semiconductor, Inc.
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without modification,
; are permitted provided that the following conditions are met:
;
; o Redistributions of source code must retain the above copyright notice, this list
;   of conditions and the following disclaimer.
;
; o Redistributions in binary form must reproduce the above copyright notice, this
;   list of conditions and the following disclaimer in the documentation and/or
;   other materials provided with the distribution.
;
; o Neither the name of Freescale Semiconductor, Inc. nor the names of its
;   contributors may be used to endorse or promote products derived from this
;   software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
; ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
; ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
; (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;
; The modules in this file are included in the libraries, and may be replaced
; by any user-defined modules that define the PUBLIC symbol _program_start or
; a user defined start symbol.
; To override the cstartup defined in the library, simply add your modified
; version to the workbench project.
;
; The vector table is normally located at address 0.
; When debugging in RAM, it can be located in RAM, aligned to at least 2^6.
; The name "__vector_table" has special meaning for C-SPY:
; it is where the SP start value is found, and the NVIC vector
; table register (VTOR) is initialized to this address if != 0.
;
; Cortex-M version
;

       MODULE  ?cstartup

        ;; Forward declaration of sections.
        SECTION CSTACK:DATA:NOROOT(3)

        SECTION .intvec:CODE:ROOT(2)

        EXTERN  __iar_program_start
        EXTERN  SystemInit
        EXTERN  init_data_bss
        PUBLIC  __vector_table
        PUBLIC  __vector_table_0x1c
        PUBLIC  __Vectors
        PUBLIC  __Vectors_End
        PUBLIC  __Vectors_Size

        DATA

__vector_table
        DCD     sfe(CSTACK)
        DCD     Reset_Handler

        DCD     NMI_Handler                                   ;NMI Handler
        DCD     HardFault_Handler                             ;Hard Fault Handler
        DCD     0                            
        DCD     0                            
        DCD     0                            
__vector_table_0x1c
    DCD   0                                               ; Reserved
    DCD   0                                               ; Reserved
    DCD   0                                               ; Reserved
    DCD   0                                               ; Reserved
    DCD   SVC_Handler                                     ; SVCall Handler
    DCD   0                                               ; Reserved
    DCD   0                                               ; Reserved
    DCD   PendSV_Handler                                  ; PendSV Handler
    DCD   SysTick_Handler                                 ; SysTick Handler

                                                            ; External Interrupts
    DCD   CPU2CPU_int0_IRQHandler                         ; CPU to CPU int0 interrupt
    DCD   CPU2CPU_int1_IRQHandler                         ; CPU to CPU int1 interrupt
    DCD   CPU2CPU_int2_IRQHandler                         ; CPU to CPU int2 interrupt
    DCD   CPU2CPU_int3_IRQHandler                         ; CPU to CPU int3 interrupt
    DCD   Reserved20_IRQHandler                           ; Reserved interrupt
    DCD   Directed_CM0_IRQHandler                         ; Directed CM0+ interrupt
    DCD   Reserved22_IRQHandler                           ; Reserved interrupt   
    DCD   Reserved23_IRQHandler                           ; Reserved interrupt     
    DCD   DMA0_IRQHandler                                 ; DMA transfer complete channels 0-15 
    DCD   DMA0_Error_IRQHandler                           ; DMA error interrupt channels 0-15
    DCD   ERM_errors_IRQHandler                           ; CM4, SRAM, GRAM, IOP RAM, or Flash ECC/ Parity errors
    DCD   FXOSC_SXOSC_IRQHandler                          ; Fast External Oscillator/Slow external oscillator
    DCD   SWT_2_IRQHandler                                ; Watchdog for CM0+ core
    DCD   Reserved29_IRQHandler                           ; Reserved interrupt
    DCD   CMP0_IRQHandler                                 ; Analog Comparator_0
    DCD   PIT_IRQHandler                                  ; Peridoc Interrupt Timer
    DCD   SIUL2_IRQHandler                                ; System Integration Unit
    DCD   SPI2_IRQHandler                                 ; Deserial Serial Peripheral Interface    
    DCD   ADC_IRQHandler                                  ; Analog to digital converter  
    DCD   SEG_LCD_IRQHandler                              ; Segment LCD controller  
    DCD   SMC_IRQHandler                                  ; Stepper Motor Controller  
    DCD   SSD0_IRQHandler                                 ; Stepper Stall detect 0  
    DCD   SSD1_IRQHandler                                 ; Stepper Stall detect 1  
    DCD   SSD2_IRQHandler                                 ; Stepper Stall detect 2  
    DCD   SSD3_IRQHandler                                 ; Stepper Stall detect 3  
    DCD   SSD4_IRQHandler                                 ; Stepper Stall detect 4  
    DCD   SSD5_IRQHandler                                 ; Stepper Stall detect 5  
    DCD   FTM_IRQHandler                                  ; Flex Timer 0   
    DCD   MC_ME_IOP_INT_IRQHandler                        ; Magic Carpet Mode Entry / IOP_INT 
    DCD   MC_RGM_IRQHandler                               ; Magic Carpet Reset Generation 
    DCD   RTC_IRQHandler                                  ; real time clock 
    DCD   WKPU_IRQHandler                                 ; Wake up unit 
__Vectors_End

__Vectors       EQU   __vector_table
__Vectors_Size 	EQU   __Vectors_End - __Vectors

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; Default interrupt handlers.
;;
        THUMB

        PUBWEAK Reset_Handler
        SECTION .init:CODE:REORDER:NOROOT(2)
Reset_Handler
    cpsid   i               ; Mask interrupts

    ; Init the rest of the registers
    LDR     R1,=0
    LDR     R2,=0
    LDR     R3,=0
    LDR     R4,=0
    LDR     R5,=0
    LDR     R6,=0
    LDR     R7,=0
    MOV     R8,R7
    MOV     R9,R7
    MOV     R10,R7
    MOV     R11,R7
    MOV     R12,R7
    
    ; Initialize the stack pointer
    LDR     R0, =sfe(CSTACK)
    MOV     R13,R0
    
    ; Init .data and .bss sections
    LDR     R0, =init_data_bss
    BLX     R0
    CPSIE   I               ; Unmask interrupts

    LDR     R0, =__iar_program_start
    BX      R0
    
        PUBWEAK NMI_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
NMI_Handler
        B .   

        PUBWEAK HardFault_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
HardFault_Handler
        B .  

        PUBWEAK SVC_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
SVC_Handler
        B .  

        PUBWEAK PendSV_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
PendSV_Handler
        B .  

        PUBWEAK SysTick_Handler
        SECTION .text:CODE:REORDER:NOROOT(1)
SysTick_Handler
        B .  

        PUBWEAK CPU2CPU_int0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
CPU2CPU_int0_IRQHandler
        B .  

        PUBWEAK CPU2CPU_int1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
CPU2CPU_int1_IRQHandler
        B .  
        
        PUBWEAK CPU2CPU_int2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
CPU2CPU_int2_IRQHandler
        B .  

        PUBWEAK CPU2CPU_int3_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
CPU2CPU_int3_IRQHandler
        B .  

        PUBWEAK Reserved20_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
Reserved20_IRQHandler
        B .  
        
        PUBWEAK Directed_CM0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
Directed_CM0_IRQHandler
        B . 
        
        PUBWEAK Reserved22_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
Reserved22_IRQHandler
        B .  

        PUBWEAK Reserved23_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
Reserved23_IRQHandler
        B .  

        PUBWEAK DMA0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
DMA0_IRQHandler
        B .  
  
        PUBWEAK DMA0_Error_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
DMA0_Error_IRQHandler
        B . 

        PUBWEAK ERM_errors_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
ERM_errors_IRQHandler
        B . 

        PUBWEAK FXOSC_SXOSC_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
FXOSC_SXOSC_IRQHandler
        B .  
        
        PUBWEAK SWT_2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SWT_2_IRQHandler
        B .  

        PUBWEAK Reserved29_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
Reserved29_IRQHandler
        B .  

        PUBWEAK CMP0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
CMP0_IRQHandler
        B . 
        
        PUBWEAK PIT_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
PIT_IRQHandler
        B .  

        PUBWEAK SIUL2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SIUL2_IRQHandler
        B .  
       
        PUBWEAK SPI2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SPI2_IRQHandler
        B . 

        PUBWEAK ADC_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
ADC_IRQHandler
        B . 

        PUBWEAK SEG_LCD_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SEG_LCD_IRQHandler
        B .  
        
        PUBWEAK SMC_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SMC_IRQHandler
        B .  

        PUBWEAK SSD0_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SSD0_IRQHandler
        B .  

        PUBWEAK SSD1_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SSD1_IRQHandler
        B . 
        
        PUBWEAK SSD2_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SSD2_IRQHandler
        B .  

        PUBWEAK SSD3_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SSD3_IRQHandler
        B .  

        PUBWEAK SSD4_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SSD4_IRQHandler
        B . 

        PUBWEAK SSD5_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
SSD5_IRQHandler
        B . 

        PUBWEAK FTM_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
FTM_IRQHandler
        B .  
        
        PUBWEAK MC_ME_IOP_INT_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
MC_ME_IOP_INT_IRQHandler
        B .  

        PUBWEAK MC_RGM_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
MC_RGM_IRQHandler
        B .  

        PUBWEAK RTC_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
RTC_IRQHandler
        B . 
        
        PUBWEAK WKPU_IRQHandler
        SECTION .text:CODE:REORDER:NOROOT(1)
WKPU_IRQHandler
        B .  

        PUBWEAK DefaultISR
        SECTION .text:CODE:REORDER:NOROOT(1)
DefaultISR
        B .  
        
       END
