/*************************************************************************
*
* Freescale Confidential Proprietary
*
* Copyright (c) 2012-2013 Freescale Semiconductor;
* All Rights Reserved
*
**************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************/

//*** includes ****************************************************************
#include "VG/openvg.h"
#include "VG/vgext.h"

#include "ovgapp.h"
#include "picdata.h"

//*** defines *****************************************************************

#define IMAGE_SCALE		0.7F

//*** locals ******************************************************************
static VGPaint	fillPaint;
static VGImage	image;
static float	rotation;
static VGint 	x, sx, y, sy;

//*****************************************************************************

void OvgApp_Init(int width, int height)
{
    VGint color[4] = {0, 0, 1.0F, 1.0F}; 
	VGfloat fillColor[4] = {1.0f, 1.0F, 1.0F, 1.0F};
                                     
    vgSeti(VG_RENDERING_QUALITY, VG_RENDERING_QUALITY_BETTER);
	vgSetiv(VG_CLEAR_COLOR, 4, color);
      
    fillPaint = vgCreatePaint();    
	vgSetParameteri(fillPaint, VG_PAINT_TYPE, VG_PAINT_TYPE_COLOR);
    vgSetParameterfv(fillPaint, VG_PAINT_COLOR, 4, fillColor);
    vgSetPaint(fillPaint, VG_FILL_PATH);
    
    vgSeti(VG_BLEND_MODE, VG_BLEND_SRC_OVER);
	
    image = vgCreateImage(VG_sRGBA_8888, picdata_width, picdata_height, VG_IMAGE_QUALITY_BETTER);
    vgImageSubData(image, picdata, picdata_width * 4, VG_sRGBA_8888, 0, 0, picdata_width, picdata_height); 
	
	rotation = 0.0F;
	x = y = 0;
	sx = sy = 1;
} // OvgApp_Init()

/*--------------------------------------------------------------------------*/

void OvgApp_Draw(int width, int height)
{
	++rotation;
	
	x += sx;
	y += sy;
	
	if ((x > width) || (x < 0))
	{
		sx = -sx;
	}
	
	if ((y > height) || (y < 0))
	{
		sy = -sy;
	}

    vgClear(0, 0, width, height);
    
    vgSeti(VG_MATRIX_MODE, VG_MATRIX_IMAGE_USER_TO_SURFACE);
	vgLoadIdentity();
	vgTranslate(x, y);
	vgRotate(rotation);
	vgTranslate(-picdata_width * IMAGE_SCALE * 0.5F, -picdata_height * IMAGE_SCALE * 0.5F);
	vgScale(IMAGE_SCALE, IMAGE_SCALE);
	
    vgDrawImage(image);
	vgFinish();
} // OvgApp_Draw()

/*--------------------------------------------------------------------------*/

void OvgApp_Close()
{
    vgDestroyPaint(fillPaint);
    vgDestroyImage(image);
} // OvgApp_Close()

//*** EOF *********************************************************************
