/* hello.c				(c) 2015 Freescale Semiconductor, Inc.
 * Copyright 2017-2019 NXP
 * Descriptions: Minimal hello world example code with GPIO
 * 28 Sept 2015 Osvaldo Romero et al: Initial version
 */

#include "derivative.h" /* include peripheral declarations SKEAZ128M4 */

#define PTE7 7		 /* Port PTE7, bit 7: output to blue LED */
#define PTE4 4		 /* Port PTE4, bit 4: input from BTN0*/

int main(void) {

							/* Configure port E4 as GPIO input (BTN 0 [SW2] on EVB) */
	GPIOB_PDDR &= ~(1<<PTE4); /* Port E4: Data Direction= input (default) */
	GPIOB_PIDR &= ~(1<<PTE4); /* Port E4: Input Disable= 0 (input enabled) */
	PORT_PUE0 |= 0<<PTE4;	 /* Port E4: No internal pullup (default) */

							/* Configure port E7 as GPIO output (LED on EVB) */
	GPIOB_PDDR |= 1<<PTE7;	/* Port E7: Data Direction= output */
	GPIOB_PIDR &= 1<<PTE7;	/* Port E7: Input Disable= 1 (default) */

	for(;;) {
	if (GPIOB_PDIR & (1<<PTE4))	{	/* If Pad Data Input = 1 (BTN0 [SW2] not pushed) */
		GPIOB_PSOR |= 1<<PTE7;		/* Set Output on port E7 (LED off) */
	}
	else {							/* If BTN0 was pushed */
		GPIOB_PCOR |= 1<<PTE7;		/* Clear Output on port E7 (LED on) */
	}
	}
}
