/*************************************************************************
*
* Freescale Confidential Proprietary
*
* Copyright (c) 2012-2013 Freescale Semiconductor;
* All Rights Reserved
*
**************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.    
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************/
#include <stdlib.h>
#include <EGL/egl.h>
#include <mqx.h>
#include <bsp.h>
#include <fio.h>
#include <hdmi.h>

#include "fbws.h"
#include "ovgapp.h"

#define TOTAL_FRAME     10000

static void ovgApp(uint32_t aPara);

const TASK_TEMPLATE_STRUCT  MQX_template_list[] = 
{ 
    /* Task Index,   Function,   Stack,  Priority, Name,     Attributes,                                    Param, Time Slice */
    { 5,             ovgApp,     0x8000,   10,    "ovgApp",  MQX_FLOATING_POINT_TASK | MQX_AUTO_START_TASK, 0,     0 },
    { 0 }
};

static void ovgApp(uint32_t aPara)
{
    EGLNativeDisplayType fbdisp;
    EGLNativeWindowType fbwin;
    FbwsBufferInfo info;

    EGLint maj, min, num;
    EGLint r, g, b, a;
    EGLDisplay disp;
    EGLConfig  cfg[8];
    EGLContext ctx;
    EGLSurface surf;
    EGLBoolean ret;
    EGLint cfgAttribs[] = 
	{
        EGL_RED_SIZE,           8,
        EGL_GREEN_SIZE,         8,
        EGL_BLUE_SIZE,          8,
        EGL_ALPHA_SIZE,         8,
        EGL_DEPTH_SIZE,         0,
        EGL_RENDERABLE_TYPE,    EGL_OPENVG_BIT,
        EGL_NONE
    };
	int i;

    HDMI_config(0);
	
    if (!fbws_init())
    {
        printf("OVG initialize failed\n");
        return;
    }

    fbdisp = fbws_open_display(BSP_FBDEV_DEFAULT_DISPLAY, NULL);
    fbws_get_display_info(fbdisp, &info, NULL);
    fbwin = fbws_create_window(fbdisp, 0, 0, info.width, info.height);

    EGL_ERR_CHK(EGL_FALSE, ret, eglBindAPI(EGL_OPENVG_API));
    EGL_ERR_CHK(EGL_NO_DISPLAY, disp, eglGetDisplay(fbdisp));
    EGL_ERR_CHK(EGL_FALSE, ret, eglInitialize(disp, &maj, &min));

    /* Try to find out the exact configuration */
    EGL_ERR_CHK(EGL_FALSE, ret, eglChooseConfig(disp, cfgAttribs, cfg, sizeof(cfg)/sizeof(EGLConfig), &num));

    for (i=0; i<num; i++) 
	{
        eglGetConfigAttrib(disp, cfg[i], EGL_RED_SIZE, &r);
        eglGetConfigAttrib(disp, cfg[i], EGL_GREEN_SIZE, &g);
        eglGetConfigAttrib(disp, cfg[i], EGL_BLUE_SIZE, &b);
        eglGetConfigAttrib(disp, cfg[i], EGL_ALPHA_SIZE, &a);
		
        if (r == cfgAttribs[1] && g == cfgAttribs[3] && b == cfgAttribs[5] && a == cfgAttribs[7])
        {
            printf("Exact configuration found: %d/%d\n", i, num);
            break;
        }
    }

    if (i == num)
    {
        printf("Cannot find the exact configuration from total %d items, use the first configuration instead\n", num);
        i = 0;
    }

    EGL_ERR_CHK(EGL_NO_CONTEXT, ctx, eglCreateContext(disp, cfg[i], EGL_NO_CONTEXT, NULL));
    EGL_ERR_CHK(EGL_NO_SURFACE, surf, eglCreateWindowSurface(disp, cfg[i], fbwin, NULL));
    EGL_ERR_CHK(EGL_FALSE, ret, eglMakeCurrent(disp, surf, surf, ctx));

    OvgApp_Init(info.width, info.height);

    for (i = 0; i < TOTAL_FRAME; i++)
    {
        OvgApp_Draw(info.width, info.height);
        eglSwapBuffers(disp, surf);
    }

    OvgApp_Close();

    EGL_ERR_CHK(EGL_FALSE, ret, eglMakeCurrent(disp, EGL_NO_SURFACE, EGL_NO_SURFACE, EGL_NO_CONTEXT));
    EGL_ERR_CHK(EGL_FALSE, ret, eglDestroyContext(disp, ctx));
    EGL_ERR_CHK(EGL_FALSE, ret, eglDestroySurface(disp, surf));
    EGL_ERR_CHK(EGL_FALSE, ret, eglTerminate(disp));

    fbws_destroy_window(fbwin);
    fbws_close_display(fbdisp);
    fbws_fini();
} // ovgApp()

//*****************************************************************************
