/*************************************************************************
*
* Freescale Confidential Proprietary
*
* Copyright (c) 2012-2013 Freescale Semiconductor;
* All Rights Reserved
*
**************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.    
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************/

#include <EGL/egl.h>
#include <EGL/eglfsl.h>
#include <VG/OpenVG.h>

#include <mqx.h>
#include <bsp.h>
#include <fio.h>
#include <fbws.h>    /* for fbws_xxx stuffs */
#include <hdmi.h>


static void ovgApp(uint32_t aPara);

const TASK_TEMPLATE_STRUCT  MQX_template_list[] = 
{ 
    /* Task Index,   Function,   Stack,  Priority, Name,     Attributes,                                    Param, Time Slice */
    { 5,             ovgApp,     0x8000,   10,    "ovgApp",  MQX_FLOATING_POINT_TASK | MQX_AUTO_START_TASK, 0,     0 },
    { 0 }
};

//static EGLPbufferDimFSL offscreenFBDim = { 0 };

static void ovgApp(uint32_t aPara)
{
    int i;
    EGLNativeDisplayType fbdisp;
    EGLNativeWindowType fbwin;
    FbwsBufferInfo info;

    EGLint /*maj, min,*/ num;
    EGLint r, g, b, a;
    EGLDisplay disp;
    EGLConfig  cfg[8];
    EGLContext ctx;
    EGLSurface surf;
    EGLSurface surf_pb;
    VGImage img;
    EGLBoolean ret;
    EGLint     cfgAttribs[] = {
        EGL_RED_SIZE,           8,
        EGL_GREEN_SIZE,         8,
        EGL_BLUE_SIZE,          8,
        EGL_ALPHA_SIZE,         8,
        EGL_DEPTH_SIZE,         0,
        EGL_RENDERABLE_TYPE,    EGL_OPENVG_BIT,
        EGL_NONE
    };

    HDMI_config(0);
	
    if (!fbws_init())
    {
        //printf("OVG initialize failed\n");
        return;
    }

    fbdisp = fbws_open_display(BSP_FBDEV_DEFAULT_DISPLAY, NULL);

    fbwin = fbws_create_window(fbdisp, 0, 0, info.width, info.height);

    ret = eglBindAPI(EGL_OPENVG_API);
    disp = eglGetDisplay(fbdisp);
    ret = eglInitialize(disp, NULL, NULL /*&maj, &min*/);

    /* try to find out the exact config */
    ret = eglChooseConfig(disp, cfgAttribs, cfg, sizeof(cfg)/sizeof(EGLConfig), &num);

    for (i=0; i<num; i++) {
        eglGetConfigAttrib(disp, cfg[i], EGL_RED_SIZE, &r);
        eglGetConfigAttrib(disp, cfg[i], EGL_GREEN_SIZE, &g);
        eglGetConfigAttrib(disp, cfg[i], EGL_BLUE_SIZE, &b);
        eglGetConfigAttrib(disp, cfg[i], EGL_ALPHA_SIZE, &a);
        if (r == cfgAttribs[1] && g == cfgAttribs[3] && b == cfgAttribs[5] && a == cfgAttribs[7])
        {
            //printf("Exact config found: %d/%d\n", i, num);
            break;
        }
    }

    if (i == num)
    {
        //printf("Cannot find the exact config from total %d items, use the first config instead\n", num);
        i = 0;
    }
    ctx = eglCreateContext(disp, cfg[i], EGL_NO_CONTEXT, NULL);
    surf = eglCreateWindowSurface(disp, cfg[i], fbwin, NULL);
    ret = eglMakeCurrent(disp, surf, surf, ctx);
    
    img = vgCreateImage( VG_sRGBA_8888, 320, 240, VG_IMAGE_QUALITY_BETTER );
    surf_pb = eglCreatePbufferFromClientBuffer( disp, EGL_OPENVG_IMAGE, (EGLClientBuffer)img, cfg[i], NULL );



    // do nothing

    

    ret = eglMakeCurrent(disp, EGL_NO_SURFACE, EGL_NO_SURFACE, EGL_NO_CONTEXT);
    ret = eglDestroySurface(disp, surf_pb);
    vgDestroyImage( img );
    ret = eglDestroyContext(disp, ctx);
    ret = eglDestroySurface(disp, surf);
    ret = eglTerminate(disp);

    fbws_destroy_window(fbwin);
    fbws_close_display(fbdisp);

    fbws_fini();
	
	if (ret == 0)
	{
		return;
	}
}
