#include "VG/openvg.h"
#include "VG/vgu.h"

#include "mqx.h"
#include "fio.h"

#include "ovgapp.h"

/*****************************************************************************
 *  local defines
 ****************************************************************************/

/*****************************************************************************
 *  local types
 ****************************************************************************/

/*****************************************************************************
 *  local prototypes
 ****************************************************************************/

/*****************************************************************************
 *  exported variables
 ****************************************************************************/

VGImage image = VG_INVALID_HANDLE;

/*****************************************************************************
 *  local variables
 ****************************************************************************/

static VGPath ellipse = VG_INVALID_HANDLE;
static VGPaint paint = VG_INVALID_HANDLE;

static int rot_angle = 0;

/*****************************************************************************
 *  local functions
 ****************************************************************************/

void OvgApp_Init(void)
{
    vgSeti(VG_RENDERING_QUALITY, VG_RENDERING_QUALITY_BETTER);
    vgSeti(VG_IMAGE_QUALITY, VG_IMAGE_QUALITY_BETTER);

    image = vgCreateImage( VG_sRGBA_8888, PBUF_WIDTH, PBUF_HEIGHT, VG_IMAGE_QUALITY_BETTER );

    ellipse = vgCreatePath( VG_PATH_FORMAT_STANDARD, VG_PATH_DATATYPE_F, 1, 0, 0, 0, VG_PATH_CAPABILITY_ALL );
    vguEllipse( ellipse, 60, 20, 110, 30 );
    paint = vgCreatePaint();
    vgSetParameteri(paint, VG_PAINT_TYPE, VG_PAINT_TYPE_COLOR);
    vgSetColor(paint, 0xFFFFFFFF);
}

void OvgApp_Draw(int width, int height)
{
    vgClear( 0, 0, width, height );
    vgLoadIdentity();
    vgTranslate( 220, 68 );
    vgRotate( rot_angle );
    vgTranslate( -60, -20 );
    vgDrawImage( image );
    
    vgFinish();
    
    ++rot_angle;
    rot_angle %= 360;
}

void OvgApp_Draw_PB(int width, int height)
{
    vgClear(0, 0, width, height);

    vgSetPaint( paint, VG_STROKE_PATH );
    vgSetPaint( paint, VG_FILL_PATH );
    vgDrawPath( ellipse, VG_STROKE_PATH );

    vgFinish();
}

void OvgApp_Close(void)
{
    vgDestroyPath( ellipse );
    vgDestroyPaint( paint );
    vgDestroyImage( image );
} // OvgApp_Close()


