/*************************************************************************
*
* Freescale Confidential Proprietary
*
* Copyright (c) 2012-2013 Freescale Semiconductor;
* All Rights Reserved
*
**************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.    
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
**************************************************************************/

#include <EGL/egl.h>
#include <EGL/eglfsl.h>
#include <VG/OpenVG.h>

#include <mqx.h>
#include <bsp.h>
#include <fio.h>

#include <fbws.h>    /* for fbws_xxx stuffs */
#include <hdmi.h>
#include "ovgapp.h"

static void ovgApp(uint32_t aPara);

/*
#define gcvLEVEL_NONE           -1
#define gcvLEVEL_ERROR          0
#define gcvLEVEL_WARNING        1
#define gcvLEVEL_INFO           2
#define gcvLEVEL_VERBOSE        3

#define gcvZONE_NONE            0
#define gcvZONE_ALL             0x0FFFFFFF
*/
/*
extern void gcoOS_SetDebugLevelZone(uint32_t Level, uint32_t Zone);
extern void gckOS_SetDebugLevelZone(uint32_t Level, uint32_t Zone);
*/

const TASK_TEMPLATE_STRUCT  MQX_template_list[] = 
{ 
    /* Task Index,   Function,   Stack,  Priority, Name,     Attributes,                                    Param, Time Slice */
    { 5,             ovgApp,     0x8000,   10,    "ovgApp",  MQX_FLOATING_POINT_TASK | MQX_AUTO_START_TASK, 0,     0 },
    { 0 }
};

//static EGLPbufferDimFSL offscreenFBDim = { 0 };

extern VGImage image;

static void ovgApp(uint32_t aPara)
{
    int i;
    EGLNativeDisplayType fbdisp;
    EGLNativeWindowType fbwin;
    FbwsBufferInfo info;

    EGLint /*maj, min,*/ num;
    EGLint r, g, b, a;
    EGLDisplay disp;
    EGLConfig  cfg[8];
    EGLContext ctx;
    EGLSurface surf;

    EGLBoolean ret;
    EGLint     cfgAttribs[] = {
        EGL_RED_SIZE,           8,
        EGL_GREEN_SIZE,         8,
        EGL_BLUE_SIZE,          8,
        EGL_ALPHA_SIZE,         8,
        EGL_DEPTH_SIZE,         0,
        EGL_RENDERABLE_TYPE,    EGL_OPENVG_BIT,
        EGL_NONE
    };

    /* dump all HAL warnings and errors at user space */
    //gcoOS_SetDebugLevelZone(1, 0x0FFFFFFF);
    /* dump all HAL warnings and errors at kernel space */
    //gckOS_SetDebugLevelZone(1, 0x0FFFFFFF);

	HDMI_config(0);
	
    if (!fbws_init())
    {
        //printf("OVG initialize failed\n");
        return;
    }

    fbdisp = fbws_open_display(BSP_FBDEV_DEFAULT_DISPLAY, NULL);
    fbws_get_display_info(fbdisp, &info, NULL);

    fbwin = fbws_create_window(fbdisp, 0, 0, info.width, info.height);

    ret = eglBindAPI(EGL_OPENVG_API);
    disp = eglGetDisplay(fbdisp);
    ret = eglInitialize(disp, NULL, NULL /*&maj, &min*/);

    /* try to find out the exact config */
    ret = eglChooseConfig(disp, cfgAttribs, cfg, sizeof(cfg)/sizeof(EGLConfig), &num);

    for (i=0; i<num; i++) 
	{
        eglGetConfigAttrib(disp, cfg[i], EGL_RED_SIZE, &r);
        eglGetConfigAttrib(disp, cfg[i], EGL_GREEN_SIZE, &g);
        eglGetConfigAttrib(disp, cfg[i], EGL_BLUE_SIZE, &b);
        eglGetConfigAttrib(disp, cfg[i], EGL_ALPHA_SIZE, &a);
        if (r == cfgAttribs[1] && g == cfgAttribs[3] && b == cfgAttribs[5] && a == cfgAttribs[7])
        {
            //printf("Exact config found: %d/%d\n", i, num);
            break;
        }
    }

    if (i == num)
    {
        //printf("Cannot find the exact config from total %d items, use the first config instead\n", num);
        i = 0;
    }
    ctx = eglCreateContext(disp, cfg[i], EGL_NO_CONTEXT, NULL);
    surf = eglCreateWindowSurface(disp, cfg[i], fbwin, NULL);
    ret = eglMakeCurrent(disp, surf, surf, ctx);
    
    OvgApp_Init();
 
    {
        EGLSurface m_pbuf = 0;
        m_pbuf = eglCreatePbufferFromClientBuffer( disp, EGL_OPENVG_IMAGE, (EGLClientBuffer)image, cfg[i], 0 );
        eglMakeCurrent(disp, m_pbuf, m_pbuf, ctx);
        OvgApp_Draw_PB(PBUF_WIDTH, PBUF_HEIGHT);
        eglMakeCurrent(disp, surf, surf, ctx);
        eglDestroySurface( disp, m_pbuf );
    }

    vgSeti(VG_MATRIX_MODE, VG_MATRIX_IMAGE_USER_TO_SURFACE);
    for( ;; )
    {
        OvgApp_Draw( OVG_WIDTH, OVG_HEIGHT );
        eglSwapBuffers( disp, surf );
    }
    OvgApp_Close();

    ret = eglMakeCurrent(disp, EGL_NO_SURFACE, EGL_NO_SURFACE, EGL_NO_CONTEXT);
    ret = eglDestroyContext(disp, ctx);
    ret = eglDestroySurface(disp, surf);
    ret = eglTerminate(disp);

    fbws_destroy_window(fbwin);
    fbws_close_display(fbdisp);

    fbws_fini();
	
	if (ret == 0)
	{
		return;
	}
}