; ---------------------------------------------------------------------------------------
;  @file:    startup_MAC57D54H_M0p.s
;  @purpose: CMSIS Cortex-M0P Core Device Startup File
;            MAC57D54H
;  @version: 1.7
;  @date:    2015-10-21
;  @build:   b151027
; ---------------------------------------------------------------------------------------
;
; Copyright (c) 1997 - 2015 , Freescale Semiconductor, Inc.
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without modification,
; are permitted provided that the following conditions are met:
;
; o Redistributions of source code must retain the above copyright notice, this list
;   of conditions and the following disclaimer.
;
; o Redistributions in binary form must reproduce the above copyright notice, this
;   list of conditions and the following disclaimer in the documentation and/or
;   other materials provided with the distribution.
;
; o Neither the name of Freescale Semiconductor, Inc. nor the names of its
;   contributors may be used to endorse or promote products derived from this
;   software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
; ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
; ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
; (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;*****************************************************************************
;* Version: GHS for ARM Embedded Processors                                  *
;*****************************************************************************
    .text

    .need DefaultISR
    .globl DefaultISR

    .thumb

    .section .isr_vector, "a"
    .align 2
    .globl __isr_vector
__isr_vector:
    .long   __StackTop                                      ; Top of Stack
    .long   Reset_Handler

    .long   NMI_Handler                                   ;NMI Handler
    .long   HardFault_Handler                             ;Hard Fault Handler
    .long   0                            
    .long   0                            
    .long   0                            
    .long   0                                               ; Reserved
    .long   0                                               ; Reserved
    .long   0                                               ; Reserved
    .long   0                                               ; Reserved
    .long   SVC_Handler                                     ; SVCall Handler
    .long   0                                               ; Reserved
    .long   0                                               ; Reserved
    .long   PendSV_Handler                                  ; PendSV Handler
    .long   SysTick_Handler                                 ; SysTick Handler

                                                            ; External Interrupts
    .long   CPU2CPU_int0_IRQHandler                         ; CPU to CPU int0 interrupt
    .long   CPU2CPU_int1_IRQHandler                         ; CPU to CPU int1 interrupt
    .long   CPU2CPU_int2_IRQHandler                         ; CPU to CPU int2 interrupt
    .long   CPU2CPU_int3_IRQHandler                         ; CPU to CPU int3 interrupt
    .long   Reserved20_IRQHandler                           ; Reserved interrupt
    .long   Directed_CM0_IRQHandler                         ; Directed CM0+ interrupt
    .long   Reserved22_IRQHandler                           ; Reserved interrupt   
    .long   Reserved23_IRQHandler                           ; Reserved interrupt     
    .long   DMA0_IRQHandler                                 ; DMA transfer complete channels 0-15 
    .long   DMA0_Error_IRQHandler                           ; DMA error interrupt channels 0-15
    .long   ERM_errors_IRQHandler                           ; CM4, SRAM, GRAM, IOP RAM, or Flash ECC/ Parity errors
    .long   FXOSC_SXOSC_IRQHandler                          ; Fast External Oscillator/Slow external oscillator
    .long   SWT_2_IRQHandler                                ; Watchdog for CM0+ core
    .long   Reserved29_IRQHandler                           ; Reserved interrupt
    .long   CMP0_IRQHandler                                 ; Analog Comparator_0
    .long   PIT_IRQHandler                                  ; Peridoc Interrupt Timer
    .long   SIUL2_IRQHandler                                ; System Integration Unit
    .long   SPI2_IRQHandler                                 ; Deserial Serial Peripheral Interface    
    .long   ADC_IRQHandler                                  ; Analog to digital converter  
    .long   SEG_LCD_IRQHandler                              ; Segment LCD controller  
    .long   SMC_IRQHandler                                  ; Stepper Motor Controller  
    .long   SSD0_IRQHandler                                 ; Stepper Stall detect 0  
    .long   SSD1_IRQHandler                                 ; Stepper Stall detect 1  
    .long   SSD2_IRQHandler                                 ; Stepper Stall detect 2  
    .long   SSD3_IRQHandler                                 ; Stepper Stall detect 3  
    .long   SSD4_IRQHandler                                 ; Stepper Stall detect 4  
    .long   SSD5_IRQHandler                                 ; Stepper Stall detect 5  
    .long   FTM_IRQHandler                                  ; Flex Timer 0   
    .long   MC_ME_IOP_INT_IRQHandler                        ; Magic Carpet Mode Entry / IOP_INT 
    .long   MC_RGM_IRQHandler                               ; Magic Carpet Reset Generation 
    .long   RTC_IRQHandler                                  ; real time clock 
    .long   WKPU_IRQHandler                                 ; Wake up unit 

    .size    __isr_vector, . - __isr_vector

    .text
    .thumb

; Reset Handler
    .thumb
    .align 4
    .globl   Reset_Handler
    .weak    Reset_Handler
    .type    Reset_Handler, $function
Reset_Handler:
    cpsid   i               ; Mask interrupts

    ; Init the rest of the registers
    ldr     r1,=0
    ldr     r2,=0
    ldr     r3,=0
    ldr     r4,=0
    ldr     r5,=0
    ldr     r6,=0
    ldr     r7,=0
    mov     r8,r7
    mov     r9,r7
    mov     r10,r7
    mov     r11,r7
    mov     r12,r7

    ; Initialize the stack pointer
    ldr     r0,=__StackTop
    mov     r13,r0

    ; Init .data and .bss sections
    cpsie   i               ; Unmask interrupts


#ifndef __NO_STARTUP_CLEAR_BSS
;     This part of work usually is done in C library startup code. Otherwise,
;     define this macro to enable it in this startup.
;
;     Loop to zero out BSS section, which uses following symbols
;     in linker script:
;      __bss_start__: start of BSS section. Must align to 4
;      __bss_end__: end of BSS section. Must align to 4 */

    ldr r1, =__bss_start__
    ldr r2, =__bss_end__

    subs    r2, r1
    ble .LC3

    movs    r0, 0
.LC2:
    str r0, [r1, r2]
    subs    r2, 4
    bge .LC2
.LC3:

#endif


    bl    main
    .ltorg
    .size Reset_Handler, . - Reset_Handler

    .align	1
    .thumb
    .weak	Default_Handler
    .type    Default_Handler, $function
Default_Handler:
     b	.
     .size	Default_Handler, . - Default_Handler

;    Macro to define default handlers. Default handler
;    will be weak symbol and just dead loops. They can be
;    overwritten by other handlers
     .macro	def_irq_handler	handler_name
     .weak	handler_name
     .set	handler_name, Default_Handler
     .endm

; Exception Handlers

    def_irq_handler    NMI_Handler                
    def_irq_handler    HardFault_Handler          
    def_irq_handler    SVC_Handler                
    def_irq_handler    PendSV_Handler             
    def_irq_handler    SysTick_Handler            
    def_irq_handler    CPU2CPU_int0_IRQHandler                   
    def_irq_handler    CPU2CPU_int1_IRQHandler                   
    def_irq_handler    CPU2CPU_int2_IRQHandler                   
    def_irq_handler    CPU2CPU_int3_IRQHandler                   
    def_irq_handler    Reserved20_IRQHandler                     
    def_irq_handler    Directed_CM0_IRQHandler                   
    def_irq_handler    Reserved22_IRQHandler                     
    def_irq_handler    Reserved23_IRQHandler                     
    def_irq_handler    DMA0_IRQHandler                           
    def_irq_handler    DMA0_Error_IRQHandler                     
    def_irq_handler    ERM_errors_IRQHandler                     
    def_irq_handler    FXOSC_SXOSC_IRQHandler                    
    def_irq_handler    SWT_2_IRQHandler                          
    def_irq_handler    Reserved29_IRQHandler                     
    def_irq_handler    CMP0_IRQHandler                           
    def_irq_handler    PIT_IRQHandler                            
    def_irq_handler    SIUL2_IRQHandler                          
    def_irq_handler    SPI2_IRQHandler                           
    def_irq_handler    ADC_IRQHandler                            
    def_irq_handler    SEG_LCD_IRQHandler                        
    def_irq_handler    SMC_IRQHandler                            
    def_irq_handler    SSD0_IRQHandler                           
    def_irq_handler    SSD1_IRQHandler                           
    def_irq_handler    SSD2_IRQHandler                           
    def_irq_handler    SSD3_IRQHandler                           
    def_irq_handler    SSD4_IRQHandler                           
    def_irq_handler    SSD5_IRQHandler                           
    def_irq_handler    FTM_IRQHandler                            
    def_irq_handler    MC_ME_IOP_INT_IRQHandler                  
    def_irq_handler    MC_RGM_IRQHandler                         
    def_irq_handler    RTC_IRQHandler                            
    def_irq_handler    WKPU_IRQHandler                           
    def_irq_handler    DefaultISR                       
                       
    .end
