/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.internal;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.ISDKFilter;
import com.freescale.s32ds.cross.sdk.SDKHeader;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.SDKUtils;
import com.freescale.s32ds.cross.sdk.TCHolder;
import com.freescale.s32ds.cross.sdk.internal.IFilterOptions;
import com.freescale.s32ds.cross.sdk.internal.StorableSDK;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class ImportSDK
extends StorableSDK {
    private static final String IMPORT_SDKS_PREF_KEY = String.valueOf(SDKSupportPlugin.getUniqueIdentifier()) + ".importedSDKs";
    private static final ISDKFilter IMPORT_FILTER = new ISDKFilter(){

        @Override
        public boolean accept(ISDK sdk) {
            return sdk instanceof ImportSDK;
        }
    };

    public ImportSDK(SDKHeader head, TCHolder root, IFilterOptions filterOptions, TCHolder[] hs, String path) {
        super(head, root, filterOptions, hs);
        this.type = ISDK.TYPE.IMPORTED;
    }

    @Override
    public ISDK.STATUS getStatus() {
        return ISDK.STATUS.IMPORT;
    }

    @Override
    public void stateChange(int mode, boolean after, Object cfg, String path) {
    }

    public static void storeImportSDKs() {
        try {
            IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(SDKSupportPlugin.getUniqueIdentifier());
            prefs.put(IMPORT_SDKS_PREF_KEY, ImportSDK.getSDKsString(SDKUtils.filter(IMPORT_FILTER)));
            prefs.flush();
        }
        catch (BackingStoreException bse) {
            SDKSupportPlugin.error(bse);
        }
    }

    public static void loadImportSDKs() {
        String sdksString = Platform.getPreferencesService().getString(SDKSupportPlugin.getUniqueIdentifier(), IMPORT_SDKS_PREF_KEY, "", null);
        ImportSDK.parseSDKsString(sdksString, null, 6);
    }
}

