/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.processors;

import com.freescale.s32ds.cross.sdk.ISDK;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.processors.ISourcePathProcessor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public abstract class Processor
implements ISourcePathProcessor {
    private static final String PRJ_FILES_BAK_EXTENSION = ".prjbak";
    private static final String SDK_FILES_BAK_EXTENSION = ".sdkbak";
    protected boolean isBackupFiles;
    protected ISDK sdk;

    @Override
    public void folder(IFolder f) {
        try {
            this.touchFolder(f);
        }
        catch (Exception e) {
            SDKSupportPlugin.error(e);
        }
    }

    @Override
    public void file(IFile f, IPath path) {
        try {
            this.touchFile(f, path);
        }
        catch (Exception e) {
            SDKSupportPlugin.error(e);
        }
    }

    public abstract void touchFolder(IFolder var1) throws Exception;

    public abstract void touchFile(IFile var1, IPath var2) throws Exception;

    protected void createPRJBackupFile(IFile f, IPath p) throws Exception {
        String fileName = String.valueOf(f.getProjectRelativePath().lastSegment()) + PRJ_FILES_BAK_EXTENSION;
        IFile backupFile = this.getBackupFile(f, fileName);
        if (backupFile != null) {
            f.move(backupFile.getFullPath(), true, null);
        }
    }

    protected void createSDKBackupFile(IFile f, IPath p) throws Exception {
        String fileName = String.valueOf(f.getProjectRelativePath().lastSegment()) + SDK_FILES_BAK_EXTENSION;
        IFile backupFile = this.getBackupFile(f, fileName);
        if (backupFile != null) {
            this.createFile(backupFile, p);
        }
    }

    protected void createFile(IFile f, IPath p) throws CoreException, IOException, FileNotFoundException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedInputStream content = new BufferedInputStream(new FileInputStream(p.toOSString()));){
            f.create((InputStream)content, true, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private IFile getBackupFile(IFile f, String backupFilenamePrefix) {
        IFile backupFile = null;
        IContainer parent = f.getParent();
        int counter = 0;
        while ((backupFile = parent.getFile((IPath)new Path(String.valueOf(backupFilenamePrefix) + counter++))).exists()) {
        }
        return backupFile;
    }
}

