/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.sdk.ui.internal;

import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class GitDialog
extends Dialog {
    private static final String DIALOG_TITLE = "GIT Source Selection";
    private static final String GIT_PATH = "Git URI:";
    public static final String DELIMITER = "!";
    private static final String GIT_KEY = "GIT_REMOTE_KEY";
    private static final int TEXT_LENGTH = 500;
    private static final int MAX_HISTORY = 5;
    private Shell shell;
    private Combo gpath;
    private Text gitBranch;
    private Button bOk;
    private String result = null;

    public GitDialog(Shell parent) {
        super(parent, 32768);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 67680);
        this.shell.setText(DIALOG_TITLE);
        this.createContents((Composite)this.shell);
        Rectangle r1 = parent.getBounds();
        Rectangle r2 = this.shell.getBounds();
        int x = r1.x + (r1.width - r2.width) / 2;
        int y = r1.y + (r1.height - r2.height) / 2;
        this.shell.setBounds(x, y, r2.width, r2.height);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private Combo fillCombo(Composite c, String key, String label) {
        IEclipsePreferences p = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support");
        Label l = new Label(c, 0);
        l.setText(label);
        l.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Combo x = new Combo(c, 2052);
        GridData g = new GridData(4, 0x1000000, true, false);
        g.minimumWidth = 500;
        g.widthHint = 500;
        x.setLayoutData((Object)g);
        x.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GitDialog.this.bOk != null) {
                    GitDialog.this.bOk.setEnabled(!x.getText().trim().isEmpty());
                }
            }
        });
        x.setText(p.get(key, ""));
        int i = 1;
        while (i <= 5) {
            String s = p.get(String.valueOf(key) + '_' + Integer.toString(i), null);
            if (s != null) {
                x.add(s);
            }
            ++i;
        }
        return x;
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout());
        Label msg = new Label(c, 0);
        msg.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        msg.setText(Messages.SDKDialog_folder_selection_dialog_header_text);
        this.gpath = this.fillCombo(c, GIT_KEY, GIT_PATH);
        Label lab = new Label(parent, 0);
        lab.setText("Use GIT Branch");
        lab.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.gitBranch = new Text(parent, 2052);
        this.gitBranch.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.gitBranch.setText("master");
        Composite b = new Composite(parent, 0);
        b.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        b.setLayout((Layout)new GridLayout(4, true));
        this.bOk = this.setupButton(b, IDialogConstants.OK_LABEL, true);
        this.setupButton(b, IDialogConstants.CANCEL_LABEL, false);
        this.shell.pack();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.gpath, "com.freescale.s32ds.cross.sdk.support.SDK_GIT_REM_context");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.shell, "com.freescale.s32ds.cross.sdk.support.SDK_GIT_context");
        return c;
    }

    protected Button setupButton(Composite c, String text, final boolean isOk) {
        Button b = new Button(c, 8);
        b.setText(text);
        b.setLayoutData((Object)new GridData(4, 2, true, false));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (isOk) {
                    GitDialog.this.result = GitDialog.this.gpath.getText().trim();
                    GitDialog.this.saveHistory(GitDialog.GIT_KEY, GitDialog.this.result, GitDialog.this.gpath);
                    GitDialog gitDialog = GitDialog.this;
                    gitDialog.result = String.valueOf(gitDialog.result) + GitDialog.DELIMITER + GitDialog.this.gitBranch.getText().trim() + GitDialog.DELIMITER;
                }
                GitDialog.this.shell.dispose();
            }
        });
        return b;
    }

    private void saveHistory(String key, String dir, Combo c) {
        IEclipsePreferences p = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.sdk.support");
        ArrayList<String> lst = new ArrayList<String>();
        int i = 1;
        while (i <= 5) {
            String s = p.get(String.valueOf(key) + '_' + Integer.toString(i), null);
            if (s != null) {
                lst.add(s);
            }
            ++i;
        }
        if (lst.contains(dir)) {
            lst.remove(dir);
        }
        lst.add(0, dir);
        while (c.getItemCount() > 0) {
            c.remove(0);
        }
        p.put(key, dir);
        i = 1;
        while (i <= lst.size() && i <= 5) {
            String x = (String)lst.get(i - 1);
            p.put(String.valueOf(key) + '_' + Integer.toString(i), x);
            c.add(x);
            try {
                p.flush();
            }
            catch (Exception e) {
                SDKSupportPlugin.error(e);
            }
            ++i;
        }
    }
}

