/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms.chip.widget;

import com.pemicro.forms.chip.ChipStyle;
import com.pemicro.forms.chip.data.ChipData;
import com.pemicro.forms.chip.data.PinData;
import com.pemicro.forms.chip.widget.Pin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class Chip {
    private Canvas leftSideCanvas;
    private Canvas bottomSideCanvas;
    private Canvas rightSideCanvas;
    private Canvas topSideCanvas;
    Map<Integer, Pin> pins = new HashMap<Integer, Pin>();
    private ChipData data;
    private Canvas core;
    private int numOfPins;
    private int numOfSides;
    private Canvas chipCanvas;
    private Label leftFirstPin;
    private Label leftLastPin;
    private Label bottomFirstPin;
    private Label bottomLastPin;
    private Label rightFirstPin;
    private Label rightLastPin;
    private Label topFirstPin;
    private Label topLastPin;
    private Label topRightCorner;
    private Label topLeftCorner;
    private Label bottomRightCorner;
    private Label bottomLeftCorner;
    private Label[] leftSide;
    private Label[] bottomSide;
    private Label[] rightSide;
    private Label[] topSide;
    private Canvas innerChip;
    private Label info1Label;
    private Label info2Label;
    private Label info3Label;
    private Label info4Label;
    private String info1 = "";
    private String info2 = "";
    private String info3 = "";
    private String info4 = "";
    protected boolean isOpened;

    public Canvas getInnerChip() {
        return this.innerChip;
    }

    public void setDeviceName(String deviceName) {
        this.info1 = deviceName;
        this.info1Label.setText(this.info1);
        this.info1Label.pack();
        this.info1Label.setLocation(ChipStyle.centerX((Control)this.info1Label, (Control)this.innerChip), this.info1Label.getLocation().y);
        if (this.info1Label.getSize().x + this.info1Label.getSize().x > this.innerChip.getSize().x || this.info1Label.getSize().y > this.innerChip.getSize().y) {
            this.info1Label.setVisible(false);
        }
    }

    public String getDeviceName() {
        return this.info1;
    }

    public void setFreq(String freq) {
        this.info2 = freq;
        this.info2Label.setText(this.info2);
        this.info2Label.pack();
        this.info2Label.setLocation(ChipStyle.centerX((Control)this.info2Label, (Control)this.innerChip), this.info2Label.getLocation().y);
        if (this.info2Label.getSize().x + this.info2Label.getSize().x > this.innerChip.getSize().x || this.info2Label.getSize().y > this.innerChip.getSize().y) {
            this.info2Label.setVisible(false);
        }
    }

    public String getFreq() {
        return this.info2;
    }

    public void setCycles(String cycles) {
        this.info3 = cycles;
        this.info3Label.setText(this.info3);
        this.info3Label.pack();
        this.info3Label.setLocation(ChipStyle.centerX((Control)this.info3Label, (Control)this.innerChip), this.info3Label.getLocation().y);
        if (this.info3Label.getSize().x + this.info3Label.getSize().x > this.innerChip.getSize().x || this.info3Label.getSize().y > this.innerChip.getSize().y) {
            this.info3Label.setVisible(false);
        }
    }

    public String getCycles() {
        return this.info3;
    }

    public Chip(Composite parent, ChipData chipData) {
        Pin pin;
        PinData pinData;
        Pin pin2;
        PinData pinData2;
        int i;
        FontData fontData = ChipStyle.CHIP_WINDOW_TEXT_FONT.getFontData()[0];
        fontData.setHeight(fontData.getHeight() - 1);
        Font markerFont = new Font((Device)parent.getDisplay(), fontData);
        if (this.chipCanvas == null || this.chipCanvas.isDisposed()) {
            this.chipCanvas = new Canvas(parent, 0);
        }
        this.chipCanvas.setVisible(false);
        this.data = chipData;
        this.numOfPins = chipData.getNumOfPins();
        this.numOfSides = chipData.getNumOfSides();
        int pinsPerSide = this.numOfPins / this.numOfSides;
        GridLayout layout = new GridLayout(5, false);
        layout.marginTop = 20;
        layout.marginLeft = 20;
        layout.marginRight = 20;
        layout.marginBottom = 20;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.chipCanvas.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 1024, true, true);
        layoutData.horizontalSpan = 2;
        this.topLastPin = new Label((Composite)this.chipCanvas, 131072);
        this.topLastPin.setForeground(ChipStyle.TEXT_COLOR);
        this.topLastPin.setVisible(this.numOfSides == 4);
        if (this.numOfSides == 4) {
            this.topLastPin.setText(Integer.toString(this.numOfPins * 4 / 4));
            this.topLastPin.setFont(ChipStyle.CHIP_WINDOW_TEXT_FONT);
        }
        this.topLastPin.setLayoutData((Object)layoutData);
        this.topLastPin.setFont(markerFont);
        layoutData = new GridData(0x1000000, 1024, true, true);
        this.topSideCanvas = new Canvas((Composite)this.chipCanvas, 0);
        layout = new GridLayout(pinsPerSide, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = -1;
        this.topSideCanvas.setLayout((Layout)layout);
        this.topSideCanvas.setVisible(this.numOfSides == 4);
        if (this.numOfSides == 4) {
            i = 3 * pinsPerSide;
            while (i < this.numOfPins) {
                pinData2 = chipData.getPinData()[i];
                pin2 = new Pin((Composite)this.topSideCanvas, 768);
                pin2.getCanvas().moveAbove(null);
                pin2.setPinData(pinData2);
                this.pins.put(i, pin2);
                ++i;
            }
        }
        this.topSideCanvas.setLayoutData((Object)layoutData);
        this.topSideCanvas.pack();
        layoutData = new GridData(4, 1024, true, true);
        layoutData.horizontalSpan = 2;
        this.topFirstPin = new Label((Composite)this.chipCanvas, 16384);
        this.topFirstPin.setForeground(ChipStyle.TEXT_COLOR);
        this.topFirstPin.setLayoutData((Object)layoutData);
        this.topFirstPin.setVisible(this.numOfSides == 4);
        if (this.numOfSides == 4) {
            this.topFirstPin.setText(Integer.toString(this.numOfPins * 3 / 4 + 1));
            this.topFirstPin.setFont(markerFont);
        }
        this.leftFirstPin = new Label((Composite)this.chipCanvas, 0);
        this.leftFirstPin.setForeground(ChipStyle.TEXT_COLOR);
        this.leftFirstPin.setText(Integer.toString(1));
        this.leftFirstPin.setFont(markerFont);
        this.leftFirstPin.setLayoutData((Object)new GridData(131072, 1024, true, false));
        this.drawCore(this.numOfSides, pinsPerSide);
        this.rightLastPin = new Label((Composite)this.chipCanvas, 0);
        this.rightLastPin.setForeground(ChipStyle.TEXT_COLOR);
        this.rightLastPin.setFont(markerFont);
        if (this.numOfSides == 4) {
            this.rightLastPin.setText(Integer.toString(this.numOfPins * 3 / 4));
        } else {
            this.rightLastPin.setText(Integer.toString(this.numOfPins * 2 / 2));
        }
        layoutData = new GridData(131072, 0x1000000, true, true);
        this.leftSideCanvas = new Canvas((Composite)this.chipCanvas, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = -1;
        this.leftSideCanvas.setLayout((Layout)layout);
        i = 0;
        while (i < pinsPerSide) {
            pinData2 = chipData.getPinData()[i];
            pin2 = new Pin((Composite)this.leftSideCanvas, 0);
            pin2.setPinData(pinData2);
            this.pins.put(i, pin2);
            ++i;
        }
        this.leftSideCanvas.setLayoutData((Object)layoutData);
        this.rightSideCanvas = new Canvas((Composite)this.chipCanvas, 0);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = -1;
        this.rightSideCanvas.setLayout((Layout)layout);
        int factor = 1;
        if (this.numOfSides == 4) {
            factor = 2;
        }
        int i2 = factor * pinsPerSide;
        while (i2 < (factor + 1) * pinsPerSide) {
            pinData = chipData.getPinData()[i2];
            pin = new Pin((Composite)this.rightSideCanvas, 512);
            pin.getCanvas().moveAbove(null);
            pin.setPinData(pinData);
            this.pins.put(i2, pin);
            ++i2;
        }
        this.rightSideCanvas.setLayoutData((Object)new GridData(16384, 0x1000000, true, true));
        this.leftLastPin = new Label((Composite)this.chipCanvas, 0);
        this.leftLastPin.setForeground(ChipStyle.TEXT_COLOR);
        this.leftLastPin.setText(Integer.toString(this.numOfPins / this.numOfSides));
        this.leftLastPin.setFont(markerFont);
        this.leftLastPin.setLayoutData((Object)new GridData(131072, 128, true, true));
        this.rightFirstPin = new Label((Composite)this.chipCanvas, 0);
        this.rightFirstPin.setForeground(ChipStyle.TEXT_COLOR);
        this.rightFirstPin.setFont(markerFont);
        if (this.numOfSides == 4) {
            this.rightFirstPin.setText(Integer.toString(this.numOfPins * 2 / 4 + 1));
        } else {
            this.rightFirstPin.setText(Integer.toString(this.numOfPins / 2 + 1));
        }
        this.rightFirstPin.setLayoutData((Object)new GridData(16384, 128, true, true));
        layoutData = new GridData(131072, 128, true, false);
        layoutData.horizontalSpan = 2;
        this.bottomFirstPin = new Label((Composite)this.chipCanvas, 0);
        this.bottomFirstPin.setForeground(ChipStyle.TEXT_COLOR);
        this.bottomFirstPin.setLayoutData((Object)layoutData);
        this.bottomFirstPin.setVisible(this.numOfSides == 4);
        this.bottomFirstPin.setFont(markerFont);
        if (this.numOfSides == 4) {
            this.bottomFirstPin.setText(Integer.toString(this.numOfPins / 4 + 1));
        }
        layoutData = new GridData(0x1000000, 128, true, true);
        this.bottomSideCanvas = new Canvas((Composite)this.chipCanvas, 0);
        layout = new GridLayout(pinsPerSide, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = -1;
        this.bottomSideCanvas.setLayout((Layout)layout);
        this.bottomSideCanvas.setVisible(this.numOfSides == 4);
        if (this.numOfSides == 4) {
            i2 = pinsPerSide;
            while (i2 < 2 * pinsPerSide) {
                pinData = chipData.getPinData()[i2];
                pin = new Pin((Composite)this.bottomSideCanvas, 256);
                pin.setPinData(pinData);
                this.pins.put(i2, pin);
                ++i2;
            }
        }
        this.bottomSideCanvas.setLayoutData((Object)layoutData);
        layoutData = new GridData(16384, 128, true, false);
        layoutData.horizontalSpan = 2;
        this.bottomLastPin = new Label((Composite)this.chipCanvas, 0);
        this.bottomLastPin.setForeground(ChipStyle.TEXT_COLOR);
        this.bottomLastPin.setLayoutData((Object)layoutData);
        this.bottomLastPin.setVisible(this.numOfSides == 4);
        this.bottomLastPin.setFont(markerFont);
        if (this.numOfSides == 4) {
            this.bottomLastPin.setText(Integer.toString(this.numOfPins * 2 / 4));
        }
        Label fsLogoLabel = new Label((Composite)this.innerChip, 64);
        Label pinOneMarkerLabel = new Label((Composite)this.innerChip, 64);
        pinOneMarkerLabel.setImage(ChipStyle.pinOneMarker);
        pinOneMarkerLabel.setLocation(0, 0);
        pinOneMarkerLabel.pack();
        fsLogoLabel.setSize(ChipStyle.fsLogo.getImageData().width, ChipStyle.fsLogo.getImageData().height);
        fsLogoLabel.setLocation(ChipStyle.centerX((Control)fsLogoLabel, (Control)this.innerChip), 0);
        this.info1Label = new Label((Composite)this.innerChip, 64);
        this.info1Label.setLocation(pinOneMarkerLabel.getSize().x, ChipStyle.getYOffset((Control)this.info1Label, (Control)fsLogoLabel, 5));
        this.info1Label.setFont(ChipStyle.CHIP_WINDOW_TEXT_FONT);
        this.info1Label.setForeground(ChipStyle.TEXT_COLOR);
        this.info1Label.setText(this.info1);
        this.info1Label.pack();
        this.info2Label = new Label((Composite)this.innerChip, 64);
        this.info2Label.setLocation(this.info1Label.getBounds().x, ChipStyle.getYOffset((Control)this.info2Label, (Control)this.info1Label, 0));
        this.info2Label.setFont(ChipStyle.CHIP_WINDOW_TEXT_FONT);
        this.info2Label.setForeground(ChipStyle.TEXT_COLOR);
        this.info2Label.setText(this.info2);
        this.info2Label.pack();
        this.info3Label = new Label((Composite)this.innerChip, 64);
        this.info3Label.setLocation(this.info1Label.getBounds().x, ChipStyle.getYOffset((Control)this.info3Label, (Control)this.info2Label, 0));
        this.info3Label.setFont(ChipStyle.CHIP_WINDOW_TEXT_FONT);
        this.info3Label.setText(this.info3);
        this.info3Label.setForeground(ChipStyle.TEXT_COLOR);
        this.info3Label.pack();
        if (fsLogoLabel.getSize().x + pinOneMarkerLabel.getSize().x > this.innerChip.getSize().x || fsLogoLabel.getSize().y > this.innerChip.getSize().y) {
            fsLogoLabel.setVisible(false);
        }
        fsLogoLabel.setImage(ChipStyle.fsLogo);
        this.chipCanvas.setBackground(ChipStyle.BACKGROUND_COLOR);
        this.chipCanvas.setBackgroundMode(1);
        this.chipCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                Chip.this.isOpened = false;
            }
        });
        this.chipCanvas.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                Chip.this.isOpened = false;
            }
        });
        this.chipCanvas.pack();
        this.chipCanvas.setVisible(true);
    }

    private void drawCore(int numOfSides, int pinsPerSide) {
        if (numOfSides == 4) {
            GridLayout coreLayout = new GridLayout(pinsPerSide + 2, false);
            coreLayout.horizontalSpacing = 0;
            coreLayout.verticalSpacing = 0;
            coreLayout.marginHeight = 0;
            coreLayout.marginWidth = 0;
            GridData data = new GridData(0x1000000, 0x1000000, false, false);
            data.horizontalSpan = 3;
            data.verticalSpan = 3;
            this.core = new Canvas((Composite)this.chipCanvas, 0);
            this.core.setLayout((Layout)coreLayout);
            this.core.setBackgroundMode(2);
            this.core.setLayoutData((Object)data);
            this.topLeftCorner = new Label((Composite)this.core, 0);
            this.topLeftCorner.setImage(ChipStyle.topLeftSection);
            this.leftSide = new Label[pinsPerSide];
            this.bottomSide = new Label[pinsPerSide];
            this.rightSide = new Label[pinsPerSide];
            this.topSide = new Label[pinsPerSide];
            int i = 0;
            while (i < pinsPerSide) {
                this.topSide[i] = new Label((Composite)this.core, 0);
                this.topSide[i].setImage(ChipStyle.topSection);
                ++i;
            }
            this.topRightCorner = new Label((Composite)this.core, 0);
            this.topRightCorner.setImage(ChipStyle.topRightSection);
            this.leftSide[0] = new Label((Composite)this.core, 0);
            this.leftSide[0].setImage(ChipStyle.leftSection);
            data = new GridData(4, 4, true, true);
            data.horizontalSpan = pinsPerSide;
            data.verticalSpan = pinsPerSide;
            this.innerChip = new Canvas((Composite)this.core, 0);
            this.innerChip.setLayoutData((Object)data);
            this.innerChip.setBackground(ChipStyle.CHIP_WINDOW_CHIP_COLOR);
            this.rightSide[0] = new Label((Composite)this.core, 0);
            this.rightSide[0].setImage(ChipStyle.rightSection);
            i = 1;
            while (i < pinsPerSide) {
                this.leftSide[i] = new Label((Composite)this.core, 0);
                this.leftSide[i].setImage(ChipStyle.leftSection);
                this.rightSide[i] = new Label((Composite)this.core, 0);
                this.rightSide[i].setImage(ChipStyle.rightSection);
                ++i;
            }
            this.bottomLeftCorner = new Label((Composite)this.core, 0);
            this.bottomLeftCorner.setImage(ChipStyle.bottomLeftSection);
            i = 0;
            while (i < pinsPerSide) {
                this.bottomSide[i] = new Label((Composite)this.core, 0);
                this.bottomSide[i].setImage(ChipStyle.bottomSection);
                ++i;
            }
            this.bottomRightCorner = new Label((Composite)this.core, 0);
            this.bottomRightCorner.setImage(ChipStyle.bottomRightSection);
        }
        if (numOfSides == 2) {
            int width = 3;
            GridLayout coreLayout = new GridLayout(width + 2, false);
            coreLayout.horizontalSpacing = 0;
            coreLayout.verticalSpacing = 0;
            coreLayout.marginHeight = 0;
            coreLayout.marginWidth = 0;
            GridData data = new GridData(0x1000000, 0x1000000, true, true);
            data.horizontalSpan = 3;
            data.verticalSpan = 3;
            this.core = new Canvas((Composite)this.chipCanvas, 0);
            this.core.setLayout((Layout)coreLayout);
            this.core.setBackgroundMode(2);
            this.core.setLayoutData((Object)data);
            this.topLeftCorner = new Label((Composite)this.core, 0);
            this.topLeftCorner.setImage(ChipStyle.topLeftSection);
            this.leftSide = new Label[pinsPerSide];
            this.bottomSide = new Label[width];
            this.rightSide = new Label[pinsPerSide];
            this.topSide = new Label[width];
            int i = 0;
            while (i < this.topSide.length) {
                this.topSide[i] = new Label((Composite)this.core, 0);
                this.topSide[i].setImage(ChipStyle.topSection);
                ++i;
            }
            this.topRightCorner = new Label((Composite)this.core, 0);
            this.topRightCorner.setImage(ChipStyle.topRightSection);
            this.leftSide[0] = new Label((Composite)this.core, 0);
            this.leftSide[0].setImage(ChipStyle.leftSection);
            data = new GridData(4, 4, true, true);
            data.horizontalSpan = width;
            data.widthHint = 36;
            data.verticalSpan = pinsPerSide;
            this.innerChip = new Canvas((Composite)this.core, 0);
            this.innerChip.setLayoutData((Object)data);
            this.innerChip.setBackground(ChipStyle.CHIP_WINDOW_CHIP_COLOR);
            this.rightSide[0] = new Label((Composite)this.core, 0);
            this.rightSide[0].setImage(ChipStyle.rightSection);
            i = 1;
            while (i < pinsPerSide) {
                this.leftSide[i] = new Label((Composite)this.core, 0);
                this.leftSide[i].setImage(ChipStyle.leftSection);
                this.rightSide[i] = new Label((Composite)this.core, 0);
                this.rightSide[i].setImage(ChipStyle.rightSection);
                ++i;
            }
            this.bottomLeftCorner = new Label((Composite)this.core, 0);
            this.bottomLeftCorner.setImage(ChipStyle.bottomLeftSection);
            i = 0;
            while (i < this.bottomSide.length) {
                this.bottomSide[i] = new Label((Composite)this.core, 0);
                this.bottomSide[i].setImage(ChipStyle.bottomSection);
                ++i;
            }
            this.bottomRightCorner = new Label((Composite)this.core, 0);
            this.bottomRightCorner.setImage(ChipStyle.bottomRightSection);
        }
    }

    public Point getLocation() {
        return new Point(this.chipCanvas.getLocation().x, this.chipCanvas.getLocation().y);
    }

    public ChipData getData() {
        return this.data;
    }

    public int getWidth() {
        return this.chipCanvas.getSize().x;
    }

    public int getHeight() {
        return this.chipCanvas.getSize().y;
    }

    public boolean isDisposed() {
        return this.innerChip.isDisposed();
    }

    public String getInfo1() {
        return this.info1Label.getText();
    }

    public String getInfo2() {
        return this.info2Label.getText();
    }

    public String getInfo3() {
        return this.info3Label.getText();
    }

    public Pin getPin(int num) {
        return this.pins.get(num);
    }

    public Canvas getCore() {
        return this.core;
    }

    public void addMouseListener(MouseListener listener) {
        this.innerChip.addMouseListener(listener);
    }

    public void setOpened(boolean opened) {
        this.isOpened = opened;
    }

    public Canvas getCanvas() {
        return this.chipCanvas;
    }

    public void dispose() {
        this.chipCanvas.dispose();
    }
}

