/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.gnu;

import com.freescale.s32ds.cross.core.ApplicabilityCalculator;
import com.freescale.s32ds.cross.gnu.Activator;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;

public class CrossCommandLineGenerator
extends ManagedCommandLineGenerator {
    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        IOption[] tcOptions;
        IBuildObject parent = tool.getParent();
        IToolChain toolchain = parent instanceof ResourceConfiguration ? ((ResourceConfiguration)parent).getBaseToolChain() : (IToolChain)parent;
        String newCommandName = commandName;
        ArrayList<String> allFlags = new ArrayList<String>();
        allFlags.addAll(Arrays.asList(flags));
        ArrayList<String> newFlags = new ArrayList<String>();
        IOption[] iOptionArray = tcOptions = toolchain.getOptions();
        int n = tcOptions.length;
        int n2 = 0;
        while (n2 < n) {
            IOption opt = iOptionArray[n2];
            IOptionApplicability applic = opt.getApplicabilityCalculator();
            if (!(applic instanceof ApplicabilityCalculator) || applic.isOptionUsedInCommandLine(null, (IHoldsOptions)tool, opt)) {
                String id = opt.getBaseId();
                if (id.contains("com.freescale.option.gnu.cross.prefix")) {
                    String prefix = (String)opt.getValue();
                    newCommandName = String.valueOf(prefix) + commandName;
                } else if (!(id.contains("com.freescale.option.gnu.cross.path") || tool.getBaseId().startsWith("com.freescale.s32ds.cross.gnu.archiver") || tool.getBaseId().startsWith("com.freescale.s32ds.cross.gnu.createflash") || tool.getBaseId().startsWith("com.freescale.s32ds.cross.gnu.disassembler"))) {
                    String command = "";
                    try {
                        int type = opt.getBasicValueType();
                        switch (type) {
                            case 0: {
                                boolean value = opt.getBooleanValue();
                                if (value) {
                                    command = opt.getCommand();
                                    break;
                                }
                                command = opt.getCommandFalse();
                                break;
                            }
                            case 2: {
                                command = opt.getStringValue();
                                break;
                            }
                            case 1: {
                                String value = opt.getStringValue();
                                command = opt.getEnumCommand(value);
                                break;
                            }
                            case 3: {
                                String[] values = opt.getBasicStringListValue();
                                String flag = opt.getCommand();
                                String[] stringArray = values;
                                int n3 = values.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String value = stringArray[n4];
                                    newFlags.add(String.valueOf(flag) + value);
                                    ++n4;
                                }
                                break;
                            }
                        }
                        if (command.length() > 0) {
                            newFlags.add(command);
                        }
                    }
                    catch (BuildException e) {
                        Activator.log((Exception)((Object)e));
                    }
                }
            }
            ++n2;
        }
        if (newFlags.size() > 0) {
            allFlags.addAll(newFlags);
        }
        return super.generateCommandLineInfo(tool, newCommandName, allFlags.toArray(new String[allFlags.size()]), outputFlag, outputPrefix, outputName, inputResources, commandLinePattern);
    }
}

