/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne;

import com.pemicro.debug.gdbjtag.pne.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;

class SemihostingProcess
extends Process
implements Runnable {
    boolean fRunning;
    Thread fThread = null;
    Socket socket;
    protected static final int BUFFER_SIZE = 2048;
    protected byte[] rawBytes = new byte[2048];
    protected InputStream fInputTCPStream;
    protected OutputStream fOutputStream;
    protected KeyboardInputStream fKeyboardInputStream;
    protected InputStream fErrorStream;
    protected PipedInputStream fPipeIn;
    protected PipedOutputStream fPipeOut;
    private String fHost;
    private int fPort;
    public int i;

    public SemihostingProcess(String host, int port) {
        Utils.debugPrint("SemihostingProcess(" + host + "," + port + ") " + this);
        this.fHost = host;
        this.fPort = port;
        this.fRunning = false;
        this.fInputTCPStream = new NullInputStream();
        this.fErrorStream = new NullInputStream();
        this.fKeyboardInputStream = new KeyboardInputStream();
        this.fPipeOut = new PipedOutputStream();
        try {
            this.fPipeIn = new PipedInputStream(this.fPipeOut);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void destroy() {
        Utils.debugPrint("SemihostingProcess.destroy() " + Thread.currentThread() + " " + this.fThread);
        if (this.fRunning) {
            if (this.fThread != null && this.fThread != Thread.currentThread()) {
                this.fThread.interrupt();
                Utils.debugPrint("SemihostingProcess.destroy() after interrupt");
            }
            try {
                if (this.socket != null && !this.socket.isClosed()) {
                    Utils.debugPrint("SemihostingProcess.destroy() before shutdownInput");
                    this.socket.shutdownInput();
                    Utils.debugPrint("SemihostingProcess.destroy() before shutdownOutput");
                    this.socket.shutdownOutput();
                }
            }
            catch (IOException iOException) {
                Utils.debugPrint("SemihostingProcess.destroy() exception");
            }
        }
        Utils.debugPrint("SemihostingProcess.destroy() return");
    }

    @Override
    public int exitValue() {
        if (this.fRunning) {
            throw new IllegalThreadStateException();
        }
        return 0;
    }

    @Override
    public InputStream getErrorStream() {
        return this.fErrorStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.fPipeIn;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.fKeyboardInputStream;
    }

    @Override
    public int waitFor() throws InterruptedException {
        Utils.debugPrint("SemihostingProcess.waitFor() " + Thread.currentThread() + " " + this.fThread);
        this.fThread.join();
        Utils.debugPrint("SemihostingProcess.waitFor() return " + Thread.currentThread());
        return 0;
    }

    @Override
    public void run() {
        block43: {
            Utils.debugPrint("SemihostingProcess.run() " + Thread.currentThread());
            this.fRunning = true;
            int nTimeout = 10000;
            this.i = 50;
            while (this.i > 0) {
                InetSocketAddress address = new InetSocketAddress(this.fHost, this.fPort);
                this.socket = new Socket();
                try {
                    this.socket.connect(address, nTimeout);
                    break;
                }
                catch (IOException iOException) {
                    --this.i;
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                    if (this.i != 0) continue;
                    Utils.debugPrint("cannot connect, no way to go further.");
                    return;
                }
            }
            this.fRunning = true;
            try {
                try {
                    this.fInputTCPStream = this.socket.getInputStream();
                    this.fOutputStream = this.socket.getOutputStream();
                    this.socket.setKeepAlive(true);
                    this.socket.setSoTimeout(200);
                    while (this.socket.isConnected() && this.fRunning) {
                        int nRawInputBytes;
                        if (this.fKeyboardInputStream.dataAvailable()) {
                            String keyboardInput = this.fKeyboardInputStream.getNewData();
                            this.fOutputStream.write(keyboardInput.getBytes());
                        }
                        try {
                            nRawInputBytes = this.fInputTCPStream.read(this.rawBytes);
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            continue;
                        }
                        if (nRawInputBytes > 0) {
                            this.fPipeOut.write(this.rawBytes, 0, nRawInputBytes);
                            this.fPipeOut.flush();
                            continue;
                        }
                        if (nRawInputBytes != -1) continue;
                        Utils.debugPrint("Connection closed by the GDB server.");
                        this.fPipeOut.write("Connection closed by the GDB server.".getBytes());
                        this.fPipeOut.flush();
                        break;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        this.fPipeOut.close();
                    }
                    catch (Exception e1) {
                        Utils.debugPrint(e1.toString());
                    }
                    try {
                        this.fErrorStream.close();
                    }
                    catch (IOException e1) {
                        Utils.debugPrint(e1.toString());
                    }
                    try {
                        this.socket.close();
                        this.socket = null;
                    }
                    catch (IOException e2) {
                        Utils.debugPrint(e2.toString());
                    }
                    try {
                        this.fInputTCPStream.close();
                        this.fKeyboardInputStream.close();
                    }
                    catch (NullPointerException e3) {
                        Utils.debugPrint(e3.toString());
                    }
                    catch (IOException e4) {
                        Utils.debugPrint(e4.toString());
                    }
                    this.fRunning = false;
                    break block43;
                }
            }
            catch (Throwable throwable) {
                try {
                    this.fPipeOut.close();
                }
                catch (Exception e1) {
                    Utils.debugPrint(e1.toString());
                }
                try {
                    this.fErrorStream.close();
                }
                catch (IOException e1) {
                    Utils.debugPrint(e1.toString());
                }
                try {
                    this.socket.close();
                    this.socket = null;
                }
                catch (IOException e) {
                    Utils.debugPrint(e.toString());
                }
                try {
                    this.fInputTCPStream.close();
                    this.fKeyboardInputStream.close();
                }
                catch (NullPointerException e) {
                    Utils.debugPrint(e.toString());
                }
                catch (IOException e) {
                    Utils.debugPrint(e.toString());
                }
                this.fRunning = false;
                throw throwable;
            }
            try {
                this.fPipeOut.close();
            }
            catch (Exception e1) {
                Utils.debugPrint(e1.toString());
            }
            try {
                this.fErrorStream.close();
            }
            catch (IOException e1) {
                Utils.debugPrint(e1.toString());
            }
            try {
                this.socket.close();
                this.socket = null;
            }
            catch (IOException e) {
                Utils.debugPrint(e.toString());
            }
            try {
                this.fInputTCPStream.close();
                this.fKeyboardInputStream.close();
            }
            catch (NullPointerException e) {
                Utils.debugPrint(e.toString());
            }
            catch (IOException e) {
                Utils.debugPrint(e.toString());
            }
            this.fRunning = false;
        }
        Utils.debugPrint("SemihostingProcess.run() completed ");
    }

    public void submit() {
        Utils.debugPrint("SemihostingProcess.submit() " + Thread.currentThread());
        this.fThread = new Thread(this);
        this.fThread.setName("Semihosting and SWV fake process");
        this.fThread.setDaemon(true);
        this.fThread.setPriority(1);
        this.fThread.start();
    }

    protected class KeyboardInputStream
    extends OutputStream {
        private String userinput = "";
        private boolean newInput = false;

        @Override
        public void write(int arg0) throws IOException {
            if (arg0 == 13) {
                return;
            }
            if (arg0 == 10) {
                this.newInput = true;
            }
            this.userinput = String.valueOf(this.userinput) + Character.toString((char)arg0);
        }

        public boolean dataAvailable() {
            return this.newInput;
        }

        public String getNewData() {
            this.newInput = false;
            String returnInput = this.userinput;
            this.userinput = "";
            return returnInput;
        }
    }

    protected class NullInputStream
    extends InputStream {
        private boolean fIsOpened = true;
        private Thread fThread = null;

        protected NullInputStream() {
        }

        @Override
        public int read() throws IOException {
            if (!this.fIsOpened) {
                return -1;
            }
            try {
                this.fThread = Thread.currentThread();
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                Utils.debugPrint("NullInputStream read interrupted");
            }
            return 0;
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public void close() throws IOException {
            Utils.debugPrint("NullInputStream.close() " + Thread.currentThread());
            if (this.fIsOpened) {
                super.close();
                this.fIsOpened = false;
                if (this.fThread != null) {
                    Utils.debugPrint("NullInputStream.close() interrupt " + Thread.currentThread() + " " + this.fThread);
                    this.fThread.interrupt();
                }
            }
        }
    }
}

