/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core.actions;

import com.nxp.s32ds.ext.rcp.p2.core.LockedFilesTracker;
import com.nxp.s32ds.ext.rcp.p2.core.Messages;
import com.nxp.s32ds.ext.rcp.p2.core.UnnativeTouchpoint;
import com.nxp.s32ds.ext.rcp.p2.core.utils.Unzip;
import com.nxp.s32ds.ext.rcp.p2.core.utils.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.spi.ProvisioningAction;
import org.eclipse.osgi.util.NLS;

public class InstallAction
extends ProvisioningAction {
    public IStatus execute(Map<String, Object> parameters) {
        LockedFilesTracker lft = new LockedFilesTracker();
        IStatus retCode = Status.CANCEL_STATUS;
        WeakHashMap<String, Object> localParameters = new WeakHashMap<String, Object>();
        localParameters.putAll(parameters);
        IBackupStore store = UnnativeTouchpoint.getBackupStore((IProfile)parameters.get("profile"));
        if (store != null) {
            localParameters.put("backup", store);
        }
        String downloadFolder = String.valueOf(Util.getTempFolder()) + "s32ds_" + System.currentTimeMillis();
        lft.setUnzipFolder(downloadFolder);
        retCode = Unzip.unzip(localParameters, false, downloadFolder);
        if (retCode != Status.OK_STATUS) {
            return retCode;
        }
        retCode = Util.copy(localParameters, downloadFolder, lft, true);
        if (localParameters.get("mergeBase") != null && localParameters.get("mergeExtra") != null) {
            retCode = InstallAction.mergeFiles(parameters);
        }
        try {
            Util.delete(new File(downloadFolder));
        }
        catch (IOException e) {
            Util.logError(e.getMessage(), e);
        }
        return retCode;
    }

    public IStatus undo(Map<String, Object> parameters) {
        return Util.cleanupcopy(parameters, true, null);
    }

    public static IStatus mergeFiles(Map<String, Object> parameters) {
        File baseMerge = new File((String)parameters.get("mergeBase"));
        File extraMerge = new File((String)parameters.get("mergeExtra"));
        IBackupStore store = (IBackupStore)parameters.get("backup");
        if (store != null) {
            try {
                store.backupCopy(baseMerge);
            }
            catch (IOException e) {
                Util.logError(e.getMessage());
            }
        }
        if (baseMerge.exists() && extraMerge.exists()) {
            if (Util.getExtension(baseMerge).equals("xml") && Util.getExtension(extraMerge).equals("xml")) {
                Util.mergeXMLFiles(baseMerge, extraMerge);
            } else {
                try {
                    Util.appendStream(new FileInputStream(extraMerge), true, new FileOutputStream(baseMerge, true), true);
                }
                catch (Exception e) {
                    return new Status(4, "com.nxp.s32ds.ext.rcp.p2.core", 0, NLS.bind((String)Messages.merge_failed, (Object)baseMerge.getPath()), (Throwable)e);
                }
            }
        }
        return Status.OK_STATUS;
    }
}

