/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.collateral.core.internal;

import com.nxp.s32ds.ext.rcp.collateral.CollateralFactory;
import com.nxp.s32ds.ext.rcp.collateral.CollateralFeature;
import com.nxp.s32ds.ext.rcp.collateral.CollateralPack;
import com.nxp.s32ds.ext.rcp.collateral.CollateralResource;
import com.nxp.s32ds.ext.rcp.collateral.CollateralResourceType;
import com.nxp.s32ds.ext.rcp.collateral.CollateralTag;
import com.nxp.s32ds.ext.rcp.collateral.core.internal.CollatorRegistryCompiler;
import com.nxp.s32ds.ext.rcp.collateral.core.internal.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class CollateralRegistryLoader {
    private CollateralFactory collateralFactory = CollateralFactory.INSTANCE;

    public void loadTags(IExtension[] tagExtensions, CollatorRegistryCompiler collatorModelCompiler) {
        if (collatorModelCompiler == null) {
            return;
        }
        this.loadTagExtensions(tagExtensions, collatorModelCompiler.getTags());
    }

    public void loadPacks(IExtension[] pakExtensions, CollatorRegistryCompiler collatorModelCompiler) {
        if (collatorModelCompiler == null) {
            return;
        }
        this.loadPaksExtensions(pakExtensions, collatorModelCompiler.getPacks(), collatorModelCompiler.getPackIdToFeatureIds());
    }

    public void loadFeatures(IExtension[] featureExtensions, CollatorRegistryCompiler collatorModelCompiler) {
        if (collatorModelCompiler == null) {
            return;
        }
        this.loadFeatureExtensions(featureExtensions, collatorModelCompiler.getFeatures(), collatorModelCompiler.getFeatureIdToResoursesId());
    }

    public void loadResources(IExtension[] resourcesExtensions, CollatorRegistryCompiler collatorModelCompiler) {
        if (collatorModelCompiler == null) {
            return;
        }
        this.loadResourceExtensions(resourcesExtensions, collatorModelCompiler.getResources(), collatorModelCompiler.getResourceTypesIdToResourceTypes(), collatorModelCompiler.getResourceToResourseTypeId(), collatorModelCompiler.getResourceIdToTagId());
    }

    private void loadPaksExtensions(IExtension[] pakExtensions, Collection<CollateralPack> collateralPacks, Map<String, Collection<String>> packIdToFeatureIds) {
        if (pakExtensions == null || pakExtensions.length == 0) {
            return;
        }
        IExtension[] iExtensionArray = pakExtensions;
        int n = pakExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if (Messages.CollateralModelLoader_Pack.equals(el.getName())) {
                    this.createPack(collateralPacks, el);
                } else if (Messages.CollateralModelLoader_PackFeature.equals(el.getName())) {
                    this.createPackReferenceToFeature(packIdToFeatureIds, el);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void createPackReferenceToFeature(Map<String, Collection<String>> packIdToFeatureIds, IConfigurationElement el) {
        ArrayList<String> referenceResourceIds = new ArrayList<String>();
        String faetureId = el.getAttribute(Messages.CollateralModelLoader_PackId);
        IConfigurationElement[] iConfigurationElementArray = el.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (Messages.CollateralModelLoader_FeatureReference.equals(element.getName())) {
                referenceResourceIds.add(element.getAttribute(Messages.CollateralModelLoader_FeatureId));
            }
            ++n2;
        }
        packIdToFeatureIds.put(faetureId, referenceResourceIds);
    }

    private void createPack(Collection<CollateralPack> collateralPacks, IConfigurationElement el) {
        CollateralPack collateralPackImplementation = this.collateralFactory.createPack(el.getAttribute(Messages.CollateralModelLoader_Id), el.getAttribute(Messages.CollateralModelLoader_Name), el.getAttribute(Messages.CollateralModelLoader_Description), el.getAttribute(Messages.CollateralRegistryLoader_Image));
        collateralPacks.add(collateralPackImplementation);
    }

    private void loadResourceExtensions(IExtension[] resourcesExtensions, Map<String, CollateralResource> resourcesIdToResource, Map<String, CollateralResourceType> resourceTypesIdToResourceTypes, Map<String, String> ResourseIdToResourceTypeId, Map<String, Collection<String>> resourceIdToTagId) {
        if (resourcesExtensions == null || resourcesExtensions.length == 0) {
            return;
        }
        IExtension[] iExtensionArray = resourcesExtensions;
        int n = resourcesExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if (Messages.CollateralModelLoader_Resource.equals(el.getName())) {
                    this.createResource(resourcesIdToResource, el, ResourseIdToResourceTypeId);
                } else if (Messages.CollateralModelLoader_ResourceType.equals(el.getName())) {
                    this.createResourceType(resourceTypesIdToResourceTypes, el);
                } else if (Messages.CollateralModelLoader_ResourceTag.equals(el.getName())) {
                    this.loadTagsLinkToResource(resourceIdToTagId, el);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void loadTagsLinkToResource(Map<String, Collection<String>> resourceIdToTagId, IConfigurationElement el) {
        String resourseId = el.getAttribute(Messages.CollateralModelLoader_ResourceId);
        ArrayList<String> tagsId = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = el.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (Messages.CollateralModelLoader_TagReference.equals(element.getName())) {
                tagsId.add(element.getAttribute(Messages.CollateralModelLoader_TagId));
            }
            ++n2;
        }
        resourceIdToTagId.put(resourseId, tagsId);
    }

    private void createResourceType(Map<String, CollateralResourceType> resourceTypesIdToResourceTypes, IConfigurationElement el) {
        CollateralResourceType collateralResourceImplementation = this.collateralFactory.createResourceType(el.getAttribute(Messages.CollateralModelLoader_Id), el.getAttribute(Messages.CollateralModelLoader_Name), el.getAttribute(Messages.CollateralModelLoader_Description), el.getAttribute(Messages.CollateralRegistryLoader_Image));
        resourceTypesIdToResourceTypes.put(collateralResourceImplementation.getId(), collateralResourceImplementation);
    }

    private void createResource(Map<String, CollateralResource> resourcesIdToResource, IConfigurationElement el, Map<String, String> resourseIdToResourceTypeId) {
        CollateralResource collateralResourceImplementation = this.collateralFactory.createResource(el.getAttribute(Messages.CollateralModelLoader_Id), el.getAttribute(Messages.CollateralModelLoader_Name), el.getAttribute(Messages.CollateralModelLoader_Description), el.getAttribute(Messages.CollateralModelLoader_UrlLink), el.getAttribute(Messages.CollateralRegistryLoader_Image));
        resourcesIdToResource.put(collateralResourceImplementation.getId(), collateralResourceImplementation);
        resourseIdToResourceTypeId.put(collateralResourceImplementation.getId(), el.getAttribute(Messages.CollateralModelLoader_ReferenceResourceType));
    }

    private void loadTagExtensions(IExtension[] tagExtensions, Map<String, CollateralTag> tagIdToTags) {
        if (tagExtensions == null || tagExtensions.length == 0) {
            return;
        }
        IExtension[] iExtensionArray = tagExtensions;
        int n = tagExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if (Messages.CollateralModelLoader_Tag.equals(el.getName())) {
                    this.createTag(tagIdToTags, el);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void createTag(Map<String, CollateralTag> tagIdToTags, IConfigurationElement el) {
        CollateralTag collateralTagImplementation = this.collateralFactory.createTag(el.getAttribute(Messages.CollateralModelLoader_Id), el.getAttribute(Messages.CollateralModelLoader_Name), el.getAttribute(Messages.CollateralModelLoader_Description), el.getAttribute(Messages.CollateralRegistryLoader_Image));
        tagIdToTags.put(collateralTagImplementation.getId(), collateralTagImplementation);
    }

    private void loadFeatureExtensions(IExtension[] featureExtensions, Map<String, CollateralFeature> featureIdTofeature, Map<String, Collection<String>> fFeatureIdToResoursesId) {
        if (featureExtensions == null || featureExtensions.length == 0) {
            return;
        }
        IExtension[] iExtensionArray = featureExtensions;
        int n = featureExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if (Messages.CollateralModelLoader_Feature.equals(el.getName())) {
                    this.createCollateralFeature(featureIdTofeature, el);
                } else if (Messages.CollateralModelLoader_FeatureResource.equals(el.getName())) {
                    this.createCollateralFeatureLinkToCollateralResource(el, fFeatureIdToResoursesId);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void createCollateralFeatureLinkToCollateralResource(IConfigurationElement el, Map<String, Collection<String>> fFeatureIdToResoursesId) {
        ArrayList<String> referenceResourceIds = new ArrayList<String>();
        String faetureId = el.getAttribute(Messages.CollateralModelLoader_FeatureId);
        IConfigurationElement[] iConfigurationElementArray = el.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (Messages.CollateralModelLoader_ResourceReference.equals(element.getName())) {
                referenceResourceIds.add(element.getAttribute(Messages.CollateralModelLoader_ResourceId));
            }
            ++n2;
        }
        fFeatureIdToResoursesId.put(faetureId, referenceResourceIds);
    }

    private void createCollateralFeature(Map<String, CollateralFeature> featureIdTofeature, IConfigurationElement el) {
        CollateralFeature collateralFeatureImplementation = this.collateralFactory.createFeature(el.getAttribute(Messages.CollateralModelLoader_Id), el.getAttribute(Messages.CollateralModelLoader_Name), el.getAttribute(Messages.CollateralModelLoader_Description), el.getAttribute(Messages.CollateralRegistryLoader_Image));
        featureIdTofeature.put(collateralFeatureImplementation.getId(), collateralFeatureImplementation);
    }
}

