/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core;

import com.freescale.s32ds.cdt.core.FSLErrorParserExtensionManager;
import com.freescale.s32ds.cdt.core.ICompilationPathResolver;
import com.freescale.s32ds.cdt.core.IErrorParserManagerDelegate;
import com.freescale.s32ds.cdt.core.IErrorParserProcessor;
import com.freescale.s32ds.cdt.core.IFSLErrorParser3;
import com.freescale.s32ds.cdt.core.OutputLine;
import com.freescale.s32ds.cdt.core.OutputLineQueue;
import com.freescale.s32ds.cdt.core.internal.errorparsers.CompilationPathResolverManager;
import com.freescale.s32ds.cdt.core.internal.errorparsers.ErrorParserDelegateManager;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IErrorParser;
import org.eclipse.cdt.core.IErrorParser2;
import org.eclipse.cdt.core.IErrorParser3;
import org.eclipse.cdt.core.IErrorParserNamed;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.core.errorparsers.ErrorParserNamedWrapper;
import org.eclipse.cdt.core.language.settings.providers.IWorkingDirectoryTracker;
import org.eclipse.cdt.core.resources.ACBuilder;
import org.eclipse.cdt.internal.core.Cygwin;
import org.eclipse.cdt.internal.core.IErrorMarkeredOutputStream;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.osgi.service.prefs.BackingStoreException;

public class FSLErrorParserManager
extends ErrorParserManager
implements IConsoleParser,
IWorkingDirectoryTracker,
IErrorParserProcessor {
    @Deprecated
    public static final String PREF_ERROR_PARSER = "org.eclipse.cdt.core.errorOutputParser";
    public static final char ERROR_PARSER_DELIMITER = ';';
    public static final String BUILD_CONTEXT = "build";
    private int nOpens;
    private int lineCounter = 0;
    private final IProject fProject;
    private final IMarkerGenerator fMarkerGenerator;
    private List<IErrorParser> fErrorParsers;
    private ArrayList<ProblemMarkerInfo> fErrors;
    private ArrayList<ProblemMarkerInfo> fPendingErrors;
    private final Vector<URI> fDirectoryStack;
    private IErrorParserManagerDelegate[] fDelegates;
    private ICompilationPathResolver[] fResolvers;
    private final URI fBaseDirectoryURI;
    private IErrorParser3 previousErrorParser = null;
    private String previousLine;
    private OutputStream outputStream;
    private final StringBuilder currentLine = new StringBuilder();
    private final StringBuilder scratchBuffer = new StringBuilder();
    private boolean hasErrors = false;
    private String cachedFileName = null;
    private URI cachedWorkingDirectory = null;
    private IFile cachedFile = null;
    private static boolean isCygwin = true;
    private ArrayList<String> fErrorMsgLines = new ArrayList();
    private boolean fIsErrorMsgComplete = false;
    private final OutputLineQueue outputLineQueue = new OutputLineQueue();

    public FSLErrorParserManager(ACBuilder builder) {
        this(builder.getProject(), (IMarkerGenerator)builder);
    }

    public FSLErrorParserManager(IProject project, IMarkerGenerator markerGenerator) {
        this(project, markerGenerator, null);
    }

    public FSLErrorParserManager(IProject project, IMarkerGenerator markerGenerator, String[] parsersIDs) {
        this(project, (URI)null, markerGenerator, parsersIDs);
    }

    @Deprecated
    public FSLErrorParserManager(IProject project, IPath workingDirectory, IMarkerGenerator markerGenerator, String[] parsersIDs) {
        this(project, workingDirectory == null || workingDirectory.isEmpty() ? null : URIUtil.toURI((IPath)workingDirectory), markerGenerator, parsersIDs);
    }

    public FSLErrorParserManager(IProject project, URI baseDirectoryURI, IMarkerGenerator markerGenerator, String[] parsersIDs) {
        super(project, baseDirectoryURI, markerGenerator, parsersIDs);
        this.fProject = project;
        this.fMarkerGenerator = markerGenerator;
        this.fDirectoryStack = new Vector();
        this.fErrors = new ArrayList();
        this.fPendingErrors = new ArrayList();
        this.enableErrorParsers(parsersIDs);
        this.fBaseDirectoryURI = baseDirectoryURI != null ? baseDirectoryURI : (project != null ? project.getLocationURI() : URIUtil.toURI((String)System.getProperty("user.dir")));
        this.fResolvers = CompilationPathResolverManager.getResolvers();
        IErrorParserManagerDelegate[] iErrorParserManagerDelegateArray = this.fDelegates = ErrorParserDelegateManager.getDelegates();
        int n = this.fDelegates.length;
        int n2 = 0;
        while (n2 < n) {
            IErrorParserManagerDelegate delegate = iErrorParserManagerDelegateArray[n2];
            delegate.initialize(this);
            ++n2;
        }
    }

    private void enableErrorParsers(String[] parsersIDs) {
        if (parsersIDs == null) {
            parsersIDs = FSLErrorParserExtensionManager.getDefaultErrorParserIds();
        }
        this.fErrorParsers = Stream.of(parsersIDs).map(FSLErrorParserManager::getErrorParserCopy).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<IErrorParser> getErrorParsers() {
        return this.fErrorParsers;
    }

    public IProject getProject() {
        return this.fProject;
    }

    @Deprecated
    public IPath getWorkingDirectory() {
        return URIUtil.toPath((URI)this.getWorkingDirectoryURI());
    }

    public URI getWorkingDirectoryURI() {
        if (!this.fDirectoryStack.isEmpty()) {
            return this.fDirectoryStack.lastElement();
        }
        return this.fBaseDirectoryURI;
    }

    public void pushDirectory(IPath dir) {
        if (dir != null) {
            URI uri;
            URI workingDirectoryURI = this.getWorkingDirectoryURI();
            if (!dir.isAbsolute()) {
                uri = org.eclipse.core.runtime.URIUtil.append((URI)workingDirectoryURI, (String)dir.toString());
            } else {
                uri = this.toURI(dir);
                if (uri == null) {
                    return;
                }
            }
            this.pushDirectoryURI(uri);
        }
    }

    public void pushDirectoryURI(URI dir) {
        if (dir != null) {
            if (dir.isAbsolute()) {
                this.fDirectoryStack.addElement(dir);
            } else {
                this.fDirectoryStack.addElement(org.eclipse.core.runtime.URIUtil.makeAbsolute((URI)dir, (URI)this.getWorkingDirectoryURI()));
            }
        }
    }

    @Deprecated
    public IPath popDirectory() {
        return URIUtil.toPath((URI)this.popDirectoryURI());
    }

    public URI popDirectoryURI() {
        int i = this.fDirectoryStack.size();
        if (i != 0) {
            URI dir = this.fDirectoryStack.lastElement();
            this.fDirectoryStack.removeElementAt(i - 1);
            return dir;
        }
        return this.fBaseDirectoryURI;
    }

    public int getDirectoryLevel() {
        return this.fDirectoryStack.size();
    }

    @Deprecated
    protected void collectFiles(IProject parent, List<IResource> result) {
        try {
            parent.accept(proxy -> {
                if (proxy.getType() == 1) {
                    result.add(proxy.requestResource());
                    return false;
                }
                return true;
            }, 0);
        }
        catch (CoreException e) {
            CCorePlugin.log((IStatus)e.getStatus());
        }
    }

    public boolean processLine(String line) {
        this.registerOutputLine(line);
        IErrorParserManagerDelegate[] iErrorParserManagerDelegateArray = this.fDelegates;
        int n = this.fDelegates.length;
        int n2 = 0;
        while (n2 < n) {
            IErrorParserManagerDelegate delegate = iErrorParserManagerDelegateArray[n2];
            if (delegate.processLine(line, this)) {
                return true;
            }
            ++n2;
        }
        return this.processErrorParsers(line, this.fErrorParsers);
    }

    public void registerOutputLine(String line) {
        this.registerOutputLine(line, false);
    }

    public void registerOutputLine(String line, boolean duplicated) {
        this.outputLineQueue.add(new OutputLine(line, duplicated));
    }

    @Override
    public boolean processErrorParsers(String line, Collection<IErrorParser> parsers) {
        int sizeBeforeCycle = this.fErrorMsgLines.size();
        String lineTrimmed = line.trim();
        ++this.lineCounter;
        ProblemMarkerInfo marker = null;
        Iterator<IErrorParser> iterator = parsers.iterator();
        while (iterator.hasNext()) {
            IErrorParser parser;
            IErrorParser curr = parser = iterator.next();
            if (parser instanceof ErrorParserNamedWrapper) {
                curr = ((ErrorParserNamedWrapper)parser).getErrorParser();
            }
            int types = 0;
            if (curr instanceof IErrorParser2) {
                types = ((IErrorParser2)curr).getProcessLineBehaviour();
            }
            if ((types & 4) == 0 && lineTrimmed.length() > 1000) continue;
            String lineToParse = lineTrimmed;
            if ((types & 1) != 0) {
                lineToParse = line;
            } else {
                this.outputLineQueue.registerAlias(line, lineTrimmed);
            }
            boolean consume = false;
            try {
                try {
                    consume = curr.processLine(lineToParse, (ErrorParserManager)this);
                }
                catch (Exception e) {
                    String id = "";
                    if (parser instanceof IErrorParserNamed) {
                        id = ((IErrorParserNamed)parser).getId();
                    }
                    String message = "Errorparser " + id + " failed parsing line [" + lineToParse + "]";
                    CCorePlugin.log((String)message, (Throwable)e);
                }
                if (consume) {
                    if (this.previousErrorParser instanceof IFSLErrorParser3 && this.previousErrorParser != curr) {
                        ArrayList<ProblemMarkerInfo> temporaryErrors = this.fPendingErrors;
                        this.fPendingErrors = new ArrayList();
                        ((IFSLErrorParser3)this.previousErrorParser).flush(this);
                        this.fPendingErrors.addAll(temporaryErrors);
                    }
                    this.previousErrorParser = curr instanceof IErrorParser3 ? (IErrorParser3)curr : null;
                    this.flushPendingErrors();
                    break;
                }
                this.flushPendingErrors();
            }
            finally {
                if (this.fErrors.size() > 0) {
                    if (marker == null) {
                        marker = this.fErrors.get(this.fErrors.size() - 1);
                    }
                    this.fErrors.clear();
                }
            }
        }
        if (parsers.isEmpty()) {
            this.flushPendingErrors();
        } else if (sizeBeforeCycle == 1 && this.fErrorMsgLines.size() == sizeBeforeCycle) {
            this.flushPendingErrorParserErrors();
        }
        if (this.fErrorMsgLines.isEmpty()) {
            this.outputLine(line, marker);
        } else {
            this.outputPendingErrorMessages(marker);
        }
        return false;
    }

    private void outputLine(String line, ProblemMarkerInfo marker) {
        this.outputLineQueue.setDone(line, marker);
        this.outputDoneLines();
    }

    private void outputDoneLines() {
        OutputLine line;
        while ((line = this.outputLineQueue.pollDone()) != null) {
            this.outputToConsole(line.getLine(), line.getInfo());
        }
    }

    private void outputToConsole(String line, ProblemMarkerInfo marker) {
        String l = String.valueOf(line) + "\n";
        if (this.outputStream == null) {
            return;
        }
        try {
            if (marker != null && this.outputStream instanceof IErrorMarkeredOutputStream) {
                IErrorMarkeredOutputStream s = (IErrorMarkeredOutputStream)this.outputStream;
                s.write(l, marker);
            } else {
                byte[] b = l.getBytes();
                this.outputStream.write(b, 0, b.length);
            }
        }
        catch (IOException e) {
            CCorePlugin.log((Throwable)e);
        }
    }

    public void addErrorMsgLine(String line) {
        this.fErrorMsgLines.add(line);
    }

    public void setErrorMsgComplete(boolean isComplete) {
        this.fIsErrorMsgComplete = isComplete;
    }

    public int getLineCounter() {
        return this.lineCounter;
    }

    public IFile findFileName(String partialLoc) {
        if (partialLoc.equals(this.cachedFileName) && this.cachedWorkingDirectory != null && URIUtil.equals((URI)this.getWorkingDirectoryURI(), (URI)this.cachedWorkingDirectory)) {
            return this.cachedFile;
        }
        Path path = new Path(partialLoc.replace('\\', '/'));
        IFile file = this.findFileInWorkspace((IPath)path);
        if (file == null) {
            IProject[] prjs;
            path = path.setDevice(null);
            IFile[] files = null;
            if (this.fProject != null && (files = ResourceLookup.findFilesByName((IPath)path, (IProject[])(prjs = new IProject[]{this.fProject}), (boolean)false)).length == 0) {
                files = ResourceLookup.findFilesByName((IPath)path, (IProject[])prjs, (boolean)true);
            }
            if ((files == null || files.length == 0) && (files = ResourceLookup.findFilesByName((IPath)path, (IProject[])(prjs = ResourcesPlugin.getWorkspace().getRoot().getProjects()), (boolean)false)).length == 0) {
                files = ResourceLookup.findFilesByName((IPath)path, (IProject[])prjs, (boolean)true);
            }
            if (files.length == 1) {
                file = files[0];
            }
        }
        if (file == null && isCygwin && path.isAbsolute()) {
            file = this.findCygwinFile(partialLoc);
        }
        this.cachedFileName = partialLoc;
        this.cachedWorkingDirectory = this.getWorkingDirectoryURI();
        this.cachedFile = file;
        return file;
    }

    protected IFile findFileInWorkspace(IPath path) {
        URI uri;
        if (!path.isAbsolute()) {
            URI workingDirectoryURI = this.getWorkingDirectoryURI();
            uri = EFSExtensionManager.getDefault().append(workingDirectoryURI, path.toString());
        } else {
            uri = this.toURI(path);
            if (uri == null) {
                return null;
            }
        }
        return this.findFileInWorkspace(uri);
    }

    protected IFile findFileInWorkspace(URI uri) {
        IFile f;
        if (!uri.isAbsolute()) {
            uri = org.eclipse.core.runtime.URIUtil.makeAbsolute((URI)uri, (URI)this.getWorkingDirectoryURI());
        }
        if ((f = ResourceLookup.selectFileForLocationURI((URI)uri, (IProject)this.fProject)) != null && f.isAccessible()) {
            return f;
        }
        return null;
    }

    @Deprecated
    public boolean isConflictingName(String fileName) {
        return ResourceLookup.findFilesByName((IPath)new Path(fileName), (IProject[])new IProject[]{this.fProject}, (boolean)false).length > 1;
    }

    @Deprecated
    public IFile findFilePath(String filePath) {
        Path path = new Path(filePath);
        IFile file = this.findFileInWorkspace((IPath)path);
        if (file == null && isCygwin) {
            file = this.findCygwinFile(filePath);
        }
        return file != null && file.exists() ? file : null;
    }

    private IFile findCygwinFile(String filePath) {
        try {
            return this.findFileInWorkspace((IPath)new Path(Cygwin.cygwinToWindowsPath((String)filePath)));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            isCygwin = false;
        }
        catch (Exception exception) {}
        return null;
    }

    public void generateMarker(IResource file, int lineNumber, String desc, int severity, String varName) {
        this.generateExternalMarker(file, lineNumber, desc, severity, varName, null);
    }

    private void outputPendingErrorMessages(ProblemMarkerInfo marker) {
        if (this.fIsErrorMsgComplete) {
            Iterator<String> iter = this.fErrorMsgLines.iterator();
            while (iter.hasNext()) {
                this.outputLine(iter.next(), marker);
            }
            this.fErrorMsgLines.clear();
            this.fIsErrorMsgComplete = false;
        }
    }

    public void generateExternalMarker(IResource file, int lineNumber, String desc, int severity, String varName, IPath externalPath) {
        if (file == null) {
            file = this.fProject;
        }
        if (externalPath != null && !externalPath.toFile().exists()) {
            ICompilationPathResolver[] iCompilationPathResolverArray = this.fResolvers;
            int n = this.fResolvers.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationPathResolver resolver = iCompilationPathResolverArray[n2];
                IPath path = resolver.resolve(externalPath, this.fProject);
                if (path != null && path.toFile().exists()) {
                    externalPath = path;
                    break;
                }
                ++n2;
            }
        }
        ProblemMarkerInfo problemMarkerInfo = new ProblemMarkerInfo(file, lineNumber, desc, severity, varName, externalPath);
        this.outputPendingErrorMessages(problemMarkerInfo);
        this.fPendingErrors.add(problemMarkerInfo);
    }

    public void addProblemMarker(ProblemMarkerInfo problemMarkerInfo) {
        this.fPendingErrors.add(problemMarkerInfo);
    }

    public void flushPendingErrors() {
        int i = 0;
        while (i < this.fPendingErrors.size()) {
            ProblemMarkerInfo problemMarkerInfo = this.fPendingErrors.get(i);
            this.fErrors.add(problemMarkerInfo);
            this.fMarkerGenerator.addMarker(problemMarkerInfo);
            if (problemMarkerInfo.severity == 2) {
                this.hasErrors = true;
            }
            if (this.fErrorMsgLines.size() > 0) {
                this.outputLine(this.fErrorMsgLines.remove(0), problemMarkerInfo);
            }
            ++i;
        }
        this.fPendingErrors.clear();
    }

    private void flushPendingErrorParserErrors() {
        for (IErrorParser parser : this.fErrorParsers) {
            if (parser instanceof IFSLErrorParser3) {
                ((IFSLErrorParser3)parser).flush(this);
                continue;
            }
            if (!(parser instanceof ErrorParserNamedWrapper) || !(((ErrorParserNamedWrapper)parser).getErrorParser() instanceof IFSLErrorParser3)) continue;
            ((IFSLErrorParser3)((ErrorParserNamedWrapper)parser).getErrorParser()).flush(this);
        }
        this.flushPendingErrors();
    }

    public String getPreviousLine() {
        return new String(this.previousLine == null ? "" : this.previousLine);
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    public OutputStream getOutputStream() {
        ++this.nOpens;
        return this;
    }

    public synchronized void close() throws IOException {
        if (this.previousErrorParser instanceof IFSLErrorParser3) {
            ((IFSLErrorParser3)this.previousErrorParser).flush(this);
            this.previousErrorParser = null;
        }
        this.flushPendingErrors();
        if (this.nOpens > 0 && --this.nOpens == 0) {
            this.checkLine(true);
            this.fDirectoryStack.removeAllElements();
        }
        this.outputLineQueue.setAllDone();
        this.outputDoneLines();
    }

    public void flush() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
        }
    }

    public synchronized void write(int b) throws IOException {
        this.currentLine.append((char)b);
        this.checkLine(false);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off != 0 || len < 0 || len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.currentLine.append(new String(b, 0, len));
        this.checkLine(false);
    }

    private void checkLine(boolean flush) {
        String buffer = this.currentLine.toString();
        int i = 0;
        while ((i = buffer.indexOf(10)) != -1) {
            String line = buffer.substring(0, i);
            if (line.endsWith("\r")) {
                line = line.substring(0, line.length() - 1);
            }
            if (!line.equals(this.previousLine)) {
                this.processLine(line);
            } else {
                this.registerOutputLine(line, true);
                this.outputLine(line, null);
            }
            this.previousLine = line;
            buffer = buffer.substring(i + 1);
        }
        this.currentLine.setLength(0);
        if (flush) {
            if (buffer.length() > 0) {
                this.processLine(buffer);
                this.previousLine = buffer;
            }
        } else {
            this.currentLine.append(buffer);
        }
    }

    @Deprecated
    public boolean reportProblems() {
        return false;
    }

    private URI toURI(IPath path) {
        URI baseURI = this.getWorkingDirectoryURI();
        String uriString = path.toString();
        if (path.isAbsolute() && uriString.charAt(0) != '/') {
            uriString = String.valueOf('/') + uriString;
        }
        return EFSExtensionManager.getDefault().createNewURIFromPath(baseURI, uriString);
    }

    @Deprecated
    public String getScratchBuffer() {
        return this.scratchBuffer.toString();
    }

    @Deprecated
    public void appendToScratchBuffer(String line) {
        this.scratchBuffer.append(line);
    }

    @Deprecated
    public void clearScratchBuffer() {
        this.scratchBuffer.setLength(0);
    }

    @Deprecated
    public boolean hasErrors() {
        return this.hasErrors;
    }

    public static String[] getUserDefinedErrorParserIds() {
        return FSLErrorParserExtensionManager.getUserDefinedErrorParserIds();
    }

    public static void setUserDefinedErrorParsers(IErrorParserNamed[] errorParsers) throws CoreException {
        FSLErrorParserExtensionManager.setUserDefinedErrorParsers(errorParsers);
    }

    public static String[] getErrorParserAvailableIds() {
        return FSLErrorParserExtensionManager.getErrorParserAvailableIds();
    }

    public static String[] getErrorParserAvailableIdsInContext(String context) {
        return FSLErrorParserExtensionManager.getErrorParserAvailableIdsInContext(context);
    }

    public static String[] getErrorParserExtensionIds() {
        return FSLErrorParserExtensionManager.getErrorParserExtensionIds();
    }

    public static void setDefaultErrorParserIds(String[] ids) throws BackingStoreException {
        FSLErrorParserExtensionManager.setDefaultErrorParserIds(ids);
    }

    public static String[] getDefaultErrorParserIds() {
        return FSLErrorParserExtensionManager.getDefaultErrorParserIds();
    }

    public static IErrorParserNamed getErrorParserCopy(String id) {
        return FSLErrorParserExtensionManager.getErrorParserCopy(id, false);
    }

    public static IErrorParserNamed getErrorParserExtensionCopy(String id) {
        return FSLErrorParserExtensionManager.getErrorParserCopy(id, true);
    }

    public static String toDelimitedString(String[] ids) {
        String result = "";
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            result = result.length() == 0 ? id : String.valueOf(result) + ';' + id;
            ++n2;
        }
        return result;
    }

    public void shutdown() {
        for (IErrorParser parser : this.fErrorParsers) {
            if (parser instanceof IErrorParser3) {
                ((IErrorParser3)parser).shutdown();
                continue;
            }
            if (!(parser instanceof ErrorParserNamedWrapper) || !(((ErrorParserNamedWrapper)parser).getErrorParser() instanceof IErrorParser3)) continue;
            ((IErrorParser3)((ErrorParserNamedWrapper)parser).getErrorParser()).shutdown();
        }
        this.flushPendingErrors();
    }

    public IErrorParser getPreviousErrorParser() {
        return this.previousErrorParser;
    }

    public void resetPreviousErrorParser() {
        this.previousErrorParser = null;
    }

    protected IMarkerGenerator getMarkerGenerator() {
        return this.fMarkerGenerator;
    }
}

