/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard;

import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.context.ProcessorConfiguration;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import java.util.List;
import org.eclipse.swt.widgets.Text;

public class DescriptionUpdater {
    public static void updateDescription(Text descriptionText, ProcessorConfiguration pConfiguration) {
        if (descriptionText.getData() != null && descriptionText.getData().equals(pConfiguration)) {
            return;
        }
        descriptionText.setData((Object)pConfiguration);
        if (pConfiguration == null) {
            descriptionText.setText("");
            return;
        }
        List cConfigurations = pConfiguration.getCoreNatureConfigurations();
        StringBuilder sb = new StringBuilder();
        for (CoreNatureConfiguration cConfiguration : cConfigurations) {
            String description = cConfiguration.getTemplate().getDescription();
            if (description.isEmpty() || sb.toString().contains(description)) continue;
            sb.append(description);
            sb.append("\n\n");
        }
        descriptionText.setText(sb.toString());
    }

    public static void updateDescription(Text text, FamilyData data) {
        if (data == null) {
            text.setText("");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Family: ").append(data.getName()).append('\n');
        sb.append(data.getDescription()).append("\n-------------\n");
        text.setText(sb.toString());
    }

    public static void setDefaultDescription(Text text) {
        text.setText("Please specify processor type.");
    }
}

