/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.imports;

import com.freescale.s32ds.cross.core.ProjectSettings;
import com.freescale.s32ds.cross.core.model.CdtTemplateInfo;
import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.Hardware;
import com.freescale.s32ds.cross.core.model.context.CoreNatureConfiguration;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreData;
import com.freescale.s32ds.cross.core.model.data.CoreKindData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.FamilyData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import com.freescale.s32ds.cross.wizard.EmbSysSettingsUtil;
import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.imports.ElfImporterValidator;
import com.freescale.s32ds.cross.wizard.imports.ImportExePage2;
import com.freescale.s32ds.cross.wizard.imports.ImportExePage3;
import com.freescale.s32ds.cross.wizard.imports.LaunchConfigUtil;
import com.nxp.s32ds.ext.rcp.databinding.validation.CIdentifierValidator;
import com.nxp.s32ds.ext.rcp.databinding.validation.ValidationUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.ui.importexecutable.AbstractImportExecutableWizard;
import org.eclipse.cdt.debug.ui.importexecutable.ImportExecutablePageOne;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.DirectorySourceContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;

public class ImportExeWizard
extends AbstractImportExecutableWizard {
    private static final String PREFIX = "Debug_";
    private static final String HR = "\n---\n";
    private static final String FAMILY = "Family: ";
    private static final String PROC = "Processor: ";
    private static final String CORE = "Core: ";
    protected final Collection<HWModel> models = Hardware.instance().getModels();
    protected CoresTreeNode preparedRoot;
    protected ImportExePage3 page3;

    public String getPageOneTitle() {
        return Messages.ImportExeWizard_import_exe_files;
    }

    public String getPageOneDescription() {
        return Messages.ImportExeWizard_select_file_or_dir_to_search;
    }

    public String getExecutableListLabel() {
        return Messages.ImportExeWizard_exe_files;
    }

    public void setupFileDialog(FileDialog dialog) {
        dialog.setText(Messages.ImportExeWizard_choose_exe);
    }

    public boolean supportsConfigurationType(ILaunchConfigurationType type) {
        return true;
    }

    public boolean userSelectsBinaryParser() {
        return false;
    }

    public void addPages() {
        this.preparedRoot = this.prepareInput();
        if (this.preparedRoot.children == null || this.preparedRoot.children.isEmpty()) {
            this.addPage((IWizardPage)new WizardPage(Messages.ImportExeWizard_cannot_import){

                public void createControl(Composite parent) {
                    this.setControl((Control)new Composite(parent, 0));
                    this.setMessage(Messages.ImportExeWizard_no_processor, 3);
                }

                public boolean canFlipToNextPage() {
                    return false;
                }

                public boolean isPageComplete() {
                    return false;
                }
            });
        } else {
            this.page3 = new ImportExePage3(Messages.ImportExeWizard_select_hw, this);
            this.addPage((IWizardPage)this.page3);
            this.pageTwo = new ImportExePage2(this);
            this.addPage((IWizardPage)this.pageTwo);
            this.pageOne = new ImportExecutablePageOne(this){

                public String[] getSupportedBinaryParserIds() {
                    return new String[]{ElfImporterValidator.getDefaultBinaryParserId()};
                }

                public String[] getSelectedExecutables() {
                    String name = ImportExeWizard.this.page3.getSelectedExecutable();
                    if (name == null) {
                        return new String[0];
                    }
                    return new String[]{name};
                }
            };
        }
    }

    public boolean performFinish() {
        ICProject proj = null;
        try {
            if (this.pageTwo.isCreateNewProjectSelected()) {
                IProject p = this.createCProjectForExecutable(this.pageTwo.getNewProjectName());
                this.setupProject(p);
                proj = CCorePlugin.getDefault().getCoreModel().create(p);
            } else {
                proj = ((ImportExePage2)this.pageTwo).getExistingCProject();
            }
            this.addBinaryParsers(proj.getProject());
            this.addExecutables(proj);
            this.writeExternalSettings(proj.getProject());
            this.setProperties(proj.getProject(), this.page3.getModel());
            if (this.pageTwo.isCreateLaunchConfigurationSelected()) {
                this.createLaunchConfiguration(proj);
            }
        }
        catch (Exception e) {
            S32DSWizardPlugin.log(e);
        }
        return true;
    }

    public boolean canFinish() {
        return super.canFinish() && this.pageTwo.equals(this.getContainer().getCurrentPage());
    }

    public void addBinaryParsers(IProject newProject) throws CoreException {
        ICProjectDescription pd = CCorePlugin.getDefault().getProjectDescription(newProject);
        pd.getDefaultSettingConfiguration().create("org.eclipse.cdt.core.BinaryParser", ElfImporterValidator.getDefaultBinaryParserId());
        CCorePlugin.getDefault().setProjectDescription(newProject, pd, true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void writeExternalSettings(IProject project) {
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project, true);
        String coreId = this.page3.getCore().getId();
        ConfigurationData ob = this.page3.getCore().getElement("coreKind");
        if (ob instanceof CoreKindData) {
            coreId = ((CoreKindData)ob).getId();
        }
        try {
            EmbSysSettingsUtil.setEmpsysDescriptionData(this.page3.getProcessor().getId(), coreId, projectDescription);
            CoreModel.getDefault().setProjectDescription(project, projectDescription, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            S32DSWizardPlugin.log(e);
        }
    }

    public String getDefaultProjectName() {
        String name = this.page3.getSelectedExecutable();
        if (name == null || name.trim().length() <= 0) {
            return "";
        }
        return CIdentifierValidator.INSTANCE.validate((Object)(name = new File(name.trim()).getName())).isOK() ? name : PREFIX + ValidationUtil.transformToValid((String)name, (Pattern)CIdentifierValidator.getPattern(), (Character)Character.valueOf('_'));
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.page3) {
            this.pageTwo.checkExecutableSettings();
        }
        return super.getNextPage(page);
    }

    public void setProperties(IProject proj, HWModel context) {
        ProjectSettings ps = new ProjectSettings(proj, "com.freescale.s32ds.cross.wizard");
        ps.append("processor", this.page3.getProcessor().getId()).append("core", this.page3.getCore().getId()).append("coreType", this.page3.getCore().getCoreKindId()).append("productVersion", S32DSWizardPlugin.getProductVersion()).store();
    }

    protected void addExecutables(ICProject project) {
        String executable = this.page3.getSelectedExecutable();
        IPath location = Path.fromOSString((String)executable);
        IFile exeFile = project.getProject().getFile(location.toFile().getName());
        try {
            exeFile.createLink(location, 256, null);
        }
        catch (Exception exception) {
            this.getImportExecutablePage2().setErrorMessage(String.format(Messages.ImportExeWizard_error_import, executable));
        }
    }

    public void setConfigurationDefaults(ILaunchConfigurationWorkingCopy config, ICProject project) {
        LaunchConfigUtil.setConfigurationDefaults(config, project.getProject(), new File(this.page3.getSelectedExecutable()).getName(), this.page3.getFamily().getId(), this.page3.getProcessor().getId(), this.page3.getCoreIndex());
        String src = ((ImportExePage2)this.pageTwo).getSource();
        if (src != null && !src.isEmpty()) {
            try {
                String type = config.getType().getSourceLocatorId();
                IPersistableSourceLocator locator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(type);
                AbstractSourceLookupDirector director = (AbstractSourceLookupDirector)locator;
                director.initializeDefaults((ILaunchConfiguration)config);
                ISourceContainer[] one = director.getSourceContainers();
                ISourceContainer[] two = new ISourceContainer[one.length + 1];
                System.arraycopy(one, 0, two, 0, one.length);
                two[one.length] = new DirectorySourceContainer((IPath)new Path(src), true);
                director.setSourceContainers(two);
                config.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, director.getMemento());
                config.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, director.getId());
                config.doSave();
            }
            catch (CoreException e) {
                S32DSWizardPlugin.log(e);
            }
        }
    }

    public Object getInitalInput() {
        return this.preparedRoot;
    }

    private CoresTreeNode prepareInput() {
        CoresTreeNode root = new CoresTreeNode(null, false, null, null);
        for (HWModel model : this.models) {
            for (FamilyData family : model.getFamilies()) {
                CoresTreeNode node = new CoresTreeNode(root, false, family, model);
                root.add(node);
                for (ConfigurationData cfp : model.searchDatas("processor", "family", (Object)family.getId())) {
                    ProcessorData p = (ProcessorData)cfp;
                    if (!this.hasExecTemplate(p, model)) continue;
                    CoresTreeNode proc = new CoresTreeNode(node, false, p, model);
                    node.add(proc);
                    HashSet<CoreKindData> ids = new HashSet<CoreKindData>();
                    for (ConfigurationData cfd : model.searchDatas("core", "processor", (Object)p.getId())) {
                        CoreData c = (CoreData)cfd;
                        if (ids.contains(c.getCoreKind())) continue;
                        ids.add(c.getCoreKind());
                        proc.add(new CoresTreeNode(proc, true, c, model));
                    }
                }
            }
        }
        return root;
    }

    private boolean hasExecTemplate(ProcessorData processorData, HWModel model) {
        List coreNatures = processorData.getCoreNatures(true);
        if (coreNatures.isEmpty()) {
            return false;
        }
        for (CoreNatureData coreNature : coreNatures) {
            List cConfigurations = CoreNatureConfiguration.getAll((CoreNatureData)coreNature);
            if (cConfigurations.isEmpty()) continue;
            for (CoreNatureConfiguration cConfiguration : cConfigurations) {
                CdtTemplateInfo toolChainInfo = cConfiguration.getTemplate().getTemplateInfo(true);
                if (toolChainInfo == null) continue;
                String toolChainId = toolChainInfo.getToolChainId();
                IToolChain toolChain = model.getRegistry().getToolChain(toolChainId);
                if (toolChain == null) continue;
                return true;
            }
        }
        return false;
    }

    protected static class CoresTreeNode {
        final HWModel model;
        final CoresTreeNode parent;
        final boolean isLeaf;
        final Object data;
        final ArrayList<CoresTreeNode> children = new ArrayList();
        final String string;
        final String lc;

        public CoresTreeNode(CoresTreeNode pe, boolean isLeaf, Object data, HWModel model) {
            this.parent = pe;
            this.isLeaf = isLeaf;
            this.data = data;
            this.model = model;
            this.string = this.toStr();
            this.lc = this.string.toLowerCase().trim();
        }

        public void add(CoresTreeNode n) {
            if (this.isLeaf) {
                throw new IllegalAccessError(Messages.ImportExeWizard_cannot_add_children);
            }
            this.children.add(n);
        }

        public String getDescription() {
            if (this.data instanceof CoreData) {
                CoreKindData ct = ((CoreData)this.data).getCoreKind();
                return ImportExeWizard.FAMILY + ((FamilyData)this.parent.parent.data).getName() + ImportExeWizard.HR + ImportExeWizard.PROC + ((ProcessorData)this.parent.data).getName() + ImportExeWizard.HR + ImportExeWizard.CORE + ct.getName() + ImportExeWizard.HR + (ct.getDescription() == null ? "" : ct.getDescription());
            }
            if (this.data instanceof FamilyData) {
                FamilyData f = (FamilyData)this.data;
                String id = f.getId().equals(f.getName()) ? "" : String.format(" (%s)", f.getId());
                return ImportExeWizard.FAMILY + f.getName() + id + ImportExeWizard.HR + f.getDescription();
            }
            if (this.data instanceof ProcessorData) {
                ProcessorData p = (ProcessorData)this.data;
                return ImportExeWizard.PROC + p.getName() + ImportExeWizard.HR + ImportExeWizard.FAMILY + ((FamilyData)this.parent.data).getName() + ImportExeWizard.HR + (p.getDescription() == null ? "" : p.getDescription());
            }
            return "";
        }

        public String toString() {
            return this.string;
        }

        private String toStr() {
            if (this.data instanceof CoreData) {
                return ((CoreData)this.data).getCoreKind().getName();
            }
            if (this.data instanceof FamilyData) {
                return ((FamilyData)this.data).getName();
            }
            if (this.data instanceof ProcessorData) {
                return ((ProcessorData)this.data).getName();
            }
            return this.data == null ? "NULL" : this.data.toString();
        }

        public boolean fits(String s) {
            return this.lc.contains(s) || this.hasMatchingParent(this, s) || this.hasMatchingChildren(this, s);
        }

        private boolean hasMatchingParent(CoresTreeNode n, String txt) {
            return n.parent != null && (n.parent.lc.contains(txt) || this.hasMatchingParent(n.parent, txt));
        }

        private boolean hasMatchingChildren(CoresTreeNode n, String txt) {
            for (CoresTreeNode o : n.children) {
                if ((!(o instanceof CoresTreeNode) || !o.toString().toLowerCase().contains(txt)) && !this.hasMatchingChildren(o, txt)) continue;
                return true;
            }
            return false;
        }
    }
}

