/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page2;

import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.wizard.ParameterControl;
import com.freescale.s32ds.cross.wizard.page2.Page2AbstractManager;
import com.freescale.s32ds.cross.wizard.page2.Page2Utils;
import com.freescale.s32ds.cross.wizard.page2.S32DSMultiPageTwo;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class GridManager
extends Page2AbstractManager {
    private final int mainRowCount;
    private final int dataRowCount;
    private final int dataSpan;
    private final int singleSpan = 2;
    private final boolean grabExcessVertical;

    public GridManager(ProcessorContext processorContext, S32DSMultiPageTwo wizardPage, Composite parent) {
        this(processorContext, wizardPage, parent, false);
    }

    public GridManager(ProcessorContext processorContext, S32DSMultiPageTwo wizardPage, Composite parent, boolean grabExcessVertical) {
        super(processorContext, wizardPage, parent);
        this.grabExcessVertical = grabExcessVertical;
        int columnsCount = this.getColumnKeys().size();
        this.mainRowCount = columnsCount > 2 ? columnsCount : 3;
        this.dataRowCount = this.mainRowCount - 1;
        this.dataSpan = columnsCount > 2 ? 1 : 2;
    }

    @Override
    protected Composite createMainComposite(Composite parent, List<String> columnKeys, List<ParameterType> parameterTypes) {
        Composite rootComposite = new Composite(parent, 0);
        rootComposite.setLayoutData((Object)this.createCompositeGridData(this.getFullWidth(), 4, 4, true, this.isGrabExcessVertical()));
        rootComposite.setLayout((Layout)new GridLayout(this.getMainRowCount(), false));
        return rootComposite;
    }

    @Override
    protected void customizeRow(List<ParameterControl> rowControls, ParameterType parameterType, Composite parentComposite) {
        int leftRows = this.getMainRowCount();
        for (ParameterControl parameterControl : rowControls) {
            Control control = parameterControl.getControl();
            if (control == null) continue;
            GridData gd = new GridData(4, 0x1000000, true, false, 1, 1);
            if ("FIRST".equals(parameterControl.getContextKey())) {
                gd.heightHint = this.getRowHeight();
                gd.grabExcessHorizontalSpace = false;
            } else if ("sdks".equals(parameterControl.getParameterType().getTag())) {
                gd.heightHint = this.getRowHeight() - 4;
            }
            int cellHorisontalSpan = this.calculateCellHorizontalSpan(parameterControl);
            if (leftRows - cellHorisontalSpan < 0) continue;
            leftRows -= cellHorisontalSpan;
            gd.horizontalSpan = cellHorisontalSpan;
            control.setLayoutData((Object)gd);
        }
        if (leftRows > 0) {
            GridData gd = new GridData(4, 0x1000000, true, false, leftRows, 1);
            Label l = Page2Utils.createLabel("", parentComposite);
            l.setLayoutData((Object)gd);
        }
    }

    protected int getMainRowCount() {
        return this.mainRowCount;
    }

    protected int getDataRowCount() {
        return this.dataRowCount;
    }

    protected int getDataSpan() {
        return this.dataSpan;
    }

    public boolean isGrabExcessVertical() {
        return this.grabExcessVertical;
    }

    private GridData createCompositeGridData(int width, int hStyle, int vStyle, boolean hGrab, boolean vGrab) {
        GridData gd = new GridData(hStyle, vStyle, hGrab, vGrab);
        gd.minimumWidth = width;
        gd.widthHint = width;
        return gd;
    }

    private int calculateCellHorizontalSpan(ParameterControl parameterControl) {
        if ("FIRST".equals(parameterControl.getContextKey())) {
            return 1;
        }
        return this.getDataHorisontalSpan(parameterControl.isSingle());
    }

    private int getDataHorisontalSpan(boolean single) {
        if (single) {
            int projectsCount = this.getProcessorContext().getProjectContexts().size();
            return projectsCount > 1 ? projectsCount : this.dataSpan;
        }
        return this.dataSpan;
    }
}

