/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.errorParsers;

import com.freescale.s32ds.cdt.core.errorParsers.CommonErrorParser;
import com.freescale.s32ds.cdt.core.errorParsers.ErrorParsersActivator;
import com.freescale.s32ds.cdt.core.errorParsers.Messages;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class MPWErrorParser
extends CommonErrorParser {
    private static int STATE_START = 0;
    private static int STATE_HEADER = 1;
    private static int STATE_SECOND = 2;
    private static int STATE_ARROW_TO_ERROR = 3;
    private static int STATE_MESSAGE_DESCRIPTION = 4;
    private static int STATE_FIRST_SEPARATING_LINE = 5;
    private static int STATE_LOCATION = 6;
    private static int STATE_SECOND_SEPARATING_LINE = 7;
    private int state = STATE_START;
    private CommonErrorParser.Message msg;
    private boolean generated;
    private String previousLine;
    private static final String FILE_PART = "File ";
    private static final String LINE_PART = "Line";
    private static final String QUOTE_PART = "\"";
    private static final String POUND_PART = "#";
    private static final Pattern m = Pattern.compile(Messages.getString("MPWErrorParser_Problems", null));

    public boolean processLine(String line, ErrorParserManager eoParser) {
        try {
            if (this.state == STATE_START && this.isProblemLine(line)) {
                return this.exit(line, this.handleFirstProblemLine(line));
            }
            if (this.state == STATE_HEADER) {
                this.state = STATE_SECOND;
                return this.exit(line, false);
            }
            if (!this.isValidLine(line) || this.isProblemLine(line)) {
                if (!this.generated && this.isValidLine(this.previousLine)) {
                    String errMsg = this.getErrorMessage(this.previousLine);
                    this.msg.appendDescription(errMsg);
                    this.generateMarker(eoParser);
                    this.clearState(this.previousLine);
                }
                if (this.isProblemLine(line)) {
                    this.handleFirstProblemLine(line);
                    return this.exit(line, true);
                }
                return this.exit(null, false);
            }
            if (this.state == STATE_SECOND) {
                this.state = STATE_ARROW_TO_ERROR;
                return this.exit(line, false);
            }
            if (this.state == STATE_ARROW_TO_ERROR) {
                this.state = STATE_MESSAGE_DESCRIPTION;
                String errMsg = this.getErrorMessage(line);
                this.msg.appendDescription(errMsg);
                return this.exit(line, false);
            }
            if (this.state == STATE_MESSAGE_DESCRIPTION) {
                this.state = STATE_FIRST_SEPARATING_LINE;
                return this.exit(line, false);
            }
            if (this.state == STATE_FIRST_SEPARATING_LINE) {
                this.state = STATE_LOCATION;
                this.getErrorLocation(line);
                return this.exit(line, false);
            }
            if (this.state == STATE_LOCATION) {
                this.state = STATE_SECOND_SEPARATING_LINE;
                if (!this.generated) {
                    this.generateMarker(eoParser);
                    this.clearState(line);
                }
                if (this.isProblemLine(line)) {
                    this.handleFirstProblemLine(line);
                    return this.exit(line, true);
                }
                return this.exit(null, true);
            }
            this.clearState(line);
        }
        catch (NumberFormatException e) {
            ErrorParsersActivator.DEFAULT.getLog().log((IStatus)new Status(4, "com.freescale.s32ds.cdt.core.errorParsers", e.getMessage(), (Throwable)e));
            this.clearState(line);
        }
        return false;
    }

    private boolean exit(String currentLine, boolean result) {
        this.previousLine = currentLine;
        return result;
    }

    private boolean isValidLine(String line) {
        boolean valid = false;
        if (line != null && (line.startsWith(POUND_PART) || line.trim().startsWith(FILE_PART))) {
            valid = true;
        }
        return valid;
    }

    private void generateMarker(ErrorParserManager eoParser) {
        if (this.msg != null) {
            IFile resource = this.msg.getFile(eoParser);
            if (resource == null) {
                eoParser.generateExternalMarker(null, this.msg.lineNumber, this.msg.getDescription(), this.msg.getMarkerSeverity(), null, this.msg.getExternalFile());
            } else {
                eoParser.generateMarker((IResource)resource, this.msg.lineNumber, this.msg.getDescription(), this.msg.getMarkerSeverity(), null);
            }
        }
    }

    private boolean handleFirstProblemLine(String line) {
        this.state = STATE_HEADER;
        this.msg = new CommonErrorParser.Message();
        this.msg.severity = this.getProblemSeverity(line);
        this.generated = false;
        return false;
    }

    private void clearState(String line) {
        this.state = STATE_START;
        this.msg = null;
        this.generated = false;
        this.previousLine = null;
    }

    private void getErrorLocation(String line) {
        int endIndex;
        int index = line.trim().indexOf(FILE_PART);
        if (index == 0 && (index = line.indexOf(QUOTE_PART)) > 0 && (endIndex = line.indexOf(QUOTE_PART, index + 1)) > index) {
            String file;
            this.msg.filePath = file = line.substring(index + 1, endIndex);
            if ((index = line.indexOf(LINE_PART, index)) > 0) {
                String lineNumber = line.substring(index + LINE_PART.length() + 1);
                try {
                    this.msg.lineNumber = Integer.parseInt(lineNumber);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    private String getErrorMessage(String line) {
        int idxOf = line.indexOf(POUND_PART);
        if (idxOf != 0) {
            return null;
        }
        return line.substring(idxOf + 1).trim();
    }

    protected boolean isProblemLine(String line) {
        return m.matcher(line).matches();
    }

    private int getProblemSeverity(String line) {
        if (line.contains(" Error")) {
            return 2;
        }
        if (line.contains(" Warning")) {
            return 1;
        }
        if (line.contains(" Note")) {
            return 0;
        }
        if (line.contains(" Status")) {
            return 0;
        }
        ErrorParsersActivator.DEFAULT.getLog().log((IStatus)new Status(4, "com.freescale.s32ds.cdt.core.errorParsers", "Unknown message type"));
        throw new IllegalArgumentException("Unknown message type");
    }
}

