/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne.RTVar;

import com.pemicro.debug.gdbjtag.pne.RTVar.IPErefreshService;
import com.pemicro.debug.gdbjtag.pne.RTVar.PErefreshAction;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.debug.internal.ui.views.expression.ExpressionView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class RealTimeVariableView
extends ExpressionView {
    private PErefreshAction fRefreshAction;
    private Boolean enableRefresh = true;
    private Timer refreshTask = new Timer();
    private static final Color WHITE_COLOR = new Color(null, 255, 255, 255);
    private static final Color GREY_COLOR = new Color(null, 211, 211, 211);
    private IPErefreshService refreshService = null;
    private int expressionColumnInt = 1;
    private int typeColumnInt = 2;
    private int valueColumnInt = 3;
    private int addressColumnInt = 4;

    public RealTimeVariableView() {
        this.refreshTask.schedule((TimerTask)new RefreshWhileRunning(), 0L, 100L);
    }

    protected void becomesHidden() {
    }

    private TreeItem nextItem(Tree tree, TreeItem item) {
        int count;
        if (item == null) {
            return null;
        }
        if (item.getExpanded() && item.getItemCount() > 0) {
            return item.getItem(0);
        }
        TreeItem childItem = item;
        TreeItem parentItem = childItem.getParentItem();
        int index = parentItem == null ? tree.indexOf(childItem) : parentItem.indexOf(childItem);
        int n = count = parentItem == null ? tree.getItemCount() : parentItem.getItemCount();
        while (index + 1 >= count) {
            if (parentItem == null) {
                return null;
            }
            childItem = parentItem;
            index = (parentItem = childItem.getParentItem()) == null ? tree.indexOf(childItem) : parentItem.indexOf(childItem);
            count = parentItem == null ? tree.getItemCount() : parentItem.getItemCount();
        }
        return parentItem == null ? tree.getItem(index + 1) : parentItem.getItem(index + 1);
    }

    private void showAddressColumn() {
        List<String> currentVisible;
        String[] columns = this.getVariablesViewer().getVisibleColumns();
        if (columns != null && !(currentVisible = Arrays.asList(columns)).contains("org.eclipse.cdt.dsf.ui.COLUMN_ID__ADDRESS")) {
            String[] visibleColumns = new String[]{"org.eclipse.debug.ui.VARIALBE_COLUMN_PRESENTATION.COL_VAR_NAME", "org.eclipse.cdt.dsf.ui.COLUMN_ID__TYPE", "org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE", "org.eclipse.cdt.dsf.ui.COLUMN_ID__ADDRESS"};
            this.getVariablesViewer().setVisibleColumns(visibleColumns);
        }
    }

    protected void getTypes(Object context) {
        if (context instanceof IDMVMContext) {
            IDMContext dmc = ((IDMVMContext)context).getDMContext();
            String inputSessionID = dmc.getSessionId();
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), inputSessionID);
            this.refreshService = (IPErefreshService)tracker.getService(IPErefreshService.class);
            tracker.dispose();
            if (this.refreshService != null && !this.refreshService.canRefresh()) {
                this.showAddressColumn();
                Tree tree = this.getVariablesViewer().getTree();
                TreeColumn[] columns = tree.getColumns();
                int typeColumnInt = -1;
                int i = 0;
                while (i < columns.length) {
                    if (columns[i].getText().equals("Type")) {
                        typeColumnInt = i;
                        break;
                    }
                    ++i;
                }
                if (typeColumnInt != -1) {
                    String displayedType = "";
                    TreeItem item = tree.getTopItem();
                    while (item != null) {
                        displayedType = item.getText(typeColumnInt);
                        if (displayedType.length() > 0 && !displayedType.contains("[")) {
                            this.refreshService.queryTypeAndStore(dmc, displayedType);
                        }
                        item = this.nextItem(tree, item);
                    }
                }
            }
        }
    }

    public synchronized void viewerUpdatesComplete() {
        super.viewerUpdatesComplete();
        this.getTypes(this.getViewer().getInput());
    }

    protected void setViewerInput(Object context) {
        if (context == null) {
            this.refreshDetailPaneContents();
        }
        Object current = this.getViewer().getInput();
        this.getTypes(context);
        if (current == null && context == null) {
            return;
        }
        if (current != null && current.equals(context)) {
            return;
        }
        if (context instanceof IDMVMContext && this.refreshService != null && this.refreshService.canRefresh()) {
            this.showViewer();
            this.updateObjects();
            return;
        }
        this.showViewer();
        this.getViewer().setInput(context);
        this.updateObjects();
    }

    public void toggleRefresh() {
        this.enableRefresh = this.enableRefresh == false;
    }

    private void disableRefresh() {
        this.enableRefresh = false;
    }

    private boolean itemIsPointee(TreeItem item) {
        String itemName = item.getText(this.expressionColumnInt);
        if (itemName.contains("*") || itemName.contains("->")) {
            return true;
        }
        TreeItem parentItem = item.getParentItem();
        while (parentItem != null) {
            String parentItemType = parentItem.getText(this.typeColumnInt);
            if (parentItemType.contains("*")) {
                return true;
            }
            parentItem = parentItem.getParentItem();
        }
        return false;
    }

    private void refreshTree() {
        Object viewerInput;
        if (this.enableRefresh.booleanValue() && (viewerInput = this.getVariablesViewer().getInput()) instanceof IDMVMContext) {
            if (this.refreshService != null && this.refreshService.canRefresh()) {
                Tree tree = this.getVariablesViewer().getTree();
                TreeColumn[] columns = tree.getColumns();
                int i = 0;
                while (i < columns.length) {
                    if (columns[i].getText().equals("Expression")) {
                        this.expressionColumnInt = i;
                    }
                    if (columns[i].getText().equals("Type")) {
                        this.typeColumnInt = i;
                    }
                    if (columns[i].getText().equals("Value")) {
                        this.valueColumnInt = i;
                    }
                    if (columns[i].getText().equals("Address")) {
                        this.addressColumnInt = i;
                    }
                    ++i;
                }
                Rectangle rect = tree.getClientArea();
                TreeItem item = tree.getTopItem();
                while (item != null) {
                    if (this.itemIsPointee(item)) {
                        item.setBackground(this.expressionColumnInt, GREY_COLOR);
                        item.setBackground(this.typeColumnInt, GREY_COLOR);
                        item.setBackground(this.valueColumnInt, GREY_COLOR);
                        item.setBackground(this.addressColumnInt, GREY_COLOR);
                    } else {
                        item.setBackground(this.expressionColumnInt, WHITE_COLOR);
                        item.setBackground(this.typeColumnInt, WHITE_COLOR);
                        item.setBackground(this.valueColumnInt, WHITE_COLOR);
                        item.setBackground(this.addressColumnInt, WHITE_COLOR);
                    }
                    Rectangle itemRect = item.getBounds();
                    this.refreshService.updateValue(this.valueColumnInt, this.addressColumnInt, this.typeColumnInt, item);
                    if (itemRect.y + itemRect.height <= rect.y + rect.height) {
                        item = this.nextItem(tree, item);
                        continue;
                    }
                    break;
                }
            } else {
                this.getVariablesViewer().getControl().setToolTipText("");
            }
        }
    }

    protected void createActions() {
        super.createActions();
        this.fRefreshAction = new PErefreshAction(this);
        this.getControl().addListener(32, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TreeItem item = RealTimeVariableView.this.getVariablesViewer().getTree().getItem(point);
                RealTimeVariableView.this.getVariablesViewer().getControl().setToolTipText("");
                if (item != null && RealTimeVariableView.this.refreshService != null && RealTimeVariableView.this.refreshService.canRefresh() && RealTimeVariableView.this.itemIsPointee(item)) {
                    RealTimeVariableView.this.getVariablesViewer().getControl().setToolTipText("Dereferenced pointer values may not be accurate");
                }
            }
        });
    }

    public void dispose() {
        this.disableRefresh();
        this.refreshTask.cancel();
        super.dispose();
    }

    protected void configureToolBar(IToolBarManager tbm) {
        super.configureToolBar(tbm);
        tbm.add((IAction)this.fRefreshAction);
    }

    class RefreshWhileRunning
    extends TimerTask {
        RefreshWhileRunning() {
        }

        @Override
        public void run() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    RealTimeVariableView.this.refreshTree();
                }
            });
        }
    }
}

