/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne;

import com.pemicro.debug.gdbjtag.pne.Activator;
import com.pemicro.debug.gdbjtag.pne.SharedStorage;
import com.pemicro.debug.gdbjtag.pne.api.IVendorPack;
import com.pemicro.debug.gdbjtag.pne.ui.TabDebugger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.dsf.gdb.launching.LaunchUtils;
import org.eclipse.cdt.internal.core.envvar.EnvVarCollector;
import org.eclipse.cdt.internal.core.envvar.EnvVarDescriptor;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.internal.core.envvar.IEnvironmentContextInfo;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.ini4j.Config;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Wini;

public class Utils {
    private static final String PROPERTY_OS_NAME = "os.name";
    public static final String PROPERTY_OS_VALUE_WINDOWS = "windows";
    public static final String PROPERTY_OS_VALUE_LINUX = "linux";
    public static final String PROPERTY_OS_VALUE_MACOSX = "mac";
    private static final Map<String, IdeEnum> ideMap;
    private static boolean DEBUG;

    static {
        HashMap<String, IdeEnum> initializer = new HashMap<String, IdeEnum>();
        initializer.put("com.freescale.s32ds.cdt.ide", IdeEnum.S32_DESIGN_STUDIO);
        initializer.put("com.freescale.s32ds.arm.ide", IdeEnum.S32_DESIGN_STUDIO);
        initializer.put("com.somniumtech.branding.kds.ide", IdeEnum.KINETIS_DESIGN_STUDIO);
        initializer.put("com.crt.lpcxpresso.brand.product", IdeEnum.LPC_XPRESSO);
        initializer.put("org.eclipse.platform.ide", IdeEnum.GENERIC_ECLIPSE);
        initializer.put("com.ifx.davex.product.dave", IdeEnum.INFINEON_DAVE);
        initializer.put("com.nxp.s32ds.vision.ide.product", IdeEnum.S32_DESIGN_STUDIO);
        initializer.put("com.nxp.s32ds.arm.ide.product", IdeEnum.S32_DESIGN_STUDIO);
        ideMap = Collections.unmodifiableMap(initializer);
        DEBUG = false;
    }

    public static void debugPrint(String message) {
        if (DEBUG) {
            System.out.println(message);
        }
    }

    public static IdeEnum getCurrentIde() {
        String product_id = Platform.getProduct().getId();
        if (ideMap.containsKey(product_id)) {
            return ideMap.get(product_id);
        }
        if (product_id.matches("com\\.somniumtech\\..*")) {
            return IdeEnum.SOMNIUM_DRT;
        }
        Utils.debugPrint("Unrecognized IDE, defaulting to Generic Eclipse");
        return IdeEnum.GENERIC_ECLIPSE;
    }

    public static int getNumberOfCores(String vendor_family_device) {
        int numCores;
        String[] delimited = vendor_family_device.split("_");
        if (delimited.length != 3) {
            return 1;
        }
        String vendor = delimited[0];
        String family = delimited[1];
        String device = delimited[2];
        String ddfFileFullPath = String.valueOf(Utils.getGdbServerPath()) + "gdi" + File.separator + "P&E" + File.separator + "supportFiles_ARM" + File.separator + vendor + File.separator + family + File.separator + device + ".DDF";
        Wini addIni = new Wini();
        Config config = new Config();
        addIni.setConfig(config);
        try {
            addIni.load(new File(ddfFileFullPath));
        }
        catch (InvalidFileFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            numCores = Integer.parseInt(addIni.get((Object)"runControl", (Object)"numcores"));
        }
        catch (NumberFormatException e) {
            numCores = 1;
            e.printStackTrace();
        }
        return numCores;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayList<String> getAvailableDevices() {
        try {
            String[] cmdarray = new String[]{String.valueOf(Utils.getGdbServerPath()) + "pegdbserver_console", "-devicelist"};
            final Process p = ProcessFactory.getFactory().exec(cmdarray);
            try {
                ArrayList<String> deviceList = Utils.timedCall(new Callable<ArrayList<String>>(){

                    @Override
                    public ArrayList<String> call() throws Exception {
                        String line;
                        ArrayList<String> devices = new ArrayList<String>();
                        InputStream stdout = p.getInputStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(stdout));
                        while ((line = reader.readLine()) != null) {
                            if (line.contains("-devicelist")) break;
                        }
                        IdeEnum currentIde = Utils.getCurrentIde();
                        block6: while ((line = reader.readLine()) != null) {
                            switch (currentIde) {
                                case S32_DESIGN_STUDIO: {
                                    if (!line.matches("NXP_(?:KEx_S9KEAZ|S32\\w+_|MAC57D5xx_|MWCTx_|SJA1110x_)\\w+")) continue block6;
                                    devices.add(line);
                                    break;
                                }
                                case KINETIS_DESIGN_STUDIO: {
                                    if (!line.matches("NXP_.+_.+")) continue block6;
                                    devices.add(line);
                                    break;
                                }
                                case INFINEON_DAVE: {
                                    if (!line.toUpperCase().matches("INFINEON_.+_.+")) continue block6;
                                    devices.add(line);
                                    break;
                                }
                                default: {
                                    devices.add(line);
                                }
                            }
                        }
                        p.waitFor();
                        return devices;
                    }
                }, 10L, TimeUnit.SECONDS);
                Collections.sort(deviceList);
                return deviceList;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                p.destroy();
                return null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return null;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                return null;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static String getDefaultGdbClientPath() {
        String gdb_client_path;
        switch (Utils.getCurrentIde()) {
            case S32_DESIGN_STUDIO: {
                gdb_client_path = "";
                break;
            }
            case LPC_XPRESSO: {
                gdb_client_path = "${eclipse_home}/tools/bin/arm-none-eabi-gdb";
                break;
            }
            case SOMNIUM_DRT: {
                gdb_client_path = "${cross_prefix}gdb${cross_suffix}";
                break;
            }
            case INFINEON_DAVE: {
                gdb_client_path = "${ARM_GCC_HOME}/bin/arm-none-eabi-gdb";
                break;
            }
            default: {
                gdb_client_path = SharedStorage.getGdbClientExecutable("${eclipse_home}/../toolchain/bin/arm-none-eabi-gdb");
            }
        }
        return gdb_client_path;
    }

    private static IVendorPack getVendorPack() {
        IVendorPack vendorPack = null;
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor("com.pemicro.debug.gdbjtag.pne.vendorpack");
        if (config.length == 1) {
            try {
                Object o = config[0].createExecutableExtension("class");
                vendorPack = (IVendorPack)o;
            }
            catch (CoreException e) {
                e.printStackTrace();
                vendorPack = null;
            }
        }
        if (vendorPack == null) {
            vendorPack = new IVendorPack(){

                @Override
                public String getGdbServerBase() {
                    return Utils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                }
            };
        }
        return vendorPack;
    }

    private static void setExecuteBits(String executablePath) {
        HashSet<PosixFilePermission> server_mode = new HashSet<PosixFilePermission>();
        server_mode.add(PosixFilePermission.OWNER_EXECUTE);
        server_mode.add(PosixFilePermission.OWNER_READ);
        server_mode.add(PosixFilePermission.OWNER_WRITE);
        server_mode.add(PosixFilePermission.GROUP_READ);
        server_mode.add(PosixFilePermission.GROUP_EXECUTE);
        server_mode.add(PosixFilePermission.OTHERS_READ);
        server_mode.add(PosixFilePermission.OTHERS_EXECUTE);
        java.nio.file.Path server = Paths.get(executablePath, new String[0]);
        try {
            Files.setPosixFilePermissions(server, server_mode);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getGdbServerPath() {
        IVendorPack vendorPack = Utils.getVendorPack();
        String path = vendorPack.getGdbServerBase();
        if (Utils.isWindows()) {
            path = String.valueOf(path) + "win32";
        } else if (Utils.isLinux()) {
            path = String.valueOf(path) + "lin";
        } else if (Utils.isMacOSX()) {
            path = String.valueOf(path) + "osx";
            Utils.setExecuteBits(String.valueOf(path) + "/pegdbserver_console");
        } else {
            path = String.valueOf(path) + "other";
        }
        File serverExecutable = new File(path);
        try {
            return String.valueOf(serverExecutable.getCanonicalPath()) + File.separator;
        }
        catch (IOException e) {
            e.printStackTrace();
            return String.valueOf(serverExecutable.getAbsolutePath()) + File.separator;
        }
    }

    public static void addMultiLine(String multiLine, List<String> commandsList) throws CoreException {
        if (multiLine.length() > 0) {
            String[] commandsStr;
            multiLine = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(multiLine);
            String[] stringArray = commandsStr = multiLine.split("\\r?\\n");
            int n = commandsStr.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if ((str = str.trim()).length() > 0) {
                    commandsList.add(str);
                }
                ++n2;
            }
        }
    }

    public static String composeCommandWithLf(Collection<String> commands) {
        if (commands.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Iterator<String> it = commands.iterator();
        while (it.hasNext()) {
            String s = it.next().trim();
            if (s.length() == 0 || s.startsWith("#")) continue;
            sb.append(s);
            if (!it.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String escapeWhitespaces(String path) {
        String[] segments = (path = path.trim()).split("\\s");
        if (segments.length > 1) {
            if (Utils.isWindows()) {
                return "\"" + path + "\"";
            }
            StringBuffer escapedPath = new StringBuffer();
            int index = 0;
            while (index < segments.length) {
                escapedPath.append(segments[index]);
                if (index + 1 < segments.length) {
                    escapedPath.append("\\ ");
                }
                ++index;
            }
            return escapedPath.toString().trim();
        }
        return path;
    }

    public static boolean isWindows() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(PROPERTY_OS_VALUE_WINDOWS);
    }

    public static boolean isLinux() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(PROPERTY_OS_VALUE_LINUX);
    }

    public static boolean isMacOSX() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(PROPERTY_OS_VALUE_MACOSX);
    }

    public static IPath getGDBPath(ILaunchConfiguration configuration) {
        String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
        Path retVal = new Path(defaultGdbCommand);
        try {
            String gdb = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            gdb = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(gdb, false);
            ICConfigurationDescription buildConfig = Utils.getBuildConfig(configuration);
            if (buildConfig != null) {
                gdb = Utils.resolveAll(gdb, buildConfig);
            }
            retVal = new Path(gdb);
        }
        catch (CoreException coreException) {}
        return retVal;
    }

    public static String getGDBVersion(ILaunchConfiguration configuration) throws CoreException {
        Process process;
        String[] cmdArray = new String[]{TabDebugger.getGdbClientCommand(configuration), "--version"};
        try {
            process = ProcessFactory.getFactory().exec(cmdArray, Utils.getLaunchEnvironment(configuration));
        }
        catch (IOException e) {
            throw new DebugException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 5012, "Error while launching command: " + Utils.join(cmdArray, " "), e.getCause()));
        }
        Job timeoutJob = new Job("GDB version timeout job"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(IProgressMonitor arg) {
                process.destroy();
                return Status.OK_STATUS;
            }
        };
        timeoutJob.schedule(10000L);
        InputStream stream = null;
        StringBuilder cmdOutput = new StringBuilder(200);
        try {
            try {
                String line;
                stream = process.getInputStream();
                InputStreamReader r = new InputStreamReader(stream);
                BufferedReader reader = new BufferedReader(r);
                while ((line = reader.readLine()) != null) {
                    cmdOutput.append(line);
                    cmdOutput.append('\n');
                }
            }
            catch (IOException e) {
                throw new DebugException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 5012, "Error reading GDB STDOUT after sending: " + Utils.join(cmdArray, " ") + ", response: " + cmdOutput, e.getCause()));
            }
        }
        catch (Throwable throwable) {
            timeoutJob.cancel();
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            process.destroy();
            throw throwable;
        }
        timeoutJob.cancel();
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        process.destroy();
        String gdbVersion = LaunchUtils.getGDBVersionFromText((String)cmdOutput.toString());
        if (gdbVersion == null || gdbVersion.isEmpty()) {
            throw new DebugException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", 5012, "Could not determine GDB version after sending: " + Utils.join(cmdArray, " ") + ", response: " + cmdOutput, null));
        }
        return gdbVersion;
    }

    public static String[] getLaunchEnvironment(ILaunchConfiguration config) throws CoreException {
        ICdtVariable[] build_vars;
        IEnvironmentVariable[] vars;
        ICConfigurationDescription cfg = Utils.getBuildConfig(config);
        if (cfg == null) {
            return Utils.getLaunchEnvironmentWithoutProject();
        }
        HashMap<String, String> envMap = new HashMap<String, String>();
        IEnvironmentVariable[] iEnvironmentVariableArray = vars = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariables(cfg, true);
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironmentVariable var = iEnvironmentVariableArray[n2];
            envMap.put(var.getName(), var.getValue());
            ++n2;
        }
        ICdtVariable[] iCdtVariableArray = build_vars = CCorePlugin.getDefault().getCdtVariableManager().getVariables(cfg);
        int n3 = build_vars.length;
        n = 0;
        while (n < n3) {
            ICdtVariable var = iCdtVariableArray[n];
            try {
                if (!"project_classpath".equals(var.getName())) {
                    envMap.put(var.getName(), var.getStringValue());
                }
            }
            catch (CdtVariableException cdtVariableException) {}
            ++n;
        }
        ArrayList<String> strings = new ArrayList<String>(envMap.size());
        for (Map.Entry entry : envMap.entrySet()) {
            StringBuffer buffer = new StringBuffer((String)entry.getKey());
            buffer.append('=').append((String)entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static ICConfigurationDescription getBuildConfig(ILaunchConfiguration config) {
        ICProjectDescription projDesc;
        ICConfigurationDescription cfg;
        block11: {
            IProject project;
            block10: {
                String projectName;
                block9: {
                    block8: {
                        cfg = null;
                        try {
                            projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
                            if (projectName != null) break block8;
                            return null;
                        }
                        catch (CoreException coreException) {}
                    }
                    projectName = projectName.trim();
                    if (projectName.length() != 0) break block9;
                    return null;
                }
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (project != null && project.isAccessible()) break block10;
                return null;
            }
            projDesc = CoreModel.getDefault().getProjectDescription(project, false);
            if (projDesc != null) break block11;
            return null;
        }
        String buildConfigID = config.getAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", "");
        if (buildConfigID.length() != 0) {
            cfg = projDesc.getConfigurationById(buildConfigID);
        }
        if (cfg == null) {
            cfg = projDesc.getActiveConfiguration();
        }
        return cfg;
    }

    public static String resolveAll(String value, ICConfigurationDescription cfgDescription) {
        try {
            return CCorePlugin.getDefault().getCdtVariableManager().resolveValue(value, "", " ", cfgDescription);
        }
        catch (CdtVariableException e) {
            Activator.log(e);
            return value;
        }
    }

    public static String join(String[] strArray, String joiner) {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = strArray;
        int n = strArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            sb.append(item);
            sb.append(joiner);
            ++n2;
        }
        return sb.toString().trim();
    }

    public static File getProjectOsPath(ILaunchConfiguration configuration) throws CoreException {
        IPath path = null;
        File dir = null;
        if (configuration != null) {
            String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (projectName.length() > 0) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject project = workspace.getRoot().getProject(projectName);
                path = project.getLocation();
            } else {
                String executableName = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
                path = new Path(executableName).removeLastSegments(1);
            }
        }
        if (path != null) {
            dir = new File(path.toOSString());
        }
        return dir;
    }

    public static String[] getLaunchEnvironmentWithoutProject() throws CoreException {
        String[] retVal = null;
        IEnvironmentContextInfo contextInfo = EnvironmentVariableManager.getDefault().getContextInfo(null);
        EnvVarCollector envVarMergedColletion = EnvironmentVariableManager.getVariables((IEnvironmentContextInfo)contextInfo, (boolean)true);
        if (envVarMergedColletion != null) {
            EnvVarDescriptor[] envVars = envVarMergedColletion.toArray(false);
            if (envVars != null) {
                ArrayList<String> strings = new ArrayList<String>();
                int i = 0;
                while (i < envVars.length) {
                    IEnvironmentVariable resolved = EnvironmentVariableManager.getDefault().calculateResolvedVariable(envVars[i], contextInfo);
                    if (resolved != null && !"project_classpath".equals(resolved.getName())) {
                        StringBuffer buffer = new StringBuffer(resolved.getName());
                        buffer.append('=').append(resolved.getValue());
                        strings.add(buffer.toString());
                    }
                    ++i;
                }
                retVal = strings.toArray(new String[strings.size()]);
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "com.pemicro.debug.gdbjtag.pne", "Error retrieving workspace environment."));
        }
        return retVal;
    }

    public static int compareVersions(String v1, String v2) {
        if (v1 == null || v2 == null) {
            throw new NullPointerException();
        }
        String[] v1Parts = v1.split("\\.");
        String[] v2Parts = v2.split("\\.");
        int i = 0;
        while (i < v1Parts.length && i < v2Parts.length) {
            int v2PartValue;
            int v1PartValue;
            block16: {
                try {
                    v1PartValue = Integer.parseInt(v1Parts[i]);
                    v2PartValue = Integer.parseInt(v2Parts[i]);
                    if (v1PartValue <= v2PartValue) break block16;
                    return 1;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (v1PartValue < v2PartValue) {
                return -1;
            }
            ++i;
        }
        if (v1Parts.length < v2Parts.length) {
            i = v1Parts.length;
            while (i < v2Parts.length) {
                try {
                    if (Integer.parseInt(v2Parts[i]) != 0) {
                        return -1;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                ++i;
            }
        }
        if (v1Parts.length > v2Parts.length) {
            i = v2Parts.length;
            while (i < v1Parts.length) {
                try {
                    if (Integer.parseInt(v1Parts[i]) != 0) {
                        return 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                ++i;
            }
        }
        return 0;
    }

    public static <T> T timedCall(Callable<T> c, long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService THREAD_POOL = Executors.newCachedThreadPool();
        FutureTask<T> task = new FutureTask<T>(c);
        THREAD_POOL.execute(task);
        return task.get(timeout, timeUnit);
    }

    public static enum IdeEnum {
        S32_DESIGN_STUDIO,
        KINETIS_DESIGN_STUDIO,
        LPC_XPRESSO,
        SOMNIUM_DRT,
        INFINEON_DAVE,
        GENERIC_ECLIPSE;

    }
}

