/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne.ui;

import com.pemicro.debug.gdbjtag.pne.Activator;
import com.pemicro.debug.gdbjtag.pne.Utils;
import com.pemicro.debug.gdbjtag.pne.ui.AlgorithmParser;
import com.pemicro.debug.gdbjtag.pne.ui.Messages;
import com.pemicro.debug.gdbjtag.pne.ui.TabDebugger;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.ini4j.Config;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Wini;

public class AdvancedProgrammingDialog
extends Dialog {
    private static final int TEXT_FIELD_WIDTH_HINT = 60;
    TabDebugger parentDialog;
    Combo algorithmSelectCombo;
    Button alternativeAlgorithmButton;
    Button algorithmBrowseButton;
    Label selectedAlgorithm;
    Button macScriptButton;
    Button macScriptBrowseButton;
    Button macScriptVariablesButton;
    Text macScriptText;
    Button useDaisyChainButton;
    Text jtagTapNumberText;
    Text jtagPreIrNumberText;
    Label programTrimDefaultLabel;
    Label programTrimRangeLabel;
    Button programTrimButton;
    Button customTrimButton;
    Text customTrimText;
    Label partionEepromLabel;
    Label partitionFlexnvmLabel;
    Button enablePartitionButton;
    Text partitionParameterText;
    Button preservePartitionButton;
    Combo eraseOptionSelectCombo;
    private static boolean MacPathExists = false;
    private static boolean use_init_script = false;
    ConfigurationClass storedConfig;
    MemoryRange[] preserveRangeArray;
    private ControlDecoration partitionWarning;
    private ControlDecoration trimWarning;

    public AdvancedProgrammingDialog(TabDebugger parent, Shell parentShell) {
        super(parentShell);
        this.parentDialog = parent;
        this.storedConfig = new ConfigurationClass();
        this.preserveRangeArray = new MemoryRange[3];
        int i = 0;
        while (i < 3) {
            this.preserveRangeArray[i] = new MemoryRange(this);
            ++i;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Messages.getString("AdvancedSettings.WindowTitle"));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        GridData data = new GridData(768);
        container.setLayoutData((Object)data);
        Composite stackedGroups = new Composite(container, 0);
        layout = new GridLayout();
        stackedGroups.setLayout((Layout)layout);
        data = new GridData(770);
        stackedGroups.setLayoutData((Object)data);
        Group group = new Group(stackedGroups, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        data = new GridData(768);
        group.setLayoutData((Object)data);
        group.setText(Messages.getString("AdvancedSettings.FlashAlgorithmSelectionTitle"));
        Label label = new Label((Composite)group, 16448);
        data = new GridData();
        data.widthHint = 300;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(Messages.getString("AdvancedSettings.FlashAlgorithmPrompt"));
        this.algorithmSelectCombo = new Combo((Composite)group, 12);
        data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 300;
        this.algorithmSelectCombo.setLayoutData((Object)data);
        this.alternativeAlgorithmButton = new Button((Composite)group, 32);
        this.alternativeAlgorithmButton.setText(Messages.getString("AdvancedSettings.FlashAlgorithmUseAlternative"));
        this.alternativeAlgorithmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.getSource()).getSelection();
                AdvancedProgrammingDialog.this.algorithmBrowseButton.setEnabled(enabled);
                AdvancedProgrammingDialog.this.selectedAlgorithm.setVisible(enabled);
                AdvancedProgrammingDialog.this.updateEraseOptions();
            }
        });
        this.algorithmBrowseButton = new Button((Composite)group, 0);
        this.algorithmBrowseButton.setText(Messages.getString("AdvancedSettings.FlashAlgorithmBrowseButton"));
        this.algorithmBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(AdvancedProgrammingDialog.this.getShell(), 0);
                dialog.setText(Messages.getString("AdvancedSettings.AlgorithmBrowseTitle"));
                String str = AdvancedProgrammingDialog.this.storedConfig.alternativeAlgorithmPath;
                int lastSeparatorIndex = str.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
                }
                String[] algorithmFilter = new String[]{"*.arp"};
                dialog.setFilterExtensions(algorithmFilter);
                str = dialog.open();
                if (str != null) {
                    AdvancedProgrammingDialog.this.storedConfig.alternativeAlgorithmPath = str;
                    File file = new File(AdvancedProgrammingDialog.this.storedConfig.alternativeAlgorithmPath);
                    AdvancedProgrammingDialog.this.selectedAlgorithm.setText(file.getName());
                }
            }
        });
        this.selectedAlgorithm = new Label((Composite)group, 16384);
        data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 300;
        this.selectedAlgorithm.setLayoutData((Object)data);
        group = new Group(stackedGroups, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        data = new GridData(768);
        group.setLayoutData((Object)data);
        group.setText(Messages.getString("AdvancedSettings.InitializationScriptTitle"));
        label = new Label((Composite)group, 16448);
        data = new GridData();
        data.widthHint = 300;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(Messages.getString("AdvancedSettings.InitializationScriptPrompt"));
        this.macScriptButton = new Button((Composite)group, 16416);
        data = new GridData();
        data.horizontalSpan = 2;
        this.macScriptButton.setLayoutData((Object)data);
        this.macScriptButton.setText(Messages.getString("AdvancedSettings.InitializationScriptEnable"));
        this.macScriptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.getSource()).getSelection();
                AdvancedProgrammingDialog.this.initializationScriptSelected(enabled);
            }
        });
        this.macScriptText = new Text((Composite)group, 2052);
        data = new GridData(768);
        data.horizontalSpan = 2;
        this.macScriptText.setLayoutData((Object)data);
        this.macScriptBrowseButton = new Button((Composite)group, 0);
        this.macScriptBrowseButton.setText(Messages.getString("AdvancedSettings.InitializationScriptBrowseButton"));
        this.macScriptBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(AdvancedProgrammingDialog.this.getShell(), 0);
                dialog.setText(Messages.getString("AdvancedSettings.InitializationScriptBrowseButton_Title"));
                String path = AdvancedProgrammingDialog.this.storedConfig.macScriptPath;
                int lastSeparatorIndex = path.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(path.substring(0, lastSeparatorIndex));
                }
                if ((path = dialog.open()) != null) {
                    AdvancedProgrammingDialog.this.storedConfig.macScriptPath = path;
                    AdvancedProgrammingDialog.this.macScriptText.setText(path);
                }
            }
        });
        this.macScriptVariablesButton = new Button((Composite)group, 0);
        this.macScriptVariablesButton.setText(Messages.getString("DebuggerTab.ClientVariablesButton"));
        this.macScriptVariablesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedProgrammingDialog.this.MacScriptVariablesButtonSelected(AdvancedProgrammingDialog.this.macScriptText);
            }
        });
        group = new Group(stackedGroups, 0);
        layout = new GridLayout(4, false);
        group.setLayout((Layout)layout);
        data = new GridData(768);
        group.setLayoutData((Object)data);
        group.setText(Messages.getString("AdvancedSettings.JtagDaisyChainTitle"));
        this.useDaisyChainButton = new Button((Composite)group, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.useDaisyChainButton.setLayoutData((Object)data);
        this.useDaisyChainButton.setText(Messages.getString("AdvancedSettings.JtagDaisyChainEnableButton"));
        this.useDaisyChainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.getSource()).getSelection();
                AdvancedProgrammingDialog.this.jtagTapNumberText.setEnabled(enabled);
                AdvancedProgrammingDialog.this.jtagPreIrNumberText.setEnabled(enabled);
            }
        });
        Button infoButton = new Button((Composite)group, 0);
        infoButton.setText(Messages.getString("AdvancedSettings.JtagInfoButton"));
        data = new GridData();
        data.horizontalSpan = 2;
        infoButton.setLayoutData((Object)data);
        infoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Dialog dialog = new Dialog(AdvancedProgrammingDialog.this.getShell()){

                    protected Control createDialogArea(Composite parent) {
                        Composite container = (Composite)super.createDialogArea(parent);
                        this.getShell().setText(Messages.getString("AdvancedSettings.DaisyChainInfoTitle"));
                        Image image = new Image((Device)parent.getDisplay(), String.valueOf(Utils.getGdbServerPath()) + ".." + File.separator + "icons" + File.separator + "Daisy_Chain_Diagram.bmp");
                        Label label = new Label(container, 0);
                        label.setImage(image);
                        return container;
                    }

                    protected void createButtonsForButtonBar(Composite parent) {
                        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
                    }
                };
                dialog.open();
            }
        });
        label = new Label((Composite)group, 16384);
        label.setText(Messages.getString("AdvancedSettings.JtagDaisyChainTapLabel"));
        this.jtagTapNumberText = new Text((Composite)group, 18436);
        data = new GridData();
        data.widthHint = 60;
        this.jtagTapNumberText.setLayoutData((Object)data);
        this.jtagTapNumberText.addVerifyListener((VerifyListener)new NumericVerifier());
        label = new Label((Composite)group, 16384);
        label.setText(Messages.getString("AdvancedSettings.JtagDaisyChainPreIRLabel"));
        this.jtagPreIrNumberText = new Text((Composite)group, 18436);
        data = new GridData();
        data.widthHint = 60;
        this.jtagPreIrNumberText.setLayoutData((Object)data);
        this.jtagPreIrNumberText.addVerifyListener((VerifyListener)new NumericVerifier());
        group = new Group(stackedGroups, 0);
        layout = new GridLayout(4, false);
        group.setLayout((Layout)layout);
        data = new GridData(768);
        group.setLayoutData((Object)data);
        group.setText(Messages.getString("AdvancedSettings.EraseOptionsTitle"));
        this.eraseOptionSelectCombo = new Combo((Composite)group, 12);
        data = new GridData();
        data.horizontalSpan = 2;
        data.widthHint = 300;
        this.eraseOptionSelectCombo.setLayoutData((Object)data);
        group = new Group(container, 0);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        data = new GridData(768);
        group.setLayoutData((Object)data);
        group.setText(Messages.getString("AdvancedSettings.PreserveRangeTitle"));
        label = new Label((Composite)group, 16448);
        data = new GridData();
        data.widthHint = 205;
        label.setLayoutData((Object)data);
        label.setText(Messages.getString("AdvancedSettings.PreserveRangePrompt"));
        int i = 0;
        while (i < 3) {
            this.preserveRangeArray[i].createDialogArea((Composite)group, i);
            ++i;
        }
        group = new Group(container, 0);
        layout = new GridLayout(3, false);
        group.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        group.setText(Messages.getString("AdvancedSettings.ProgramTrimTitle"));
        this.programTrimButton = new Button((Composite)group, 16416);
        data = new GridData();
        data.horizontalSpan = 3;
        this.programTrimButton.setLayoutData((Object)data);
        this.programTrimButton.setText(Messages.getString("AdvancedSettings.ProgramTrimAndCalculateButton"));
        this.programTrimButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.getSource()).getSelection();
                AdvancedProgrammingDialog.this.customTrimButton.setEnabled(enabled);
                AdvancedProgrammingDialog.this.customTrimText.setEnabled(enabled && AdvancedProgrammingDialog.this.customTrimButton.getSelection());
                AdvancedProgrammingDialog.this.errorCheck();
            }
        });
        label = new Label((Composite)group, 16384);
        label.setText(Messages.getString("AdvancedSettings.ProgramTrimDefaultLabel"));
        this.programTrimDefaultLabel = new Label((Composite)group, 16384);
        this.programTrimRangeLabel = new Label((Composite)group, 16384);
        this.customTrimButton = new Button((Composite)group, 16416);
        this.customTrimButton.setText(Messages.getString("AdvancedSettings.ProgramTrimUseCustomTrim"));
        this.customTrimButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.getSource()).getSelection();
                AdvancedProgrammingDialog.this.customTrimText.setEnabled(enabled);
                AdvancedProgrammingDialog.this.errorCheck();
            }
        });
        this.trimWarning = new ControlDecoration((Control)this.customTrimButton, 131200);
        this.trimWarning.setDescriptionText(Messages.getString("AdvancedSettings.ProgramTrimWarning"));
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.trimWarning.setImage(fieldDecoration.getImage());
        this.customTrimText = new Text((Composite)group, 2048);
        data = new GridData();
        data.widthHint = 60;
        data.horizontalIndent = 5;
        this.customTrimText.setLayoutData((Object)data);
        this.customTrimText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String text = ((Text)e.getSource()).getText();
                e.doit = Character.isISOControl(e.character) ? true : (e.character == '.' ? !text.contains(".") : e.text.matches("\\d"));
            }
        });
        this.customTrimText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((Text)e.getSource()).getText();
                try {
                    AdvancedProgrammingDialog.this.errorCheck();
                }
                catch (NullPointerException ex) {
                    ex.printStackTrace();
                }
            }
        });
        label = new Label((Composite)group, 16384);
        label.setText(Messages.getString("AdvancedSettings.ProgramTrimUnitLabel"));
        group = new Group(container, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        group.setText(Messages.getString("AdvancedSettings.PartitionTitle"));
        this.enablePartitionButton = new Button((Composite)group, 16416);
        this.enablePartitionButton.setText(Messages.getString("AdvancedSettings.PartitionDoPartitionButton"));
        this.enablePartitionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = ((Button)e.getSource()).getSelection();
                AdvancedProgrammingDialog.this.partitionParameterText.setEnabled(enabled);
                try {
                    AdvancedProgrammingDialog.this.errorCheck();
                }
                catch (NullPointerException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.partitionWarning = new ControlDecoration((Control)this.enablePartitionButton, 131200);
        this.partitionWarning.setDescriptionText(Messages.getString("AdvancedSettings.PartitionWarning"));
        this.partitionWarning.setImage(fieldDecoration.getImage());
        this.partitionParameterText = new Text((Composite)group, 2048);
        data = new GridData();
        data.widthHint = 60;
        this.partitionParameterText.setLayoutData((Object)data);
        this.partitionParameterText.setTextLimit(4);
        this.partitionParameterText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isISOControl(e.character) ? true : e.text.matches("[0-9a-fA-F]");
            }
        });
        this.partitionParameterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ((Text)e.getSource()).getText();
                try {
                    AdvancedProgrammingDialog.this.errorCheck();
                }
                catch (NullPointerException ex) {
                    ex.printStackTrace();
                }
            }
        });
        label = new Label((Composite)group, 0);
        label.setText(Messages.getString("AdvancedSettings.PartitionHint1"));
        this.preservePartitionButton = new Button((Composite)group, 16416);
        this.preservePartitionButton.setText(Messages.getString("AdvancedSettings.PartitionPreservePartitionButton"));
        label = new Label((Composite)group, 0);
        this.partionEepromLabel = new Label((Composite)group, 16384);
        label = new Label((Composite)group, 0);
        label = new Label((Composite)group, 0);
        this.partitionFlexnvmLabel = new Label((Composite)group, 16384);
        this.updateDialog();
        return container;
    }

    private void MacScriptVariablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.insert(dialog.getVariableExpression());
        }
    }

    private boolean isPartitionValid(String partition) {
        boolean valid = true;
        if (partition.length() != 4) {
            valid = false;
        } else {
            int partitionInt;
            DynamicRanges dr = this.getDynamicRanges();
            try {
                partitionInt = Integer.parseInt(partition, 16);
            }
            catch (NumberFormatException numberFormatException) {
                partitionInt = 0;
            }
            int eeprom = (partitionInt & 0xFF00) >> 8;
            int flexNvm = partitionInt & 0xFF;
            if (eeprom < dr.partitionEepromStart || eeprom > dr.partitionEepromEnd) {
                valid = false;
            }
            if (flexNvm < dr.partitionFlexNvmStart || flexNvm > dr.partitionFlexNvmEnd) {
                valid = false;
            }
        }
        return valid;
    }

    private boolean isTrimValid(String trim) {
        double trimValue;
        DynamicRanges dr = this.getDynamicRanges();
        boolean valid = true;
        try {
            trimValue = Double.parseDouble(trim);
        }
        catch (NumberFormatException numberFormatException) {
            trimValue = 0.0;
        }
        if (trimValue < dr.trimBegin || trimValue > dr.trimEnd) {
            valid = false;
        }
        return valid;
    }

    private void updateEraseOptions() {
        int flashmemoryprotection = 0;
        File algorithmFile = null;
        try {
            Wini ddfIni = this.getDdfFile();
            String flashMemoryProtectionValue = ddfIni.get((Object)"runcontrol", (Object)"flashmemoryprotection");
            flashmemoryprotection = flashMemoryProtectionValue != null ? Integer.parseInt(flashMemoryProtectionValue) : 0;
        }
        catch (IOException e) {
            flashmemoryprotection = 0;
            e.printStackTrace();
        }
        this.eraseOptionSelectCombo.removeAll();
        this.eraseOptionSelectCombo.add(Messages.getString("AdvancedSettings.EraseModuleItem"));
        this.eraseOptionSelectCombo.select(0);
        this.eraseOptionSelectCombo.setEnabled(false);
        if (flashmemoryprotection == 1 && !this.alternativeAlgorithmButton.getSelection()) {
            int comboIndex = this.algorithmSelectCombo.getSelectionIndex();
            String algorithmName = this.algorithmSelectCombo.getItem(comboIndex);
            String[] vfdStrings = this.parentDialog.deviceString.split("_");
            algorithmFile = new File(String.valueOf(Utils.getGdbServerPath()) + "gdi" + File.separator + "P&E" + File.separator + "supportFiles_ARM" + File.separator + vfdStrings[0] + File.separator + vfdStrings[1] + File.separator + algorithmName);
            AlgorithmParser algParser = new AlgorithmParser();
            algParser.parseSRecords(algorithmFile);
            if (algParser.isRunningAlgorithm()) {
                byte[] cmdTable = algParser.getCommandTable();
                if (cmdTable.length != 0) {
                    this.eraseOptionSelectCombo.setEnabled(true);
                }
                this.eraseOptionSelectCombo.removeAll();
                boolean eraseModuleAvailable = false;
                boolean eraseObjectFileAvailable = false;
                boolean eraseObjectFileUnlockAvailable = false;
                int i = 0;
                while (i < cmdTable.length) {
                    switch (cmdTable[i]) {
                        case 9: {
                            eraseModuleAvailable = true;
                            break;
                        }
                        case 31: {
                            eraseObjectFileAvailable = true;
                            break;
                        }
                        case 34: {
                            eraseObjectFileUnlockAvailable = true;
                        }
                    }
                    ++i;
                }
                this.storedConfig.eraseComboToCommand.clear();
                if (eraseObjectFileAvailable) {
                    String tempString = Messages.getString("AdvancedSettings.EraseObjectFileItem");
                    this.eraseOptionSelectCombo.add(tempString);
                    this.storedConfig.eraseComboToCommand.put(this.eraseOptionSelectCombo.indexOf(tempString), 0);
                }
                if (eraseModuleAvailable) {
                    String tempString = Messages.getString("AdvancedSettings.EraseModuleItem");
                    this.eraseOptionSelectCombo.add(tempString);
                    this.storedConfig.eraseComboToCommand.put(this.eraseOptionSelectCombo.indexOf(tempString), 1);
                }
                if (eraseObjectFileUnlockAvailable) {
                    String tempString = Messages.getString("AdvancedSettings.EraseObjectFileUnlockItem");
                    this.eraseOptionSelectCombo.add(tempString);
                    this.storedConfig.eraseComboToCommand.put(this.eraseOptionSelectCombo.indexOf(tempString), 2);
                }
                this.eraseOptionSelectCombo.select(this.storedConfig.eraseOptionIndex);
            }
        }
    }

    private void updateDialog() {
        boolean localServerEnabled = this.parentDialog.localLaunchButton.getSelection();
        boolean run_script = this.storedConfig.macScriptEnabled;
        this.macScriptButton.setSelection(run_script);
        this.macScriptButton.setEnabled(localServerEnabled);
        this.macScriptText.setText(this.storedConfig.macScriptPath);
        this.initializationScriptSelected(run_script && localServerEnabled);
        this.useDaisyChainButton.setSelection(this.storedConfig.useDaisyChain);
        boolean enabled = !this.parentDialog.swdButton.getSelection() && localServerEnabled;
        this.useDaisyChainButton.setEnabled(enabled);
        enabled = enabled && this.storedConfig.useDaisyChain;
        this.jtagTapNumberText.setEnabled(enabled);
        this.jtagPreIrNumberText.setEnabled(enabled);
        this.jtagTapNumberText.setText(String.valueOf(this.storedConfig.jtagTapNumber));
        this.jtagPreIrNumberText.setText(String.valueOf(this.storedConfig.jtagPreIrNumber));
        MemoryRange[] memoryRangeArray = this.preserveRangeArray;
        int n = this.preserveRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryRange memRange = memoryRangeArray[n2];
            enabled = memRange.config.preserveRange;
            memRange.preserveRangeButton.setSelection(enabled);
            memRange.fromText.setText(Long.toHexString(memRange.config.fromValue));
            memRange.toText.setText(Long.toHexString(memRange.config.toValue));
            memRange.setEnabled(enabled);
            if (enabled) {
                if (memRange.isRangeValid(memRange.fromText.getText(), memRange.toText.getText())) {
                    memRange.preserveWarning.hide();
                } else {
                    memRange.preserveWarning.show();
                }
            } else {
                memRange.preserveWarning.hide();
            }
            ++n2;
        }
        try {
            Wini ddfIni = this.getDdfFile();
            String algorithm = ddfIni.get((Object)this.parentDialog.deviceString.toLowerCase(), (Object)"flashalg");
            int numAlgs = (Integer)ddfIni.get((Object)this.parentDialog.deviceString.toLowerCase(), (Object)"numaltalgs", Integer.TYPE);
            this.algorithmSelectCombo.add(algorithm);
            if (numAlgs > 0) {
                int i = 1;
                while (i <= numAlgs) {
                    algorithm = ddfIni.get((Object)this.parentDialog.deviceString.toLowerCase(), (Object)("flashalg" + i));
                    this.algorithmSelectCombo.add(algorithm);
                    ++i;
                }
            }
            this.algorithmSelectCombo.select(this.storedConfig.algorithmIndex);
            this.alternativeAlgorithmButton.setSelection(this.storedConfig.useAlternativeAlgorithm);
            File file = new File(this.storedConfig.alternativeAlgorithmPath);
            this.selectedAlgorithm.setText(file.getName());
            this.algorithmSelectCombo.setEnabled(localServerEnabled);
            this.alternativeAlgorithmButton.setEnabled(localServerEnabled);
            enabled = localServerEnabled && this.storedConfig.useAlternativeAlgorithm;
            this.algorithmBrowseButton.setEnabled(enabled);
            this.selectedAlgorithm.setVisible(enabled);
            this.updateEraseOptions();
            enabled = this.storedConfig.programTrim;
            this.programTrimButton.setSelection(enabled);
            this.customTrimButton.setEnabled(enabled);
            this.customTrimButton.setSelection(this.storedConfig.useCustomTrim);
            enabled = enabled && this.storedConfig.useCustomTrim;
            double param = this.storedConfig.customTrimFrequency;
            this.customTrimText.setText(String.valueOf(param /= 100.0));
            this.customTrimText.setEnabled(enabled);
            if (enabled) {
                if (this.isTrimValid(this.customTrimText.getText())) {
                    this.trimWarning.hide();
                } else {
                    this.trimWarning.show();
                }
            } else {
                this.trimWarning.hide();
            }
            enabled = this.storedConfig.enablePartitioning;
            this.enablePartitionButton.setSelection(enabled);
            this.partitionParameterText.setText(Integer.toHexString(this.storedConfig.partitionParam));
            this.partitionParameterText.setEnabled(enabled);
            if (enabled) {
                if (this.isPartitionValid(this.partitionParameterText.getText())) {
                    this.partitionWarning.hide();
                } else {
                    this.partitionWarning.show();
                }
            } else {
                this.partitionWarning.hide();
            }
            this.preservePartitionButton.setSelection(this.storedConfig.preserveParition);
            this.updateDynamicLabels();
        }
        catch (InvalidFileFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initializationScriptSelected(boolean enabled) {
        this.macScriptText.setEnabled(enabled);
        this.macScriptBrowseButton.setEnabled(enabled);
        this.macScriptVariablesButton.setEnabled(enabled);
    }

    private Wini getDdfFile() throws IOException, InvalidFileFormatException {
        String[] vfdStrings = this.parentDialog.deviceString.split("_");
        File ddfFile = new File(String.valueOf(Utils.getGdbServerPath()) + "gdi" + File.separator + "P&E" + File.separator + "supportFiles_ARM" + File.separator + vfdStrings[0] + File.separator + vfdStrings[1] + File.separator + vfdStrings[2] + ".DDF");
        Wini ddfIni = new Wini();
        Config config = new Config();
        config.setLowerCaseSection(true);
        ddfIni.setConfig(config);
        ddfIni.load(ddfFile);
        return ddfIni;
    }

    private DynamicRanges getDynamicRanges() {
        DynamicRanges out = new DynamicRanges();
        try {
            Wini ddfIni = this.getDdfFile();
            out.trimDefault = Double.parseDouble(ddfIni.get((Object)"runcontrol", (Object)"trim_default"));
            out.trimBegin = Double.parseDouble(ddfIni.get((Object)"runcontrol", (Object)"trim_begin"));
            out.trimEnd = Double.parseDouble(ddfIni.get((Object)"runcontrol", (Object)"trim_end"));
            String partitionStart = ddfIni.get((Object)"runcontrol", (Object)"partition_begin");
            String partitionEnd = ddfIni.get((Object)"runcontrol", (Object)"partition_end");
            out.partitionEepromStart = Integer.parseInt(partitionStart.substring(0, 2), 16);
            out.partitionEepromEnd = Integer.parseInt(partitionEnd.substring(0, 2), 16);
            out.partitionFlexNvmStart = Integer.parseInt(partitionStart.substring(2), 16);
            out.partitionFlexNvmEnd = Integer.parseInt(partitionEnd.substring(2), 16);
        }
        catch (InvalidFileFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out;
    }

    private void updateDynamicLabels() {
        DynamicRanges dr = this.getDynamicRanges();
        if (dr.trimDefault == 0.0) {
            this.programTrimButton.setEnabled(false);
            this.customTrimButton.setEnabled(false);
            this.customTrimText.setEnabled(false);
        }
        this.programTrimDefaultLabel.setText(Double.toString(dr.trimDefault));
        String value = String.format(Messages.getString("AdvancedSettings.ProgramTrimValidRange"), Double.toString(dr.trimBegin), Double.toString(dr.trimEnd));
        this.programTrimRangeLabel.setText(value);
        if (dr.partitionEepromEnd == 0) {
            this.enablePartitionButton.setEnabled(false);
            this.partitionParameterText.setEnabled(false);
            this.preservePartitionButton.setEnabled(false);
        }
        value = Messages.getString("AdvancedSettings.PartitionHint2");
        value = String.format(value, dr.partitionEepromStart, dr.partitionEepromEnd);
        this.partionEepromLabel.setText(value);
        value = Messages.getString("AdvancedSettings.PartitionHint3");
        value = String.format(value, dr.partitionFlexNvmStart, dr.partitionFlexNvmEnd);
        this.partitionFlexnvmLabel.setText(value);
    }

    protected void okPressed() {
        this.storedConfig.update();
        super.okPressed();
    }

    public static boolean getMacPathExist() {
        return MacPathExists;
    }

    public static boolean getInitScriptPath() {
        return use_init_script;
    }

    public static void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.macScript", "");
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.macScriptEnable", false);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.useDaisyChain", false);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.jtagTapNumber", 0);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.jtagPreIrBits", 0);
        int i = 0;
        while (i < 3) {
            configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.preserveMemory" + i, false);
            configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.preserveMemoryFrom" + i, "0");
            configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.preserveMemoryTo" + i, "3");
            ++i;
        }
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.algorithmIndex", 0);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.useAlternativeAlgorithm", false);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.alternativeAlgorithmPath", "");
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.programtrim", false);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.useCustomTrim", false);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.customTrimFrequency", 0);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.doPartitioning", false);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.partitionParam", 0);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.preservePartioning", false);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.eraseOptionsenabled", false);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.eraseCommandParam", "EM");
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.executeUnlockCommand", false);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            int customTrimInt;
            this.storedConfig.macScriptEnabled = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.macScriptEnable", false);
            this.storedConfig.macScriptPath = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.macScript", "");
            this.storedConfig.useDaisyChain = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.useDaisyChain", false);
            this.storedConfig.jtagTapNumber = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.jtagTapNumber", 0);
            this.storedConfig.jtagPreIrNumber = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.jtagPreIrBits", 0);
            int i = 0;
            while (i < 3) {
                this.preserveRangeArray[i].config.preserveRange = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.preserveMemory" + i, false);
                String param = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.preserveMemoryFrom" + i, "0");
                this.preserveRangeArray[i].config.fromValue = Long.parseLong(param, 16);
                param = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.preserveMemoryTo" + i, "3");
                this.preserveRangeArray[i].config.toValue = Long.parseLong(param, 16);
                ++i;
            }
            this.storedConfig.algorithmIndex = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.algorithmIndex", 0);
            this.storedConfig.useAlternativeAlgorithm = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.useAlternativeAlgorithm", false);
            this.storedConfig.alternativeAlgorithmPath = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.alternativeAlgorithmPath", "");
            this.storedConfig.programTrim = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.programtrim", false);
            this.storedConfig.useCustomTrim = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.useCustomTrim", false);
            this.storedConfig.customTrimFrequency = customTrimInt = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.customTrimFrequency", 0);
            this.storedConfig.enablePartitioning = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.doPartitioning", false);
            this.storedConfig.partitionParam = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.partitionParam", 0);
            this.storedConfig.preserveParition = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.preservePartioning", false);
            this.storedConfig.eraseOptionIndex = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.eraseOptionIndex", 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.macScriptEnable", this.storedConfig.macScriptEnabled);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.macScript", this.storedConfig.macScriptPath);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.useDaisyChain", this.storedConfig.useDaisyChain);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.jtagTapNumber", this.storedConfig.jtagTapNumber);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.jtagPreIrBits", this.storedConfig.jtagPreIrNumber);
        int i = 0;
        while (i < 3) {
            configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.preserveMemory" + i, this.preserveRangeArray[i].config.preserveRange);
            configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.preserveMemoryFrom" + i, Long.toHexString(this.preserveRangeArray[i].config.fromValue));
            configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.preserveMemoryTo" + i, Long.toHexString(this.preserveRangeArray[i].config.toValue));
            ++i;
        }
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.algorithmIndex", this.storedConfig.algorithmIndex);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.useAlternativeAlgorithm", this.storedConfig.useAlternativeAlgorithm);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.alternativeAlgorithmPath", this.storedConfig.alternativeAlgorithmPath);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.programtrim", this.storedConfig.programTrim);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.useCustomTrim", this.storedConfig.useCustomTrim);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.customTrimFrequency", this.storedConfig.customTrimFrequency);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.doPartitioning", this.storedConfig.enablePartitioning);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.partitionParam", this.storedConfig.partitionParam);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.preservePartioning", this.storedConfig.preserveParition);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.eraseOptionIndex", this.storedConfig.eraseOptionIndex);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.eraseOptionsenabled", this.storedConfig.eraseOptionEnabled);
        if (!this.storedConfig.eraseComboToCommand.isEmpty()) {
            int eraseOptionSelected = (Integer)this.storedConfig.eraseComboToCommand.get(this.storedConfig.eraseOptionIndex);
            switch (eraseOptionSelected) {
                case 0: {
                    configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.eraseCommandParam", "EO");
                    configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.executeUnlockCommand", false);
                    break;
                }
                case 1: {
                    configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.eraseCommandParam", "EM");
                    configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.executeUnlockCommand", false);
                    break;
                }
                case 2: {
                    configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.eraseCommandParam", "EO");
                    configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.executeUnlockCommand", true);
                    break;
                }
                default: {
                    configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.eraseCommandParam", "EM");
                    configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.executeUnlockCommand", false);
                }
            }
        }
    }

    public static List<String> getGdbServerCommandLineArray(List<String> commands, Wini commandIni, ILaunchConfiguration configuration) {
        String sectionString = "STARTUP";
        try {
            boolean tempBool;
            use_init_script = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.macScriptEnable", false);
            if (use_init_script) {
                commandIni.put("SCRIPTFILE", "NUM_EXTRA_USER_SCRIPTFILES", (Object)1);
                String init_script_path = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.macScript", "");
                MacPathExists = false;
                try {
                    init_script_path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(init_script_path, false).trim();
                    File tempFile = new File(init_script_path);
                    if (tempFile.exists() && !tempFile.isDirectory()) {
                        MacPathExists = true;
                    }
                }
                catch (CoreException e) {
                    Activator.log(e);
                    MacPathExists = false;
                }
                commandIni.put("SCRIPTFILE", "EXTRA_USER_SCRIPTFILE1", (Object)init_script_path);
            }
            if (commands.contains("-usejtag")) {
                tempBool = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.useDaisyChain", false);
                commandIni.put(sectionString, "jtag_use_daisy_chain", (Object)(tempBool ? "1" : "0"));
                if (tempBool) {
                    commandIni.put(sectionString, "user_specified_daisy_chain", (Object)"1");
                    int tempInt = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.jtagTapNumber", 0);
                    commandIni.put(sectionString, "jtag_tap_num", (Object)tempInt);
                    tempInt = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.jtagPreIrBits", 0);
                    commandIni.put(sectionString, "jtag_numbits_pre_ir", (Object)tempInt);
                }
            }
            sectionString = "PEDEBUG";
            int index = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.algorithmIndex", 0);
            commandIni.put(sectionString, "CURRENT_ALGORITHM_INDEX", (Object)String.valueOf(index));
            tempBool = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.useAlternativeAlgorithm", false);
            if (tempBool) {
                commandIni.put(sectionString, "ALTERNATIVE_ALGORITHM_CHECKBOX", (Object)"1");
                String param = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.alternativeAlgorithmPath", "");
                commandIni.put(sectionString, "ALTERNATIVE_ALGORITHM_PATH", (Object)param);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return commands;
    }

    void errorCheck() {
        boolean error_found = false;
        this.trimWarning.hide();
        if (this.programTrimButton.getEnabled() && this.programTrimButton.getSelection() && this.customTrimButton.getSelection() && !this.isTrimValid(this.customTrimText.getText())) {
            this.trimWarning.show();
            error_found = true;
        }
        this.partitionWarning.hide();
        if (this.enablePartitionButton.getEnabled() && this.enablePartitionButton.getSelection() && !this.isPartitionValid(this.partitionParameterText.getText())) {
            this.partitionWarning.show();
            error_found = true;
        }
        MemoryRange[] memoryRangeArray = this.preserveRangeArray;
        int n = this.preserveRangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryRange mr = memoryRangeArray[n2];
            mr.preserveWarning.hide();
            if (mr.preserveRangeButton.getSelection() && !mr.isRangeValid(mr.fromText.getText(), mr.toText.getText())) {
                mr.preserveWarning.show();
                error_found = true;
            }
            ++n2;
        }
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(!error_found);
        }
    }

    class ConfigurationClass {
        int eraseOptionIndex = 0;
        boolean eraseOptionEnabled;
        private HashMap<Integer, Integer> eraseComboToCommand = new HashMap();
        int algorithmIndex;
        boolean useAlternativeAlgorithm;
        String alternativeAlgorithmPath;
        boolean macScriptEnabled;
        String macScriptPath;
        boolean useDaisyChain;
        int jtagTapNumber;
        int jtagPreIrNumber;
        boolean programTrim;
        boolean useCustomTrim;
        int customTrimFrequency;
        boolean enablePartitioning;
        int partitionParam;
        boolean preserveParition;

        ConfigurationClass() {
        }

        public void update() {
            int partition;
            int trim;
            this.algorithmIndex = AdvancedProgrammingDialog.this.algorithmSelectCombo.getSelectionIndex();
            this.useAlternativeAlgorithm = AdvancedProgrammingDialog.this.alternativeAlgorithmButton.getSelection();
            this.macScriptEnabled = AdvancedProgrammingDialog.this.macScriptButton.getSelection();
            this.macScriptPath = AdvancedProgrammingDialog.this.macScriptText.getText();
            this.useDaisyChain = AdvancedProgrammingDialog.this.useDaisyChainButton.getSelection();
            String param = AdvancedProgrammingDialog.this.jtagTapNumberText.getText();
            this.jtagTapNumber = param.isEmpty() ? 0 : Integer.parseInt(param);
            param = AdvancedProgrammingDialog.this.jtagPreIrNumberText.getText();
            this.jtagPreIrNumber = param.isEmpty() ? 0 : Integer.parseInt(param);
            this.eraseOptionIndex = AdvancedProgrammingDialog.this.eraseOptionSelectCombo.getSelectionIndex();
            this.eraseOptionEnabled = AdvancedProgrammingDialog.this.eraseOptionSelectCombo.getEnabled();
            MemoryRange[] memoryRangeArray = AdvancedProgrammingDialog.this.preserveRangeArray;
            int n = AdvancedProgrammingDialog.this.preserveRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MemoryRange memRange = memoryRangeArray[n2];
                memRange.config.preserveRange = memRange.preserveRangeButton.getSelection();
                param = memRange.fromText.getText();
                param = param.isEmpty() ? "0" : param;
                memRange.config.fromValue = Long.parseLong(param, 16);
                param = memRange.toText.getText();
                param = param.isEmpty() ? "3" : param;
                memRange.config.toValue = Long.parseLong(param, 16);
                ++n2;
            }
            this.programTrim = AdvancedProgrammingDialog.this.programTrimButton.getSelection();
            this.useCustomTrim = AdvancedProgrammingDialog.this.customTrimButton.getSelection();
            this.customTrimFrequency = trim = (int)(Double.parseDouble(AdvancedProgrammingDialog.this.customTrimText.getText()) * 100.0);
            this.enablePartitioning = AdvancedProgrammingDialog.this.enablePartitionButton.getSelection();
            this.partitionParam = partition = Integer.parseInt(AdvancedProgrammingDialog.this.partitionParameterText.getText(), 16);
            this.preserveParition = AdvancedProgrammingDialog.this.preservePartitionButton.getSelection();
        }
    }

    private class DynamicRanges {
        double trimDefault;
        double trimBegin;
        double trimEnd;
        int partitionEepromStart;
        int partitionEepromEnd;
        int partitionFlexNvmStart;
        int partitionFlexNvmEnd;

        private DynamicRanges() {
        }
    }

    public class MemoryRange {
        public static final int NUM_PRESERVE_RANGES = 3;
        AdvancedProgrammingDialog parentDialog;
        Button preserveRangeButton;
        ControlDecoration preserveWarning;
        Text fromText;
        Text toText;
        ConfigurationClass config;

        MemoryRange(AdvancedProgrammingDialog parent) {
            this.parentDialog = parent;
            this.config = new ConfigurationClass();
        }

        public void createDialogArea(Composite parent, int index) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(4, false);
            composite.setLayout((Layout)gridLayout);
            GridData data = new GridData(768);
            composite.setLayoutData((Object)data);
            this.preserveRangeButton = new Button(composite, 16416);
            data = new GridData();
            data.horizontalSpan = 4;
            this.preserveRangeButton.setLayoutData((Object)data);
            this.preserveRangeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = ((Button)e.getSource()).getSelection();
                    MemoryRange.this.setEnabled(enabled);
                    try {
                        MemoryRange.this.parentDialog.errorCheck();
                    }
                    catch (NullPointerException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            String preserveRangeText = String.format(Messages.getString("AdvancedSettings.PreserveRangeFormatString"), index);
            this.preserveRangeButton.setText(preserveRangeText);
            this.preserveWarning = new ControlDecoration((Control)this.preserveRangeButton, 131200);
            this.preserveWarning.setDescriptionText(Messages.getString("AdvancedSettings.PreserveRangeWarning"));
            FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
            this.preserveWarning.setImage(fieldDecoration.getImage());
            Label label = new Label(composite, 16384);
            label.setText(Messages.getString("AdvancedSettings.FromString"));
            this.fromText = new Text(composite, 18436);
            data = new GridData();
            data.widthHint = 60;
            this.fromText.setLayoutData((Object)data);
            this.fromText.setTextLimit(8);
            this.fromText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    e.doit = Character.isISOControl(e.character) ? true : e.text.matches("[0-9a-fA-F]");
                }
            });
            this.fromText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        MemoryRange.this.parentDialog.errorCheck();
                    }
                    catch (NullPointerException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            label = new Label(composite, 16384);
            label.setText(Messages.getString("AdvancedSettings.ToString"));
            this.toText = new Text(composite, 18436);
            data = new GridData();
            data.widthHint = 60;
            this.toText.setLayoutData((Object)data);
            this.toText.setTextLimit(8);
            this.toText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    e.doit = Character.isISOControl(e.character) ? true : e.text.matches("[0-9a-fA-F]");
                }
            });
            this.toText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        MemoryRange.this.parentDialog.errorCheck();
                    }
                    catch (NullPointerException ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }

        public void setEnabled(boolean enabled) {
            this.fromText.setEnabled(enabled);
            this.toText.setEnabled(enabled);
        }

        public boolean isRangeValid(String fromString, String toString) {
            boolean valid = true;
            int from = 0;
            int to = 0;
            try {
                from = Integer.parseInt(fromString, 16);
            }
            catch (NumberFormatException numberFormatException) {
                from = 0;
            }
            try {
                to = Integer.parseInt(toString, 16);
            }
            catch (NumberFormatException numberFormatException) {
                to = 0;
            }
            if (from >= to) {
                valid = false;
            }
            if (from % 4 != 0) {
                valid = false;
            }
            if (to % 4 != 3) {
                valid = false;
            }
            return valid;
        }

        class ConfigurationClass {
            boolean preserveRange;
            long fromValue;
            long toValue;

            ConfigurationClass() {
            }
        }
    }

    class NumericVerifier
    implements VerifyListener {
        NumericVerifier() {
        }

        public void verifyText(VerifyEvent e) {
            e.doit = Character.isISOControl(e.character) ? true : e.text.matches("\\d");
        }
    }
}

