/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.debug.gdbjtag.pne.ui;

import com.pemicro.corePlugin.Server;
import com.pemicro.debug.gdbjtag.pne.Activator;
import com.pemicro.debug.gdbjtag.pne.SharedStorage;
import com.pemicro.debug.gdbjtag.pne.Utils;
import com.pemicro.debug.gdbjtag.pne.api.PemicroUtil;
import com.pemicro.debug.gdbjtag.pne.ui.AdvancedProgrammingDialog;
import com.pemicro.debug.gdbjtag.pne.ui.DeviceTree;
import com.pemicro.debug.gdbjtag.pne.ui.HardwareInterfaceSettings;
import com.pemicro.debug.gdbjtag.pne.ui.Messages;
import com.pemicro.debug.gdbjtag.pne.ui.TreeLabelProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.ini4j.Config;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Wini;

public class TabDebugger
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Debugger";
    private static final String TAB_ID = "com.pemicro.debug.gdbjtag.pne.ui.debuggertab";
    private DeviceTree deviceTreeContent;
    public String deviceString;
    private int numCores;
    private HardwareInterfaceSettings hardwareInterfaces;
    static ArrayList<HardwarePorts> detectedHardwareInterfaces;
    private static int corbaError;
    private Group registrationGroup;
    Combo interfaceCombo;
    Combo probeAddressCombo;
    private Button refreshButton;
    private Button selectDeviceButton;
    private ControlDecoration deviceWarning;
    private Label vendorLabel;
    private Label familyLabel;
    private Label deviceLabel;
    Button specifyIPButton;
    Text specifyIPText;
    Button specifyNetworkCardButton;
    Text specifyNetworkCardText;
    private Label selectCoreLabel;
    private Combo selectCoreCombo;
    Button eraseButton;
    Button swdButton;
    private Button advancedOptions;
    private AdvancedProgrammingDialog advancedDialog;
    Button providePowerButton;
    Text powerDownDelayText;
    Text powerUpDelayText;
    Button powerOffButton;
    Combo voltageCombo;
    Text freqText;
    Button delayAfterResetButton;
    Text delayAfterResetText;
    public Button localLaunchButton;
    private Text gdbmiPortText;
    private Text serverIpText;
    private Text serverPortText;
    private Text peGdbServerOptions;
    private ControlDecoration serverPortTip;
    private ControlDecoration clientWarning;
    private Text clientExecutableText;
    private Text clientOtherOptionsText;
    private Text clientOtherCommandsText;
    private boolean didGdbClientExecutableChange;
    protected Button fUpdateThreadlistOnSuspend;

    protected TabDebugger() {
        detectedHardwareInterfaces = new ArrayList(7);
        int i = 0;
        while (i < 7) {
            detectedHardwareInterfaces.add(new HardwarePorts());
            ++i;
        }
        this.hardwareInterfaces = new HardwareInterfaceSettings(this);
    }

    public String getName() {
        return TAB_NAME;
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    public String getId() {
        return TAB_ID;
    }

    public static ArrayList<HardwarePorts> getHardwarePorts() {
        ArrayList<HardwarePorts> newPorts = new ArrayList<HardwarePorts>(7);
        int i = 0;
        while (i < 7) {
            newPorts.add(new HardwarePorts());
            ++i;
        }
        try {
            String[] cmdarray = new String[]{TabDebugger.getGdbServerCommand(), "-getportlist"};
            final Process p = ProcessFactory.getFactory().exec(cmdarray);
            try {
                ArrayList<String> ports = Utils.timedCall(new Callable<ArrayList<String>>(){

                    @Override
                    public ArrayList<String> call() throws Exception {
                        String line;
                        ArrayList<String> ports = new ArrayList<String>();
                        InputStream stdout = p.getInputStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(stdout));
                        while ((line = reader.readLine()) != null) {
                            if (line.contains("-getportlist")) break;
                        }
                        while ((line = reader.readLine()) != null) {
                            ports.add(line);
                        }
                        p.waitFor();
                        return ports;
                    }
                }, 10L, TimeUnit.SECONDS);
                for (String line : ports) {
                    Scanner s = new Scanner(line).useDelimiter(":");
                    String inString = s.next().trim();
                    int hwIndex = inString.equals("USBMultilink") ? 0 : (inString.equals("CycloneSerial") ? 1 : (inString.equals("CycloneUSB") ? 2 : (inString.equals("CycloneEthernet") ? 3 : (inString.equals("TracelinkUSB") ? 4 : (inString.equals("TracelinkEthernet") ? 5 : (inString.equals("OpenSDA") ? 6 : -1))))));
                    inString = s.next().trim();
                    newPorts.get((int)hwIndex).ports.add(inString);
                    newPorts.get((int)hwIndex).comboStrings.add(String.valueOf(inString) + " - " + s.next().trim());
                    s.close();
                }
            }
            catch (TimeoutException timeoutException) {
                p.destroy();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return newPorts;
    }

    private void refreshDeviceList() {
        ArrayList<String> deviceList = Utils.getAvailableDevices();
        this.deviceTreeContent = new DeviceTree();
        this.deviceTreeContent.initializeRootNode(deviceList);
    }

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        this.setControl((Control)sc);
        Composite comp = new Composite((Composite)sc, 0);
        sc.setContent((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        this.createRegistrationControl(comp);
        this.createPeInterfaceControl(comp);
        this.createAdditionalControl(comp);
        this.createPowerControl(comp);
        this.createSpeedControl(comp);
        this.createServerControl(comp);
        this.createClientControl(comp);
        this.advancedDialog = new AdvancedProgrammingDialog(this, this.getShell());
        this.fUpdateThreadlistOnSuspend = new Button(comp, 32);
        GridData gd = new GridData();
        this.fUpdateThreadlistOnSuspend.setLayoutData((Object)gd);
        this.fUpdateThreadlistOnSuspend.setText(Messages.getString("DebuggerTab.update_thread_list_on_suspend_Text"));
        this.fUpdateThreadlistOnSuspend.setToolTipText(Messages.getString("DebuggerTab.update_thread_list_on_suspend_ToolTipText"));
        this.fUpdateThreadlistOnSuspend.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createRegistrationControl(Composite parent) {
        IEclipsePreferences pref = ConfigurationScope.INSTANCE.getNode("com.pemicro.debug.gdbjtag.pne");
        boolean hide = pref.getBoolean("userRegistered", false);
        if (!hide) {
            this.setWarningMessage(Messages.getString("DebuggerTab.RegistrationTabWarning"));
        }
        this.registrationGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        GridData data = new GridData(768);
        data.exclude = hide;
        this.registrationGroup.setText(Messages.getString("DebuggerTab.RegistrationGroup_Text"));
        this.registrationGroup.setLayout((Layout)layout);
        this.registrationGroup.setLayoutData((Object)data);
        Label label = new Label((Composite)this.registrationGroup, 16384);
        label.setImage(parent.getDisplay().getSystemImage(8));
        Composite nagGroup = new Composite((Composite)this.registrationGroup, 0);
        layout = new GridLayout(1, false);
        nagGroup.setLayout((Layout)layout);
        label = new Label(nagGroup, 16384);
        label.setText(Messages.getString("DebuggerTab.RegistrationNagText"));
        Button registerButton = new Button(nagGroup, 8);
        registerButton.setText(Messages.getString("DebuggerTab.RegistrationButton"));
        registerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.openRegistrationDialog();
            }
        });
    }

    private void createPeInterfaceControl(Composite parent) {
        Group peInterfaceGroup = new Group(parent, 0);
        peInterfaceGroup.setText(Messages.getString("DebuggerTab.PeInterfaceGroup_Text"));
        GridLayout layout = new GridLayout(6, false);
        peInterfaceGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        peInterfaceGroup.setLayoutData((Object)data);
        Label label = new Label((Composite)peInterfaceGroup, 0);
        label.setText(Messages.getString("DebuggerTab.PeInterfaceInterfaceLabel"));
        String[] peInterfaces = new String[]{"USB Multilink, USB Multilink FX, Embedded OSBDM/OSJTAG - USB Port", "Cyclone - Serial Port", "Cyclone - USB Port", "Cyclone - Ethernet Port", "TraceLink - USB Port", "TraceLink - Ethernet Port", "OpenSDA Embedded Debug - USB Port"};
        data = new GridData();
        data.horizontalSpan = 3;
        data.widthHint = 385;
        this.interfaceCombo = new Combo((Composite)peInterfaceGroup, 12);
        this.interfaceCombo.setItems(peInterfaces);
        this.interfaceCombo.setLayoutData((Object)data);
        this.interfaceCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int hwIndex = ((Combo)e.getSource()).getSelectionIndex();
                TabDebugger.this.hardwareInterfaces.hardwareContextSwitch(hwIndex);
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        data = new GridData();
        data.horizontalSpan = 2;
        Link link = new Link((Composite)peInterfaceGroup, 0);
        link.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String osName = System.getProperty("os.name");
                String url = event.text;
                Object[] browsers = new String[]{"google-chrome", "firefox", "opera", "epiphany", "konqueror", "conkeror", "midori", "kazehakase", "mozilla"};
                try {
                    Class<?> d = Class.forName("java.awt.Desktop");
                    d.getDeclaredMethod("browse", URI.class).invoke(d.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), URI.create(url));
                }
                catch (Exception exception) {
                    try {
                        if (osName.startsWith("Mac OS")) {
                            Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, url);
                        } else if (osName.startsWith("Windows")) {
                            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                        } else {
                            String browser = null;
                            Object[] objectArray = browsers;
                            int n = browsers.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String b = objectArray[n2];
                                if (browser == null && Runtime.getRuntime().exec(new String[]{"which", b}).getInputStream().read() != -1) {
                                    Runtime.getRuntime().exec(new String[]{browser = b, url});
                                }
                                ++n2;
                            }
                            if (browser == null) {
                                throw new Exception(Arrays.toString(browsers));
                            }
                        }
                    }
                    catch (Exception e) {
                        MessageBox mb = new MessageBox(new Shell());
                        mb.setMessage("Error attempting to launch web browser\n" + e.toString());
                        mb.open();
                    }
                }
            }
        });
        link.setText(Messages.getString("DebuggerTab.PeInterfaceCompatibleHardwareLink"));
        link.setLayoutData((Object)data);
        Label portLabel = new Label((Composite)peInterfaceGroup, 0);
        portLabel.setText(Messages.getString("DebuggerTab.PeInterfacePortLabel"));
        detectedHardwareInterfaces = TabDebugger.getHardwarePorts();
        data = new GridData();
        data.horizontalSpan = 3;
        data.widthHint = 385;
        this.probeAddressCombo = new Combo((Composite)peInterfaceGroup, 12);
        this.probeAddressCombo.setLayoutData((Object)data);
        this.probeAddressCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.refreshDeviceList();
        data = new GridData();
        data.horizontalSpan = 2;
        this.refreshButton = new Button((Composite)peInterfaceGroup, 0);
        this.refreshButton.setLayoutData((Object)data);
        this.refreshButton.setText(Messages.getString("DebuggerTab.PeInterfaceRefreshButton"));
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                detectedHardwareInterfaces = TabDebugger.getHardwarePorts();
                int old_combo_index = TabDebugger.this.probeAddressCombo.getSelectionIndex();
                old_combo_index = old_combo_index == -1 ? 0 : old_combo_index;
                int currentHardwareTypeIndex = TabDebugger.this.interfaceCombo.getSelectionIndex();
                TabDebugger.this.probeAddressCombo.setItems(detectedHardwareInterfaces.get(currentHardwareTypeIndex).getComboString());
                TabDebugger.this.probeAddressCombo.select(old_combo_index);
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.selectDeviceButton = new Button((Composite)peInterfaceGroup, 0);
        this.selectDeviceButton.setText(Messages.getString("DebuggerTab.PeInterfaceSelectDeviceButton"));
        this.selectDeviceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] buttonLabels = new String[]{"Select", "Cancel"};
                MessageDialog dialog = new MessageDialog(TabDebugger.this.getShell(), Messages.getString("DebuggerTab.PeInterfaceSelectDeviceTitle"), null, Messages.getString("DebuggerTab.PeInterfaceSelectDeviceDescription"), 0, buttonLabels, 0){
                    private FilteredTree deviceFilteredTree;
                    private Button selectButton;
                    private TreeViewer treeViewer;

                    protected Control createDialogArea(Composite parent) {
                        super.createDialogArea(parent);
                        PatternFilter filter = new PatternFilter(){

                            protected boolean isLeafMatch(Viewer viewer, Object element) {
                                boolean temp = super.isLeafMatch(viewer, element);
                                if (DeviceTree.isParent(element)) {
                                    temp = false;
                                }
                                return temp;
                            }
                        };
                        filter.setIncludeLeadingWildcard(true);
                        this.deviceFilteredTree = new FilteredTree(parent, 2820, filter, true);
                        this.treeViewer = this.deviceFilteredTree.getViewer();
                        this.treeViewer.setContentProvider((IContentProvider)TabDebugger.this.deviceTreeContent);
                        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
                        this.treeViewer.setInput((Object)((TabDebugger)(this).TabDebugger.this).deviceTreeContent.rootNode);
                        this.treeViewer.getTree().setItemCount(15);
                        this.treeViewer.getTree().addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                Object selection = treeViewer.getTree().getSelection()[0].getData();
                                if (DeviceTree.isParent(selection)) {
                                    selectButton.setEnabled(false);
                                } else {
                                    selectButton.setEnabled(true);
                                }
                            }
                        });
                        return TabDebugger.this.getControl();
                    }

                    protected void createButtonsForButtonBar(Composite parent) {
                        super.createButtonsForButtonBar(parent);
                        this.selectButton = this.getButton(0);
                        this.selectButton.setEnabled(false);
                    }

                    protected void buttonPressed(int id) {
                        switch (id) {
                            case 0: {
                                TreeViewer viewer = this.deviceFilteredTree.getViewer();
                                DeviceTree.Node selection = (DeviceTree.Node)viewer.getTree().getSelection()[0].getData();
                                TabDebugger.this.updateVFDLabels(DeviceTree.constructVendorFamilyDevice(selection));
                                TabDebugger.this.updateCoreCombo(DeviceTree.constructVendorFamilyDevice(selection));
                                TabDebugger.this.updateServerPortTip();
                                TabDebugger.this.updateLaunchConfigurationDialog();
                                TabDebugger.this.scheduleUpdateJob();
                                TabDebugger.this.advancedOptions.setEnabled(true);
                                super.buttonPressed(id);
                                break;
                            }
                            case 1: {
                                super.buttonPressed(id);
                            }
                        }
                    }
                };
                dialog.open();
            }
        });
        this.deviceWarning = new ControlDecoration((Control)this.selectDeviceButton, 131200);
        this.deviceWarning.setDescriptionText(Messages.getString("DebuggerTab.PeInterfaceDeviceWarning"));
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.deviceWarning.setImage(fieldDecoration.getImage());
        this.deviceWarning.show();
        Composite deviceSelect = new Composite((Composite)peInterfaceGroup, 0);
        data = new GridData(4, 1, false, false, 4, 1);
        data.horizontalIndent = 3;
        layout = new GridLayout(3, true);
        deviceSelect.setLayoutData((Object)data);
        deviceSelect.setLayout((Layout)layout);
        int style = 16384;
        GridData labelData = new GridData(4, 1, true, false);
        data = new GridData(4, 1, true, false);
        layout = new GridLayout(2, false);
        Composite info = new Composite(deviceSelect, 0);
        info.setLayout((Layout)layout);
        info.setLayoutData((Object)data);
        label = new Label(info, style);
        label.setText(Messages.getString("DebuggerTab.PeInterfaceVendorLabel"));
        this.vendorLabel = new Label(info, style);
        this.vendorLabel.setLayoutData((Object)labelData);
        info = new Composite(deviceSelect, 0);
        info.setLayout((Layout)layout);
        info.setLayoutData((Object)data);
        label = new Label(info, style);
        label.setText(Messages.getString("DebuggerTab.PeInterfaceFamilyLabel"));
        this.familyLabel = new Label(info, style);
        this.familyLabel.setLayoutData((Object)labelData);
        info = new Composite(deviceSelect, 0);
        info.setLayout((Layout)layout);
        info.setLayoutData((Object)data);
        label = new Label(info, style);
        label.setText(Messages.getString("DebuggerTab.PeInterfaceDeviceLabel"));
        this.deviceLabel = new Label(info, style);
        this.deviceLabel.setLayoutData((Object)labelData);
        this.deviceLabel.setFont(FontDescriptor.createFrom((Font)label.getFont()).setStyle(1).createFont((Device)label.getDisplay()));
        label = new Label((Composite)peInterfaceGroup, 0);
        this.selectCoreLabel = new Label((Composite)peInterfaceGroup, 16384);
        this.selectCoreLabel.setText(Messages.getString("DebuggerTab.PeInterfaceCoreLabel"));
        this.selectCoreCombo = new Combo((Composite)peInterfaceGroup, 0x100000C);
        data = new GridData();
        data.horizontalSpan = 5;
        data.widthHint = 100;
        this.selectCoreCombo.setLayoutData((Object)data);
        this.selectCoreCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.specifyIPButton = new Button((Composite)peInterfaceGroup, 32);
        this.specifyIPButton.setText(Messages.getString("DebuggerTab.PeInterfaceSpecifyIPButton"));
        this.specifyIPButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
                if (TabDebugger.this.specifyIPButton.getSelection()) {
                    TabDebugger.this.specifyIPText.setEnabled(true);
                    TabDebugger.this.probeAddressCombo.setEnabled(false);
                } else {
                    TabDebugger.this.specifyIPText.setEnabled(false);
                    TabDebugger.this.probeAddressCombo.setEnabled(true);
                }
            }
        });
        data = new GridData();
        data.widthHint = 100;
        this.specifyIPText = new Text((Composite)peInterfaceGroup, 2048);
        this.specifyIPText.setLayoutData((Object)data);
        this.specifyIPText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.specifyIPText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || e.character == '.' || e.character == '-' || e.character == '_' || Character.isISOControl(e.character);
            }
        });
        this.specifyNetworkCardButton = new Button((Composite)peInterfaceGroup, 32);
        this.specifyNetworkCardButton.setText(Messages.getString("DebuggerTab.PeInterfaceSpecifyNetworkCardButton"));
        this.specifyNetworkCardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
                if (TabDebugger.this.specifyNetworkCardButton.getSelection()) {
                    TabDebugger.this.specifyNetworkCardText.setEnabled(true);
                } else {
                    TabDebugger.this.specifyNetworkCardText.setEnabled(false);
                }
            }
        });
        data = new GridData();
        data.widthHint = 100;
        this.specifyNetworkCardText = new Text((Composite)peInterfaceGroup, 2048);
        this.specifyNetworkCardText.setLayoutData((Object)data);
        this.specifyNetworkCardText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.specifyNetworkCardText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || e.character == '.' || e.character == '-' || e.character == '_' || Character.isISOControl(e.character);
            }
        });
    }

    private ArrayList<String> getCoresFromDDFFile(String input_text) {
        String[] delimited = input_text.split("_");
        String vendor = delimited[0];
        String family = delimited[1];
        String device = delimited[2];
        ArrayList<String> coreNames = new ArrayList<String>();
        String ddfFileFullPath = String.valueOf(Utils.getGdbServerPath()) + "gdi" + File.separator + "P&E" + File.separator + "supportFiles_ARM" + File.separator + vendor + File.separator + family + File.separator + device + ".DDF";
        Wini addIni = new Wini();
        Config config = new Config();
        addIni.setConfig(config);
        try {
            addIni.load(new File(ddfFileFullPath));
        }
        catch (InvalidFileFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean hasCoreInfo = true;
        try {
            this.numCores = Integer.parseInt(addIni.get((Object)"runControl", (Object)"numcores"));
        }
        catch (NumberFormatException e) {
            this.numCores = 1;
            hasCoreInfo = false;
            e.printStackTrace();
        }
        if (hasCoreInfo) {
            int i = 1;
            while (i < this.numCores + 1) {
                coreNames.add(addIni.get((Object)"runControl", (Object)String.format("core%dname", i)));
                ++i;
            }
        }
        return coreNames;
    }

    private void updateServerPortTip() {
        if (this.numCores > 1) {
            this.serverPortTip.show();
        } else {
            this.serverPortTip.hide();
        }
    }

    private void updateCoreCombo(String input_text) {
        if (input_text.isEmpty()) {
            this.selectCoreCombo.select(-1);
            return;
        }
        ArrayList<String> cores = this.getCoresFromDDFFile(input_text);
        if (!cores.isEmpty()) {
            this.selectCoreCombo.setItems(cores.toArray(new String[cores.size()]));
            this.selectCoreCombo.select(0);
        } else {
            this.selectCoreCombo.select(-1);
        }
    }

    private void createAdditionalControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("DebuggerTab.AdditionalGroup_Text"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        gd = new GridData();
        this.eraseButton = new Button((Composite)group, 32);
        this.eraseButton.setText(Messages.getString("DebuggerTab.AdditionalEraseButton"));
        this.eraseButton.setLayoutData((Object)gd);
        this.eraseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
            }
        });
        this.swdButton = new Button((Composite)group, 32);
        this.swdButton.setText(Messages.getString("DebuggerTab.AdditionalSwdButton"));
        gd = new GridData();
        this.swdButton.setLayoutData((Object)gd);
        this.swdButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
            }
        });
        this.advancedOptions = new Button((Composite)group, 8);
        this.advancedOptions.setText(Messages.getString("DebuggerTab.AdvancedOptionsButton"));
        this.advancedOptions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.advancedDialog.open();
                TabDebugger.this.scheduleUpdateJob();
            }
        });
    }

    private void createPowerControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("DebuggerTab.PowerGroup_Text"));
        GridLayout layout = new GridLayout(5, false);
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        this.providePowerButton = new Button((Composite)group, 32);
        this.providePowerButton.setText(Messages.getString("DebuggerTab.PowerProvidePowerButton"));
        this.providePowerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
            }
        });
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.getString("DebuggerTab.PowerRegulatorLabel"));
        gd = new GridData();
        gd.horizontalIndent = 5;
        label = new Label((Composite)group, 0);
        label.setText(Messages.getString("DebuggerTab.PowerDownDelayLabel"));
        label.setLayoutData((Object)gd);
        gd = new GridData();
        gd.widthHint = 30;
        this.powerDownDelayText = new Text((Composite)group, 133120);
        this.powerDownDelayText.setTextLimit(4);
        this.powerDownDelayText.setLayoutData((Object)gd);
        this.powerDownDelayText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                char[] chrArray;
                char[] cArray = chrArray = event.text.toCharArray();
                int n = chrArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char chr = cArray[n2];
                    if ((chr < '0' || chr > '9') && event.character != '\b' && event.character != '\u007f') {
                        event.doit = false;
                    }
                    ++n2;
                }
            }
        });
        this.powerDownDelayText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        label = new Label((Composite)group, 0);
        label.setText(Messages.getString("DebuggerTab.PowerMsLabel"));
        this.powerOffButton = new Button((Composite)group, 32);
        this.powerOffButton.setText(Messages.getString("DebuggerTab.PowerOffButton"));
        this.powerOffButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
            }
        });
        this.voltageCombo = new Combo((Composite)group, 8);
        this.voltageCombo.setItems(new String[]{"2V", "3V", "5V"});
        this.voltageCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        gd = new GridData();
        gd.horizontalIndent = 5;
        label = new Label((Composite)group, 0);
        label.setText(Messages.getString("DebuggerTab.PowerUpDelayLabel"));
        label.setLayoutData((Object)gd);
        gd = new GridData();
        gd.widthHint = 30;
        this.powerUpDelayText = new Text((Composite)group, 133120);
        this.powerUpDelayText.setTextLimit(4);
        this.powerUpDelayText.setLayoutData((Object)gd);
        this.powerUpDelayText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.powerUpDelayText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                char[] chrArray;
                char[] cArray = chrArray = event.text.toCharArray();
                int n = chrArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char chr = cArray[n2];
                    if ((chr < '0' || chr > '9') && event.character != '\b' && event.character != '\u007f') {
                        event.doit = false;
                    }
                    ++n2;
                }
            }
        });
        label = new Label((Composite)group, 0);
        label.setText(Messages.getString("DebuggerTab.PowerMsLabel"));
    }

    private void createSpeedControl(Composite parent) {
        Group targetCommunicationSpeedGroup = new Group(parent, 0);
        targetCommunicationSpeedGroup.setText(Messages.getString("DebuggerTab.SpeedGroup_Text"));
        GridLayout layout = new GridLayout(4, false);
        targetCommunicationSpeedGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        targetCommunicationSpeedGroup.setLayoutData((Object)data);
        Label label = new Label((Composite)targetCommunicationSpeedGroup, 0);
        label.setText(Messages.getString("DebuggerTab.SpeedFreqLabel"));
        label.setToolTipText(Messages.getString("DebuggerTab.SpeedFreqToolTip"));
        data = new GridData();
        data.horizontalAlignment = 16384;
        data.widthHint = 100;
        data.horizontalSpan = 3;
        this.freqText = new Text((Composite)targetCommunicationSpeedGroup, 2048);
        this.freqText.setLayoutData((Object)data);
        this.freqText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                char[] chrArray;
                char[] cArray = chrArray = event.text.toCharArray();
                int n = chrArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char chr = cArray[n2];
                    if ((chr < '0' || chr > '9') && event.character != '\b' && event.character != '\u007f') {
                        event.doit = false;
                    }
                    ++n2;
                }
            }
        });
        this.freqText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.delayAfterResetButton = new Button((Composite)targetCommunicationSpeedGroup, 32);
        data = new GridData();
        data.horizontalSpan = 2;
        this.delayAfterResetButton.setLayoutData((Object)data);
        this.delayAfterResetButton.setText(Messages.getString("DebuggerTab.SpeedResetDelayButton"));
        this.delayAfterResetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
                TabDebugger.this.delayAfterResetText.setEnabled(TabDebugger.this.delayAfterResetButton.getSelection());
            }
        });
        data = new GridData();
        data.widthHint = 80;
        this.delayAfterResetText = new Text((Composite)targetCommunicationSpeedGroup, 133120);
        this.delayAfterResetText.setLayoutData((Object)data);
        this.delayAfterResetText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                char[] chrArray;
                char[] cArray = chrArray = event.text.toCharArray();
                int n = chrArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char chr = cArray[n2];
                    if ((chr < '0' || chr > '9') && event.character != '\b' && event.character != '\u007f') {
                        event.doit = false;
                    }
                    ++n2;
                }
            }
        });
        this.delayAfterResetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        label = new Label((Composite)targetCommunicationSpeedGroup, 0);
        label.setText(Messages.getString("DebuggerTab.PowerMsLabel"));
    }

    private void createServerControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("DebuggerTab.ServerGroupText"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        this.localLaunchButton = new Button(comp, 32);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.localLaunchButton.setLayoutData((Object)gd);
        this.localLaunchButton.setText(Messages.getString("DebuggerTab.ServerLocalLaunchButton"));
        this.localLaunchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
                TabDebugger.this.externalServerChanged();
            }
        });
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.GdbmiPort"));
        this.gdbmiPortText = new Text(comp, 2048);
        gd = new GridData();
        gd.widthHint = 50;
        gd.horizontalIndent = 5;
        this.gdbmiPortText.setLayoutData((Object)gd);
        this.gdbmiPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.gdbmiPortText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
            }
        });
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.ServerIpAddress"));
        this.serverIpText = new Text(comp, 2048);
        gd = new GridData();
        gd.widthHint = 90;
        this.serverIpText.setLayoutData((Object)gd);
        this.serverIpText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.serverIpText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.matches("(?:\\w|[-*.])*");
            }
        });
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.ServerPortLabel"));
        this.serverPortTip = new ControlDecoration((Control)label, 131200);
        this.serverPortTip.setDescriptionText(Messages.getString("DebuggerTab.ServerPortTip"));
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
        this.serverPortTip.setImage(fieldDecoration.getImage());
        this.serverPortText = new Text(comp, 2048);
        gd = new GridData();
        gd.widthHint = 50;
        gd.horizontalIndent = 5;
        this.serverPortText.setLayoutData((Object)gd);
        this.serverPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.serverPortText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = Character.isDigit(e.character) || Character.isISOControl(e.character);
            }
        });
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.ServerParametersLabel"));
        gd = new GridData();
        gd.widthHint = 342;
        gd.horizontalSpan = 3;
        this.peGdbServerOptions = new Text(comp, 2048);
        this.peGdbServerOptions.setLayoutData((Object)gd);
        this.peGdbServerOptions.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
    }

    private void createClientControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.getString("DebuggerTab.ClientGroupText"));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        Composite comp = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        comp.setLayout((Layout)layout);
        gd = new GridData(768);
        comp.setLayoutData((Object)gd);
        Label label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.ClientExecutableLabel"));
        label.setToolTipText(Messages.getString("DebuggerTab.ClientExecutableToolTip"));
        this.clientWarning = new ControlDecoration((Control)label, 131200);
        this.clientWarning.setDescriptionText(Messages.getString("DebuggerTab.ClientExecutableWarning"));
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        this.clientWarning.setImage(fieldDecoration.getImage());
        this.clientWarning.show();
        Composite local = new Composite(comp, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        local.setLayout((Layout)layout);
        gd = new GridData(768);
        local.setLayoutData((Object)gd);
        this.clientExecutableText = new Text(local, 2052);
        gd = new GridData(768);
        this.clientExecutableText.setLayoutData((Object)gd);
        this.clientExecutableText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (((Text)e.getSource()).getText().isEmpty()) {
                    TabDebugger.this.clientWarning.show();
                } else {
                    TabDebugger.this.clientWarning.hide();
                }
                TabDebugger.this.didGdbClientExecutableChange = true;
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        this.didGdbClientExecutableChange = false;
        Button browseButton = new Button(local, 0);
        browseButton.setText(Messages.getString("DebuggerTab.ClientBrowseButton"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.browseButtonSelected(Messages.getString("DebuggerTab.gdbCommandBrowse_Title"), TabDebugger.this.clientExecutableText);
            }
        });
        Button variableButton = new Button(local, 0);
        variableButton.setText(Messages.getString("DebuggerTab.ClientVariablesButton"));
        variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabDebugger.this.variablesButtonSelected(TabDebugger.this.clientExecutableText);
            }
        });
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.ClientOtherOptionsLabel"));
        label.setToolTipText(Messages.getString("DebuggerTab.ClientOtherOptionsToolTip"));
        gd = new GridData();
        label.setLayoutData((Object)gd);
        this.clientOtherOptionsText = new Text(comp, 2052);
        gd = new GridData(768);
        this.clientOtherOptionsText.setLayoutData((Object)gd);
        this.clientOtherOptionsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.scheduleUpdateJob();
            }
        });
        label = new Label(comp, 0);
        label.setText(Messages.getString("DebuggerTab.ClientOtherCommandsLabel"));
        label.setToolTipText(Messages.getString("DebuggerTab.ClientOtherCommandsToolTip"));
        gd = new GridData();
        gd.verticalAlignment = 128;
        label.setLayoutData((Object)gd);
        this.clientOtherCommandsText = new Text(comp, 2626);
        gd = new GridData(4, 4, true, true);
        gd.heightHint = 60;
        this.clientOtherCommandsText.setLayoutData((Object)gd);
        this.clientOtherCommandsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TabDebugger.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void openRegistrationDialog() {
        InputDialog dialog = new InputDialog(this.getShell(), Messages.getString("RegistrationWindow.Title"), Messages.getString("RegistrationWindow.Prompt"), null, new IInputValidator(){

            public String isValid(String newText) {
                if (newText.matches("([\\w\\.\\-_]+)?\\w+@[\\w-_]+(\\.\\w+){1,}")) {
                    return null;
                }
                return Messages.getString("RegistrationWindow.Validation");
            }
        }){
            int httpStatus;
            boolean userPref;
            {
                this.userPref = true;
            }

            protected Control createDialogArea(Composite parent) {
                Composite dialogArea = (Composite)super.createDialogArea(parent);
                Text email = this.getText();
                email.setSize(500, email.getSize().y);
                Button checkbox = new Button(dialogArea, 32);
                checkbox.setSelection(true);
                checkbox.setText(Messages.getString("RegistrationWindow.CheckBox"));
                checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        userPref = ((Button)e.item).getSelection();
                    }
                });
                return dialogArea;
            }

            protected Control createButtonBar(Composite parent) {
                super.createButtonBar(parent);
                Button submit = this.getOkButton();
                submit.setText(Messages.getString("RegistrationWindow.Submit"));
                submit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        HttpURLConnection connection = null;
                        try {
                            String base = Messages.getString("RegistrationWindow.SubmitUrl");
                            String email = URLEncoder.encode(this.getValue(), "UTF-8");
                            String userBool = userPref ? "1" : "0";
                            String parameters = String.format(Messages.getString("RegistrationWindow.FormatString"), email, userBool, userBool);
                            URL url = new URL(String.valueOf(base) + parameters);
                            HttpURLConnection.setFollowRedirects(false);
                            connection = (HttpURLConnection)url.openConnection();
                            connection.setRequestMethod("GET");
                            connection.connect();
                            IEclipsePreferences prefStore = ConfigurationScope.INSTANCE.getNode("com.pemicro.debug.gdbjtag.pne");
                            String verifyLocation = Messages.getString("RegistrationWindow.VerifyUrl");
                            String redirect = connection.getHeaderField("Location");
                            httpStatus = connection.getResponseCode();
                            if (httpStatus == 302 && redirect.contentEquals(verifyLocation)) {
                                prefStore.putBoolean("userRegistered", true);
                                TabDebugger.this.setWarningMessage(null);
                                TabDebugger.this.registrationGroup.setVisible(false);
                                ((GridData)((TabDebugger)(this).TabDebugger.this).registrationGroup.getLayoutData()).exclude = true;
                                TabDebugger.this.registrationGroup.pack();
                                TabDebugger.this.updateLaunchConfigurationDialog();
                            } else {
                                MessageDialog errorMessage = new MessageDialog(this.getShell(), Messages.getString("RegistrationWindow.ErrorTitle"), null, Messages.getString("RegistrationWindow.ErrorMessage"), 1, new String[]{"OK"}, 0){

                                    public int open() {
                                        this.message = String.valueOf(this.message) + "\n\nHTTP Status: " + httpStatus;
                                        return super.open();
                                    }
                                };
                                errorMessage.open();
                                prefStore.putBoolean("userRegistered", false);
                            }
                            prefStore.flush();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                });
                return parent;
            }
        };
        dialog.open();
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.insert(dialog.getVariableExpression());
        }
    }

    private void externalServerChanged() {
        boolean selected = this.localLaunchButton.getSelection();
        this.peGdbServerOptions.setEnabled(selected);
        this.interfaceCombo.setEnabled(selected);
        this.probeAddressCombo.setEnabled(selected);
        this.specifyIPButton.setEnabled(selected);
        this.specifyIPText.setEnabled(selected);
        this.specifyNetworkCardButton.setEnabled(selected);
        this.specifyNetworkCardText.setEnabled(selected);
        this.eraseButton.setEnabled(selected);
        this.swdButton.setEnabled(selected);
        this.providePowerButton.setEnabled(selected);
        this.powerOffButton.setEnabled(selected);
        this.voltageCombo.setEnabled(selected);
        this.powerDownDelayText.setEnabled(selected);
        this.powerUpDelayText.setEnabled(selected);
        this.freqText.setEnabled(selected);
        this.delayAfterResetButton.setEnabled(selected);
        this.delayAfterResetText.setEnabled(selected);
        this.refreshButton.setEnabled(selected);
        this.serverIpText.setEnabled(!selected);
        if (selected) {
            this.hardwareInterfaces.updatePanel();
            this.serverIpText.setText("localhost");
        }
    }

    private void updateVFDLabels(String vendorFamilyDevice) {
        this.deviceString = vendorFamilyDevice;
        if (vendorFamilyDevice.isEmpty()) {
            this.deviceWarning.show();
            this.vendorLabel.setText("");
            this.familyLabel.setText("");
            this.deviceLabel.setText("");
        } else {
            this.deviceWarning.hide();
            String[] delimited = vendorFamilyDevice.split("_");
            this.vendorLabel.setText(delimited[0]);
            this.familyLabel.setText(delimited[1]);
            this.deviceLabel.setText(delimited[2]);
        }
    }

    private String getDeviceName() {
        String deviceName;
        if (this.vendorLabel.getText().isEmpty()) {
            deviceName = "";
        } else {
            deviceName = this.vendorLabel.getText();
            deviceName = deviceName.concat("_").concat(this.familyLabel.getText());
            deviceName = deviceName.concat("_").concat(this.deviceLabel.getText());
        }
        return deviceName;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.hardwareInterfaces.setDefaults(configuration);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.HARDWARE_INTERFACE", 0);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME", "");
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.USE_EXTERNAL_SERVER", true);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost");
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.gdbmiPortNumber", 6224);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.serverPortNumber", 7224);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.GDB_OPTIONS", "");
        String gdb_client_path = Utils.getDefaultGdbClientPath();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", gdb_client_path);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.gdbClientOtherOptions", "");
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.gdbClientOtherCommands", "set mem inaccessible-by-default off\nset tcp auto-retry on\nset tcp connect-timeout 240\nset remotetimeout 60\n");
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU ARM PEMicro Interface");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        AdvancedProgrammingDialog.setDefaults(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.hardwareInterfaces.initializeFrom(configuration);
        try {
            ILaunchConfigurationWorkingCopy tmp;
            int hwIndex = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.PE.HARDWARE_INTERFACE", 0);
            this.interfaceCombo.select(hwIndex);
            String input_text = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME", "");
            if (input_text.contains("Freescale")) {
                input_text = input_text.replace("Freescale", "NXP");
                tmp = configuration.getWorkingCopy();
                tmp.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME", input_text);
                tmp.doSave();
            }
            if (!input_text.contains("_") && !input_text.isEmpty()) {
                input_text = "NXP_" + PemicroUtil.getPemicroFamily(input_text) + "_" + input_text;
                tmp = configuration.getWorkingCopy();
                tmp.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME", input_text);
                tmp.doSave();
            }
            this.advancedOptions.setEnabled(!input_text.isEmpty());
            this.updateCoreCombo(input_text);
            this.updateServerPortTip();
            int coreNumber = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.selectedCoreNumber", 1);
            this.selectCoreCombo.select(coreNumber - 1);
            this.updateVFDLabels(input_text);
            this.localLaunchButton.setSelection(configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.PE.USE_EXTERNAL_SERVER", true));
            this.serverIpText.setText(configuration.getAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", "localhost"));
            int port = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.gdbmiPortNumber", 6224);
            this.gdbmiPortText.setText(Integer.toString(port));
            port = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.serverPortNumber", 7224);
            this.serverPortText.setText(Integer.toString(port));
            this.peGdbServerOptions.setText(configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.PE.GDB_OPTIONS", ""));
            this.externalServerChanged();
            String gdb_client_path = Utils.getDefaultGdbClientPath();
            String gdbCommandAttr = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", gdb_client_path);
            this.clientExecutableText.setText(gdbCommandAttr);
            this.didGdbClientExecutableChange = false;
            if (gdbCommandAttr.isEmpty()) {
                this.clientWarning.show();
            } else {
                this.clientWarning.hide();
            }
            this.clientOtherOptionsText.setText(configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.gdbClientOtherOptions", ""));
            this.clientOtherCommandsText.setText(configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.gdbClientOtherCommands", "set mem inaccessible-by-default off\nset tcp auto-retry on\nset tcp connect-timeout 240\nset remotetimeout 60\n"));
            this.fUpdateThreadlistOnSuspend.setSelection(configuration.getAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false));
            this.advancedDialog.initializeFrom(configuration);
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.hardwareInterfaces.performApply(configuration);
        int index = this.interfaceCombo.getSelectionIndex();
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.HARDWARE_INTERFACE", index);
        String input_text = HardwareInterfaceSettings.getAttributeHeader(index);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.LAST_ATTRIBUTE_HEADER", input_text);
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME", this.getDeviceName());
        int corenumber = this.selectCoreCombo.getSelectionIndex() + 1;
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.selectedCoreNumber", corenumber);
        boolean inputBool = this.localLaunchButton.getSelection();
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.USE_EXTERNAL_SERVER", inputBool);
        input_text = this.serverIpText.getText().trim();
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.ipAddress", input_text);
        assert (corenumber >= 1) : "Core number is invalid.";
        int port = 6224;
        input_text = this.gdbmiPortText.getText().trim();
        if (!input_text.isEmpty()) {
            port = Integer.valueOf(input_text);
        }
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.gdbmiPortNumber", port);
        port = 7224;
        input_text = this.serverPortText.getText().trim();
        if (!input_text.isEmpty()) {
            port = Integer.valueOf(input_text);
        }
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.serverPortNumber", port);
        input_text = this.peGdbServerOptions.getText().trim();
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.PE.GDB_OPTIONS", input_text);
        String clientExecutable = this.clientExecutableText.getText().trim();
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", clientExecutable);
        if (this.didGdbClientExecutableChange) {
            SharedStorage.putGdbClientExecutable(clientExecutable);
            this.didGdbClientExecutableChange = false;
            SharedStorage.update();
        }
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.gdbClientOtherOptions", this.clientOtherOptionsText.getText().trim());
        configuration.setAttribute("com.pemicro.debug.gdbjtag.pne.gdbClientOtherCommands", this.clientOtherCommandsText.getText().trim());
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", this.fUpdateThreadlistOnSuspend.getSelection());
        this.advancedDialog.performApply(configuration);
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.jtagDevice", "GNU ARM PEMicro Interface");
        configuration.setAttribute("org.eclipse.cdt.debug.gdbjtag.core.useRemoteTarget", true);
    }

    public static String getGdbServerCommand() {
        String executable = null;
        executable = String.valueOf(Utils.getGdbServerPath()) + "pegdbserver_console";
        if ((executable = executable.trim()).length() == 0) {
            return null;
        }
        return executable;
    }

    public static String getGdbServerCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = TabDebugger.getGdbServerCommandLineArray(configuration);
        return Utils.join(cmdLineArray, " ");
    }

    public static int getCorbaError() {
        return corbaError;
    }

    public static String[] getGdbServerCommandLineArray(ILaunchConfiguration configuration) {
        String executable;
        Wini configIni;
        String configPath;
        String sectionString;
        List<String> lst;
        block35: {
            lst = new ArrayList<String>();
            sectionString = "STARTUP";
            configPath = Activator.getDefault().getStateLocation().toString();
            configPath = String.valueOf(configPath) + '/' + "config.ini";
            File configFile = new File(configPath);
            if (configFile.exists()) {
                configFile.delete();
            }
            configFile.createNewFile();
            configIni = new Wini(configFile);
            Config config = new Config();
            config.setStrictOperator(true);
            config.setEscape(false);
            configIni.setConfig(config);
            executable = TabDebugger.getGdbServerCommand();
            if (executable != null && executable.length() != 0) break block35;
            return null;
        }
        try {
            lst.add(executable);
            String param = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.PE.GDB_OPTIONS", "");
            lst.addAll(Arrays.asList(param.split(" ")));
            param = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.PE.DEVICE_NAME", "");
            lst.add("-device=" + param);
            lst.add("-startserver");
            lst.add("-singlesession");
            boolean attach = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.attachToRunning", false);
            if (attach) {
                configIni.put("CWDBG", "Connect", (Object)"1");
            }
            int port = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.serverPortNumber", 7224);
            lst.add("-serverport=" + Integer.toString(port));
            port = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.gdbmiPortNumber", 6224);
            lst.add("-gdbmiport=" + Integer.toString(port));
            int hwIndex = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.PE.HARDWARE_INTERFACE", 0);
            switch (hwIndex) {
                case 0: {
                    param = "USBMULTILINK";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    param = "CYCLONE";
                    break;
                }
                case 4: 
                case 5: {
                    param = "TRACELINK";
                    break;
                }
                case 6: {
                    param = "OPENSDA";
                }
            }
            lst.add("-interface=" + param);
            String attributeHeader = HardwareInterfaceSettings.getAttributeHeader(hwIndex);
            param = configuration.getAttribute(String.valueOf(attributeHeader) + "SHIFT_FREQ", "5000");
            lst.add("-speed=" + param);
            if (!configuration.getAttribute(String.valueOf(attributeHeader) + "STARTUP_USE_SWD", true)) {
                lst.add("-usejtag");
            }
            if (configuration.getAttribute(String.valueOf(attributeHeader) + "DO_RESET_DELAY", false)) {
                param = configuration.getAttribute(String.valueOf(attributeHeader) + "RESET_DELAY", "0");
                lst.add("-resetdelay=" + param);
            }
            boolean portSet = false;
            if (hwIndex == 3 || hwIndex == 5) {
                if (configuration.getAttribute(String.valueOf(attributeHeader) + "SPECIFY_IP", false)) {
                    param = configuration.getAttribute(String.valueOf(attributeHeader) + "CYCLONE_IP", "");
                    configIni.put(sectionString, "SPECIFY_IP", (Object)param);
                    configIni.put(sectionString, "SPECIFY_IP_ENABLED", (Object)"1");
                    lst.add("-port=" + param);
                    portSet = true;
                } else {
                    configIni.put(sectionString, "SPECIFY_IP_ENABLED", (Object)"0");
                }
                if (configuration.getAttribute(String.valueOf(attributeHeader) + "SPECIFY_NETWORK_CARD", false)) {
                    param = configuration.getAttribute(String.valueOf(attributeHeader) + "NETWORK_CARD_IP", "");
                    configIni.put(sectionString, "SPECIFY_NETWORKCARD", (Object)param);
                    configIni.put(sectionString, "SPECIFY_NETWORKCARD_ENABLED", (Object)"1");
                    lst.add("-port=" + param);
                    portSet = true;
                } else {
                    configIni.put(sectionString, "SPECIFY_NETWORKCARD_ENABLED", (Object)"0");
                }
            }
            if (!portSet) {
                param = configuration.getAttribute(String.valueOf(attributeHeader) + "INTERFACE_PORT_STRING", "");
                lst.add("-port=" + param);
            }
            if (configuration.getAttribute(String.valueOf(attributeHeader) + "POWER_OFF", false)) {
                lst.add("-CyclonePro_poweroffonexit=1");
            }
            if (configuration.getAttribute(String.valueOf(attributeHeader) + "PROVIDE_POWER", true)) {
                configIni.put(sectionString, "USE_CYCLONEPRO_RELAYS", (Object)"1");
                if (hwIndex == 1 || hwIndex == 2 || hwIndex == 3 || hwIndex == 4 || hwIndex == 5) {
                    param = configuration.getAttribute(String.valueOf(attributeHeader) + "POWER_DOWN_DELAY", "0");
                    configIni.put(sectionString, "CyclonePro_PowerDownDelay", (Object)param);
                    param = configuration.getAttribute(String.valueOf(attributeHeader) + "POWER_UP_DELAY", "0");
                    configIni.put(sectionString, "CyclonePro_PowerUpDelay", (Object)param);
                    int regVoltage = configuration.getAttribute(String.valueOf(attributeHeader) + "REGULATOR_VOLTAGE", 0);
                    switch (regVoltage) {
                        case 0: {
                            regVoltage = 0;
                            break;
                        }
                        case 1: {
                            regVoltage = 128;
                            break;
                        }
                        case 2: {
                            regVoltage = 255;
                        }
                    }
                    configIni.put(sectionString, "CyclonePro_currentvoltage", (Object)regVoltage);
                } else if (hwIndex == 0) {
                    param = configuration.getAttribute(String.valueOf(attributeHeader) + "POWER_DOWN_DELAY", "0");
                    configIni.put(sectionString, "Multilink_PowerDownDelay", (Object)param);
                    param = configuration.getAttribute(String.valueOf(attributeHeader) + "POWER_UP_DELAY", "0");
                    configIni.put(sectionString, "Multilink_PowerUpDelay", (Object)param);
                }
            } else {
                configIni.put(sectionString, "USE_CYCLONEPRO_RELAYS", (Object)"0");
            }
            if (configuration.getAttribute(String.valueOf(attributeHeader) + "ALWAYS_ERASE", false)) {
                configIni.put(sectionString, "FORCE_MASS_ERASE", (Object)"1");
            } else {
                configIni.put(sectionString, "FORCE_MASS_ERASE", (Object)"0");
            }
            lst = AdvancedProgrammingDialog.getGdbServerCommandLineArray(lst, configIni, configuration);
            String corbaIdentifier = Server.getCorbaIdentifier();
            if (corbaIdentifier.isEmpty()) {
                corbaError = 1;
            } else {
                corbaError = 0;
                configIni.put("GENERAL", "CORBA_IDENTIFIER0", (Object)corbaIdentifier.substring(0, 255));
                configIni.put("GENERAL", "CORBA_IDENTIFIER1", (Object)corbaIdentifier.substring(255));
            }
            configIni.store();
            lst.add("-configfile=" + configPath);
        }
        catch (CoreException e) {
            Activator.log(e);
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return lst.toArray(new String[0]);
    }

    public static String getGdbClientCommandNoBuild(ILaunchConfiguration configuration) {
        String executable = null;
        try {
            String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
            executable = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            executable = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(executable, false).trim();
        }
        catch (CoreException e) {
            Activator.log(e);
            return null;
        }
        return executable;
    }

    public static String getGdbClientCommand(ILaunchConfiguration configuration) {
        String executable = null;
        try {
            String defaultGdbCommand = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "defaultGdbCommand", "gdb", null);
            executable = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", defaultGdbCommand);
            executable = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(executable, false).trim();
            ICConfigurationDescription buildConfig = Utils.getBuildConfig(configuration);
            if (buildConfig != null) {
                executable = Utils.resolveAll(executable, buildConfig);
            }
        }
        catch (CoreException e) {
            Activator.log(e);
            return null;
        }
        return executable;
    }

    public static String getGdbClientCommandLine(ILaunchConfiguration configuration) {
        String[] cmdLineArray = TabDebugger.getGdbClientCommandLineArray(configuration);
        return Utils.join(cmdLineArray, " ");
    }

    public static String[] getGdbClientCommandLineArray(ILaunchConfiguration configuration) {
        ArrayList<String> lst = new ArrayList<String>();
        String executable = TabDebugger.getGdbClientCommand(configuration);
        if (executable == null || executable.length() == 0) {
            return null;
        }
        lst.add(executable);
        lst.add("--interpreter=mi2");
        lst.add("--nx");
        try {
            String other = configuration.getAttribute("com.pemicro.debug.gdbjtag.pne.gdbClientOtherOptions", "").trim();
            if (other.length() > 0) {
                lst.addAll(TabDebugger.splitOptions(other));
            }
        }
        catch (CoreException e) {
            Activator.log(e);
        }
        return lst.toArray(new String[0]);
    }

    private static List<String> splitOptions(String str) {
        ArrayList<String> lst = new ArrayList<String>();
        State state = State.None;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            switch (state) {
                case None: {
                    if (ch == '\"') {
                        sb.setLength(0);
                        state = State.InString;
                        break;
                    }
                    if (ch == ' ') break;
                    sb.setLength(0);
                    sb.append(ch);
                    state = State.InOption;
                    break;
                }
                case InOption: {
                    if (ch != ' ') {
                        sb.append(ch);
                        break;
                    }
                    lst.add(sb.toString());
                    state = State.None;
                    break;
                }
                case InString: {
                    if (ch != '\"') {
                        sb.append(ch);
                        break;
                    }
                    lst.add(sb.toString());
                    state = State.None;
                }
            }
            ++i;
        }
        if (state == State.InOption || state == State.InString) {
            lst.add(sb.toString());
        }
        return lst;
    }

    public static class HardwarePorts {
        public ArrayList<String> ports = new ArrayList();
        public ArrayList<String> comboStrings = new ArrayList();

        public String[] getComboString() {
            String[] comboStringArray = new String[this.comboStrings.size()];
            this.comboStrings.toArray(comboStringArray);
            return comboStringArray;
        }
    }

    private static enum State {
        None,
        InOption,
        InString;

    }
}

