/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license;

import com.nxp.s32ds.ext.rcp.license.IFeatureId;
import com.nxp.s32ds.ext.rcp.license.ILicenseModel;
import com.nxp.s32ds.ext.rcp.license.LicenseStatus;
import com.nxp.s32ds.ext.rcp.license.cll.LicenseException;
import java.util.Map;
import java.util.Set;

public class BrokenLicenseBackend
implements ILicenseModel {
    private final Exception exception;

    public BrokenLicenseBackend(Exception exception) {
        this.exception = exception;
    }

    @Override
    public LicenseStatus getStatus(IFeatureId licenseFeatureId) {
        return LicenseStatus.INITIALIZATION_ERROR;
    }

    @Override
    public int getEvaluationDays(IFeatureId licenseFeatureId) {
        return 0;
    }

    @Override
    public int getEvaluationWarningDays() {
        return 0;
    }

    @Override
    public String getModelDetails() {
        StringBuilder sb = new StringBuilder();
        BrokenLicenseBackend.reverseExceptionCouses(this.exception, sb);
        return "Faild to initialize license backend: " + sb.toString();
    }

    private static void reverseExceptionCouses(Throwable throwable, StringBuilder sb) {
        if (throwable.getCause() != null) {
            BrokenLicenseBackend.reverseExceptionCouses(throwable.getCause(), sb);
        }
        sb.append(throwable.getMessage());
        sb.append("\n");
        sb.append("\n");
        throwable.getCause();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement st = stackTraceElementArray[n2];
            sb.append(st.toString());
            sb.append("\n");
            ++n2;
        }
        sb.append("\n");
    }

    @Override
    public String getFeatureDetails(IFeatureId licenseFeatureId) {
        return "Faild to initialize license backend: " + this.exception;
    }

    @Override
    public void activate(String id, Map<String, String> params) throws LicenseException {
    }

    @Override
    public void init(Map<String, String> params, Set<String> products) throws LicenseException {
    }

    @Override
    public String getActivationId(IFeatureId licenseFeatureId) {
        return "";
    }

    @Override
    public IFeatureId createFeatureId(Map<String, String> params) {
        return new IFeatureId(){

            @Override
            public String getVersion() {
                return "n/a";
            }
        };
    }

    @Override
    public boolean isTestMode() {
        return false;
    }

    @Override
    public void refreshFeature(IFeatureId id) {
    }

    @Override
    public void returnFeature(String id, Map<String, String> params) throws LicenseException {
    }
}

