/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.license.ui;

import com.nxp.s32ds.ext.rcp.license.ILicenseService;
import com.nxp.s32ds.ext.rcp.license.LicenseActivator;
import com.nxp.s32ds.ext.rcp.license.LicenseFeature;
import com.nxp.s32ds.ext.rcp.license.LicenseStatus;
import com.nxp.s32ds.ext.rcp.license.Messages;
import com.nxp.s32ds.ext.rcp.license.cll.ui.CLLActivateWindow;
import com.nxp.s32ds.ext.rcp.license.ui.DetailsWindow;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;

public class LicenseWindow
extends TitleAreaDialog {
    private Table m_table;
    private Button btnActivate;
    private Button btnDetails;
    final ILicenseService lm = (ILicenseService)PlatformUI.getWorkbench().getService(ILicenseService.class);

    LicenseWindow() {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : null);
        this.setShellStyle(0x10CF0 | LicenseWindow.getDefaultOrientation());
        this.setHelpAvailable(false);
        this.setBlockOnOpen(true);
    }

    public static void show() {
        new UIJob("License Window Dialog"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                LicenseWindow window = new LicenseWindow();
                window.open();
                LicenseFeature[] licenseFeatureArray = window.lm.getFeatures();
                int n = licenseFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LicenseFeature f = licenseFeatureArray[n2];
                    if (f.isRequired() && !f.isEnabled()) {
                        PlatformUI.getWorkbench().close();
                    }
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private boolean hasActivatableLicenses() {
        LicenseFeature[] features;
        LicenseFeature[] licenseFeatureArray = features = this.lm.getFeatures();
        if (features.length != 0) {
            LicenseFeature feature = licenseFeatureArray[0];
            return feature.getStatus() != LicenseStatus.ACTIVATED;
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.hasActivatableLicenses()) {
            this.btnActivate = this.createButton(parent, 1029, Messages.getString("LicenseWindow_activate", null), false);
            this.btnActivate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LicenseWindow.this.activate();
                    LicenseWindow.this.updateTable();
                }
            });
        }
        this.btnDetails = this.createButton(parent, 1028, Messages.getString("LicenseWindow_details", null), false);
        this.btnDetails.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseWindow.this.details();
            }
        });
        Label l = new Label(parent, 0);
        l.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        this.updateTable();
        this.updateSelection(this.m_table.getSelectionIndex());
        Button closeButton = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LicenseWindow.this.close();
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        layout.verticalSpacing = 9;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.m_table = new Table(composite, 65540);
        this.m_table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = LicenseWindow.this.m_table.getSelectionIndex();
                LicenseWindow.this.updateSelection(index);
                LicenseWindow.this.m_table.showSelection();
            }
        });
        GridData data = new GridData(1808);
        data.heightHint = this.m_table.getItemHeight() * 3;
        data.horizontalSpan = 5;
        this.m_table.setLayoutData((Object)data);
        this.m_table.setLinesVisible(true);
        TableColumn column = new TableColumn(this.m_table, 16384);
        column.setText(Messages.getString("LicenseWindow_product", null));
        column.setWidth(260);
        column = new TableColumn(this.m_table, 16384);
        column.setText(Messages.getString("LicenseWindow_version", null));
        column.setWidth(80);
        column = new TableColumn(this.m_table, 16384);
        column.setText(Messages.getString("LicenseWindow_status", null));
        column.setWidth(160);
        ((GridData)this.m_table.getLayoutData()).horizontalSpan = 3;
        this.m_table.setHeaderVisible(true);
        this.setTitle(Messages.getString("LicenseWindow_fslLicense", null));
        this.setMessage(Messages.getString("LicenseWindow_viewLicense", null));
        Bundle bundle = Platform.getBundle((String)"com.nxp.s32ds.ext.rcp.license");
        try {
            URL url = new URL(bundle.getEntry("/"), "images/page.gif");
            ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
            this.setTitleImage(desc.createImage());
        }
        catch (MalformedURLException e) {
            LicenseActivator.log(4, e.getMessage(), e);
        }
        return composite;
    }

    private void updateTable() {
        LicenseFeature[] features;
        this.m_table.removeAll();
        LicenseFeature[] licenseFeatureArray = features = this.lm.getFeatures();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            LicenseFeature feature = licenseFeatureArray[n2];
            TableItem item = new TableItem(this.m_table, 0);
            item.setText(0, feature.getLabel());
            item.setText(1, feature.getVersion());
            item.setText(2, feature.getStatusText());
            ++n2;
        }
        if (this.m_table.getItemCount() > 0 && this.m_table.getSelectionCount() == 0) {
            this.m_table.select(0);
        }
        this.updateButtonFor(this.m_table.getSelectionIndex());
    }

    private void updateSelection(int index) {
        if (index == -1) {
            if (this.btnActivate != null) {
                this.btnActivate.setEnabled(false);
            }
        } else {
            this.updateButtonFor(index);
        }
    }

    private void updateButtonFor(int index) {
        LicenseFeature feature = this.lm.getFeatures()[index];
        if (this.btnActivate != null) {
            if (LicenseStatus.INITIALIZATION_ERROR.equals((Object)feature.getStatus())) {
                this.btnActivate.setEnabled(false);
            } else if (!feature.isEnabled()) {
                this.btnActivate.setText(Messages.getString("LicenseWindow_activate", null));
            } else {
                this.btnActivate.setText(Messages.getString("LicenseWindow_open", null));
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("LicenseWindow_prodLicenses", null));
    }

    private LicenseFeature getSelectedFeature() {
        int index = this.m_table.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        LicenseFeature[] features = this.lm.getFeatures();
        return features[index];
    }

    private void activate() {
        new CLLActivateWindow(this.getParentShell(), this.getSelectedFeature()).open();
        this.lm.resetCaches();
    }

    private void details() {
        new DetailsWindow(this.getShell(), this.getDetails()).open();
    }

    private String getDetails() {
        StringBuilder sb = new StringBuilder();
        LicenseFeature feature = this.getSelectedFeature();
        sb.append(feature.getLabel());
        sb.append("\n\n");
        if (LicenseStatus.EXPIRED.equals((Object)feature.getStatus())) {
            sb.append(feature.getHowToProlonge());
        }
        if (LicenseStatus.MISSED.equals((Object)feature.getStatus())) {
            sb.append(feature.getHowToActivate());
        }
        if (LicenseStatus.INITIALIZATION_ERROR.equals((Object)feature.getStatus())) {
            sb.append(feature.getLicenseModel().getModelDetails());
        }
        if (LicenseStatus.ACTIVATED.equals((Object)feature.getStatus()) || LicenseStatus.EVALUATION.equals((Object)feature.getStatus())) {
            sb.append("ActivationId: ");
            sb.append(feature.getActivationId());
            sb.append("\nEvaluation Days: ");
            sb.append(feature.getEvaluationDays());
            sb.append("\nFeature Version: ");
            sb.append(feature.getVersion());
            sb.append("\nFeature Status: ");
            sb.append((Object)feature.getStatus());
        }
        return sb.toString();
    }
}

