/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.exports;

import com.freescale.s32ds.cdt.core.EclipseUtils;
import com.freescale.s32ds.cross.core.ProjectSettings;
import com.freescale.s32ds.cross.core.lingvo.Lingvo;
import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.data.ConfigurationData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.nxp.s32ds.ext.rcp.jse.utils.FuncUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ProjectInfoExportSettings {
    private static final String EXQM = "Cannot get persistent Properties: ";
    private static final String EXPT = "Export Error";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String PI_FILENAME = "ProjectInfo.xml";
    private Boolean absolutePaths = true;
    private Boolean defaultPaths = false;
    private ICConfigurationDescription configuration;
    private final IProject project;
    private final Lingvo lingvo;

    public ProjectInfoExportSettings(IProject project, Lingvo lingvo) {
        this.project = project;
        this.lingvo = lingvo;
    }

    public Path getOutputFile() {
        return Paths.get(String.valueOf(this.project.getLocation().toString()) + File.separator + PI_FILENAME, new String[0]);
    }

    public IProject getProject() {
        return this.project;
    }

    public Boolean getAbsolutePaths() {
        return this.absolutePaths;
    }

    public void setAbsolutePaths(Boolean absolutePaths) {
        this.absolutePaths = absolutePaths;
    }

    public ICConfigurationDescription getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ICConfigurationDescription configuration) {
        this.configuration = configuration;
    }

    public String toString() {
        return "ProjectInfoExportSettings [absolutePaths=" + this.absolutePaths + " defaultPaths=" + this.defaultPaths + " + , configurationName=" + this.getConfiguration().getName() + "]";
    }

    public String getPIDeviceID() {
        try {
            String piDeviceName;
            Map prop = this.project.getPersistentProperties();
            String chip = S32DSWizardPiPlugin.getFromHWModel(HWModel::getProcessors, p -> p.getId().equals(ProjectInfoExportSettings.getWizardPref("processor", this.project))).findFirst().map(ConfigurationData::getId).orElse(null);
            if (chip == null) {
                chip = ProjectInfoExportSettings.getProjectData("register_chip", this.project);
            }
            if (chip == null || chip.isEmpty()) {
                chip = EclipseUtils.readExternalSetting((String)"register_chip", (IProject)this.project);
            }
            if (chip == null) {
                chip = (String)prop.get(new QualifiedName("register_chip", "chip"));
            }
            return (piDeviceName = this.lingvo.mapToLingvo(chip, "pi.Device")) != null ? piDeviceName : chip;
        }
        catch (CoreException e) {
            S32DSWizardPiPlugin.log(e);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            shell.getDisplay().syncExec(() -> {
                boolean bl = MessageDialog.open((int)1, (Shell)shell, (String)EXPT, (String)EXQM, (int)0);
            });
            return UNKNOWN;
        }
    }

    public String getPICoreSet() {
        try {
            String arch = S32DSWizardPiPlugin.getFromHWModel(HWModel::getCoreTypes, ck -> ck.getId().equals(ProjectInfoExportSettings.getWizardPref("coreType", this.project))).findFirst().map(CoreNatureData::getCoreKindId).orElse(null);
            Map prop = this.project.getPersistentProperties();
            if (arch == null) {
                arch = ProjectInfoExportSettings.getProjectData("register_architecture", this.project);
            }
            if (arch == null) {
                arch = EclipseUtils.readExternalSetting((String)"register_architecture", (IProject)this.project);
            }
            if (arch == null) {
                arch = (String)prop.get(new QualifiedName("register_architecture", "architecture"));
            }
            if (arch != null) {
                String res = this.lingvo.mapToLingvo(arch, "pi.CoreSet");
                return res != null ? res : arch;
            }
            return arch;
        }
        catch (CoreException e) {
            S32DSWizardPiPlugin.log(e);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            shell.getDisplay().syncExec(() -> {
                boolean bl = MessageDialog.open((int)1, (Shell)shell, (String)EXPT, (String)EXQM, (int)0);
            });
            return UNKNOWN;
        }
    }

    private static String getProjectData(String tag, IProject p) throws CoreException {
        ICProjectDescription cd = CoreModel.getDefault().getProjectDescription(p);
        ICStorageElement storage = cd.getStorage("org.eclipse.embsys", false);
        return storage == null ? null : storage.getAttribute(tag);
    }

    public static String getWizardPref(String key, IProject p) {
        return Stream.of("com.freescale.s32ds.cross.wizard", "com.freescale.s32ds.cross.core").map(q -> new ProjectSettings(p, q).load(key)).filter(FuncUtils.not(String::isEmpty)).findAny().orElse(null);
    }

    public IFile getOutputIFile() {
        return this.project.getFile(PI_FILENAME);
    }

    public Boolean getDefaultPaths() {
        return this.defaultPaths;
    }

    public void setDefaultPaths(Boolean defaultPaths) {
        this.defaultPaths = defaultPaths;
    }
}

