/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.pi.imports.iar;

import com.freescale.s32ds.cross.wizard.pi.S32DSWizardPiPlugin;
import com.freescale.s32ds.cross.wizard.pi.imports.IOptionProcessor;
import com.freescale.s32ds.cross.wizard.pi.imports.OptionDelta;
import com.freescale.s32ds.cross.wizard.pi.imports.PIReader;
import com.freescale.s32ds.cross.wizard.pi.toolchains.ToolchainMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;

public class IAROptionProcessor
implements IOptionProcessor,
ToolchainMetadata {
    private final Map<String, Pattern> patterns = new HashMap<String, Pattern>();

    public IAROptionProcessor() {
        this.patterns.put("iar.arm.toolchain.assembler.option.cpu.v5.4.0", Pattern.compile("--cpu (.*)"));
        this.patterns.put("iar.arm.toolchain.assembler.option.fpu.v5.4.0", Pattern.compile("--fpu (.*)"));
        this.patterns.put("iar.arm.toolchain.assembler.option.caseSensitiveSymbols.v5.4.0", Pattern.compile("-s(\\+|-)"));
        this.patterns.put("iar.arm.toolchain.assembler.option.debugInfo.v5.4.0", Pattern.compile("-r"));
        this.patterns.put("iar.arm.toolchain.compiler.option.incPaths.v5.4.0", Pattern.compile("-I ?\"([^\"]+)\"|-I ?([^ ]+)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.cpu.v5.4.0", Pattern.compile("--cpu (.*)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.fpu.v5.4.0", Pattern.compile("--fpu (.*)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.debugInfo.v5.4.0", Pattern.compile("--debug"));
        this.patterns.put("iar.arm.toolchain.compiler.option.dlibConfig.v5.4.0", Pattern.compile("--dlib_config (.*)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.endian.v5.4.0", Pattern.compile("--endian (.*)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.defines.v5.4.0", Pattern.compile("(^|\\s)-D([^ ]+)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.language.v6.1.0", Pattern.compile("---AUTO"));
        this.patterns.put("iar.arm.toolchain.compiler.option.cpuMode.v5.4.0", Pattern.compile("--cpu_mode arm|--cpu_mode thumb"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optLevel.v5.4.0", Pattern.compile("-On|-Ol|-Om|-Ohz|-Oh|-Ohs"));
        this.patterns.put("iar.arm.toolchain.compiler.option.languageConformance.v6.1.0", Pattern.compile("-e|--strict"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optCSE.v5.4.0", Pattern.compile("--no_cse"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optUnroll.v5.4.0", Pattern.compile("--no_unroll"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optInline.v5.4.0", Pattern.compile("--no_inline"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optCodeMotion.v5.4.0", Pattern.compile("--no_code_motion"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optAliasAnalysis.v5.4.0", Pattern.compile("--no_tbaa"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optStaticClustering.v5.4.0", Pattern.compile("--no_clustering"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optScheduling.v5.4.0", Pattern.compile("--no_scheduling"));
        this.patterns.put("iar.arm.toolchain.compiler.option.suppress.v5.4.0", Pattern.compile("--diag_suppress (.*)"));
        this.patterns.put("iar.arm.toolchain.linker.option.icfFile.v5.4.0", Pattern.compile("--config \"(.*)\""));
        this.patterns.put("iar.arm.toolchain.linker.option.wrapDiagnostics", Pattern.compile("--no_wrap_diagnostics"));
        this.patterns.put("iar.arm.toolchain.linker.option.programEntry.v5.4.0", Pattern.compile("--entry (.*)"));
        this.patterns.put("iar.arm.toolchain.linker.option.mapFile.v5.4.0", Pattern.compile("--map \"(.*)\""));
        this.patterns.put("iar.arm.toolchain.assembler.option.cpu.v8.0.0", Pattern.compile("--cpu (.*)"));
        this.patterns.put("iar.arm.toolchain.assembler.option.fpu.v8.0.0", Pattern.compile("--fpu (.*)"));
        this.patterns.put("iar.arm.toolchain.assembler.option.caseSensitiveSymbols.v8.0.0", Pattern.compile("-s(\\+|-)"));
        this.patterns.put("iar.arm.toolchain.assembler.option.debugInfo.v8.0.0", Pattern.compile("-r"));
        this.patterns.put("iar.arm.toolchain.compiler.option.incPaths.v8.0.0", Pattern.compile("-I ?\"([^\"]+)\"|-I ?([^ ]+)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.cpu.v8.0.0", Pattern.compile("--cpu (.*)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.fpu.v8.0.0", Pattern.compile("--fpu (.*)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.debugInfo.v8.0.0", Pattern.compile("--debug"));
        this.patterns.put("iar.arm.toolchain.compiler.option.dlibConfig.v8.0.0", Pattern.compile("--dlib_config (.*)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.endian.v8.0.0", Pattern.compile("--endian (.*)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.defines.v8.0.0", Pattern.compile("(^|\\s)-D([^ ]+)"));
        this.patterns.put("iar.arm.toolchain.compiler.option.language.v8.0.0", Pattern.compile("---AUTO|--c++"));
        this.patterns.put("iar.arm.toolchain.compiler.option.cpuMode.v8.0.0", Pattern.compile("--cpu_mode arm|--cpu_mode thumb"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optLevel.v8.0.0", Pattern.compile("-On|-Ol|-Om|-Ohz|-Oh|-Ohs"));
        this.patterns.put("iar.arm.toolchain.compiler.option.languageConformance.v8.0.0", Pattern.compile("-e|--strict"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optCSE.v8.0.0", Pattern.compile("--no_cse"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optUnroll.v8.0.0", Pattern.compile("--no_unroll"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optInline.v8.0.0", Pattern.compile("--no_inline"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optCodeMotion.v8.0.0", Pattern.compile("--no_code_motion"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optAliasAnalysis.v8.0.0", Pattern.compile("--no_tbaa"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optStaticClustering.v8.0.0", Pattern.compile("--no_clustering"));
        this.patterns.put("iar.arm.toolchain.compiler.option.optScheduling.v8.0.0", Pattern.compile("--no_scheduling"));
        this.patterns.put("iar.arm.toolchain.compiler.option.suppress.v8.0.0", Pattern.compile("--diag_suppress (.*)"));
        this.patterns.put("iar.arm.toolchain.linker.option.icfFile.v8.0.0", Pattern.compile("--config \"(.*)\""));
        this.patterns.put("iar.arm.toolchain.linker.option.wrapDiagnostics.v8.0.0", Pattern.compile("--no_wrap_diagnostics"));
        this.patterns.put("iar.arm.toolchain.linker.option.programEntry.v8.0.0", Pattern.compile("--entry (.*)"));
        this.patterns.put("iar.arm.toolchain.linker.option.mapFileSlave.v8.0.0", Pattern.compile("--map \"(.*)\""));
    }

    @Override
    public List<OptionDelta> prepareChanges(IConfiguration cfg, PIReader piReader) {
        ArrayList<OptionDelta> result = new ArrayList<OptionDelta>();
        Arrays.stream(cfg.getToolChain().getTools()).forEach(tool -> Arrays.stream(tool.getOptions()).forEach(option -> result.addAll(this.processToolOption(cfg, (ITool)tool, (IOption)option, piReader))));
        try {
            this.createTCOptions(cfg, result);
        }
        catch (BuildException e) {
            S32DSWizardPiPlugin.log(e, e.getMessage());
        }
        return result;
    }

    private void setTcCpu(IConfiguration cfg, List<OptionDelta> result, String tcOptId, String ccOptId, String asmOptId) throws BuildException {
        Object val;
        Object object = val = this.getValue(result, ccOptId) == null ? this.getValue(result, asmOptId) : this.getValue(result, ccOptId);
        if (val != null) {
            IOption option = cfg.getToolChain().getOptionBySuperClassId(tcOptId);
            String value = option.getEnumeratedId((String)val);
            result.add(new OptionDelta(cfg, (IHoldsOptions)cfg.getToolChain(), option, value));
        }
    }

    private void setTc7Fpu(IConfiguration cfg, List<OptionDelta> result, String tcOptId, String ccOptId, String asmOptId) throws BuildException {
        Object val;
        Object object = val = this.getValue(result, ccOptId) == null ? this.getValue(result, asmOptId) : this.getValue(result, ccOptId);
        if (val != null) {
            IOption option = cfg.getToolChain().getOptionBySuperClassId(tcOptId);
            String[] stringArray = option.getApplicableValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                String eId = option.getEnumeratedId(name);
                String cmd = option.getEnumCommand(eId);
                if (cmd.equals(val)) {
                    result.add(new OptionDelta(cfg, (IHoldsOptions)cfg.getToolChain(), option, eId));
                }
                ++n2;
            }
        }
    }

    private void setTc8Fpu(IConfiguration cfg, List<OptionDelta> result, String tcOptId, String ccOptId, String asmOptId) throws BuildException {
        Object val;
        Object object = val = this.getValue(result, ccOptId) == null ? this.getValue(result, asmOptId) : this.getValue(result, ccOptId);
        if (val != null) {
            IOption option = cfg.getToolChain().getOptionBySuperClassId(tcOptId);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("None", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kNoFpu.v8.0.0");
            map.put("VFPv1", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFPv1.v8.0.0");
            map.put("VFPv2", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFPv2.v8.0.0");
            map.put("VFPv3", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFPv3.v8.0.0");
            map.put("VFPv4_sp", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFPv4sp.v8.0.0");
            map.put("VFPv4", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFPv4.v8.0.0");
            map.put("VFPv5_sp", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFPv5sp.v8.0.0");
            map.put("VFPv5_dp", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFPv5d16.v8.0.0");
            map.put("VFP9-S", "iar.arm.toolchain.option.OGFpuProcessor::descriptor.TaChipInfo::PossibleFPUs::kVFP9S.v8.0.0");
            String value = (String)map.get((String)val);
            result.add(new OptionDelta(cfg, (IHoldsOptions)cfg.getToolChain(), option, value));
        }
    }

    private void createTCOptions(IConfiguration cfg, List<OptionDelta> result) throws BuildException {
        this.setTcCpu(cfg, result, "iar.arm.toolchain.option.cpuCore.v5.4.0", "iar.arm.toolchain.compiler.option.cpu.v5.4.0", "iar.arm.toolchain.assembler.option.cpu.v5.4.0");
        this.setTcCpu(cfg, result, "iar.arm.toolchain.option.OGProcessor::descriptor.v8.0.0", "iar.arm.toolchain.compiler.option.cpu.v8.0.0", "iar.arm.toolchain.assembler.option.cpu.v8.0.0");
        this.setTc7Fpu(cfg, result, "iar.arm.toolchain.option.fpu.v5.4.0", "iar.arm.toolchain.compiler.option.fpu.v5.4.0", "iar.arm.toolchain.assembler.option.fpu.v5.4.0");
        this.setTc8Fpu(cfg, result, "iar.arm.toolchain.option.OGFpuProcessor::descriptor.v8.0.0", "iar.arm.toolchain.compiler.option.fpu.v8.0.0", "iar.arm.toolchain.assembler.option.fpu.v8.0.0");
        IOption useNeonOption = cfg.getToolChain().getOptionBySuperClassId("iar.arm.toolchain.option.OGFpuProcessor::useNEON.v8.0.0");
        if (useNeonOption != null) {
            result.add(new OptionDelta(cfg, (IHoldsOptions)cfg.getToolChain(), useNeonOption, (Boolean)useNeonOption.getDefaultValue() == false));
            result.add(new OptionDelta(cfg, (IHoldsOptions)cfg.getToolChain(), useNeonOption, (Boolean)useNeonOption.getDefaultValue()));
        }
    }

    private Object getValue(List<OptionDelta> result, String optionId) {
        for (OptionDelta d : result) {
            if (!d.getOption().getId().startsWith(optionId)) continue;
            return d.getValue();
        }
        return null;
    }

    private List<OptionDelta> processToolOption(IConfiguration cfg, ITool tool, IOption option, PIReader piReader) {
        if (!this.patterns.containsKey(option.getId())) {
            return Collections.emptyList();
        }
        for (String optionLine : this.getOpts(tool, piReader)) {
            Matcher matcher = this.patterns.get(option.getId()).matcher(optionLine);
            if (!matcher.find()) continue;
            try {
                ArrayList<String> values;
                int valueType = option.getValueType();
                if (valueType == 2) {
                    String value = matcher.group(1);
                    return Arrays.asList(new OptionDelta(cfg, (IHoldsOptions)tool, option, value));
                }
                if (valueType == 0) {
                    boolean value = !optionLine.equals(option.getCommandFalse());
                    return Arrays.asList(new OptionDelta(cfg, (IHoldsOptions)tool, option, value));
                }
                if (valueType == 5) {
                    values = new ArrayList<String>();
                    values.add(matcher.group(2));
                    while (matcher.find()) {
                        values.add(matcher.group(2));
                    }
                    return Arrays.asList(new OptionDelta(cfg, (IHoldsOptions)tool, option, values.toArray(new String[values.size()])));
                }
                if (valueType == 4 || valueType == 3) {
                    values = new ArrayList();
                    values.add(matcher.group(1));
                    while (matcher.find()) {
                        values.add(matcher.group(1));
                    }
                    return Arrays.asList(new OptionDelta(cfg, (IHoldsOptions)tool, option, values.toArray(new String[values.size()])));
                }
                if (valueType != 1) continue;
                String[] stringArray = option.getApplicableValues();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    String eId = option.getEnumeratedId(name);
                    String cmd = option.getEnumCommand(eId);
                    if (optionLine.equals(cmd)) {
                        return Arrays.asList(new OptionDelta(cfg, (IHoldsOptions)tool, option, eId));
                    }
                    ++n2;
                }
            }
            catch (BuildException e) {
                S32DSWizardPiPlugin.log(e, e.getMessage());
            }
        }
        return Collections.emptyList();
    }

    private List<String> getOpts(ITool tool, PIReader piReader) {
        if (this.isCCompiler(tool)) {
            return piReader.getOptionsCC();
        }
        if (this.isAssembler(tool)) {
            return piReader.getOptionsASM();
        }
        if (this.isLinker(tool)) {
            return piReader.getOptionsLinker();
        }
        S32DSWizardPiPlugin.logWarning("Unknown tool: " + tool + " (" + tool.getId() + ")");
        return Collections.emptyList();
    }

    @Override
    public boolean isAssembler(ITool tool) {
        String toolId = tool.getId();
        return toolId.startsWith("iar.arm.toolchain.assembler.v5.4.0") || toolId.startsWith("iar.arm.toolchain.assembler.v8.0.0");
    }

    @Override
    public boolean isCCompiler(ITool tool) {
        String toolId = tool.getId();
        return toolId.startsWith("iar.arm.toolchain.compiler.v5.4.1") || toolId.startsWith("iar.arm.toolchain.compiler.v8.0.0");
    }

    @Override
    public boolean isLinker(ITool tool) {
        String toolId = tool.getId();
        return toolId.startsWith("iar.arm.toolchain.linker.v5.4.0") || toolId.startsWith("iar.arm.toolchain.linker.v8.0.0");
    }

    @Override
    public boolean isFits(IToolChain toolchain) {
        return toolchain.getId().startsWith("iar.arm.toolchain.v6.1.0") || toolchain.getId().startsWith("iar.arm.toolchain.v8.0.0");
    }
}

