/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.sdk.core;

import com.freescale.s32ds.cross.sdk.IExternalSDK;
import com.freescale.s32ds.cross.sdk.Messages;
import com.freescale.s32ds.cross.sdk.SDKSupportPlugin;
import com.freescale.s32ds.cross.sdk.internal.AbstractSDK;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SDKExportHandler {
    public void exportSDK(String path, IExternalSDK sdk, boolean isExportDescriptorOnly, IProgressMonitor pm) {
        pm.beginTask(String.format(Messages.SDKExportHandler_creating_archive_message, path), -1);
        try {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(path));){
                    String descriptorContent = AbstractSDK.getSDKsString(Arrays.asList(sdk));
                    ZipEntry descriptorEntry = new ZipEntry("sources.xml");
                    zip.putNextEntry(descriptorEntry);
                    zip.write(descriptorContent.getBytes());
                    zip.closeEntry();
                    if (!isExportDescriptorOnly) {
                        this.compressContent(zip, Paths.get(sdk.getEnv().getValue(), new String[0]), sdk.getEnv().getName(), path, pm);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                SDKSupportPlugin.log((IStatus)new Status(4, "com.freescale.s32ds.cross.sdk.support", Messages.AbstractSDK_exception_store, (Throwable)e));
                pm.done();
            }
        }
        finally {
            pm.done();
        }
    }

    private void compressContent(final ZipOutputStream zip, Path sdkPathIn, String envName, final String zipPath, final IProgressMonitor pm) throws IOException {
        String path = SDKSupportPlugin.performStringSubstitution(sdkPathIn.toString(), envName);
        final Path sdkPath = new File(path).toPath();
        Files.walkFileTree(sdkPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path f;
                if (pm != null) {
                    pm.worked(500);
                    pm.subTask(String.format(Messages.SDKExportHandler_processing_message, file.getFileName()));
                }
                if ((f = sdkPath.relativize(file)).toString().equals("sources.xml") || zipPath.equals(file.toFile().getPath())) {
                    return FileVisitResult.CONTINUE;
                }
                Throwable throwable = null;
                Object var5_6 = null;
                try (BufferedInputStream origin = new BufferedInputStream(new FileInputStream(file.toFile()), 2048);){
                    int count;
                    ZipEntry entry = new ZipEntry(f.toString());
                    zip.putNextEntry(entry);
                    byte[] data = new byte[2048];
                    while ((count = origin.read(data, 0, 2048)) != -1) {
                        zip.write(data, 0, count);
                    }
                    zip.closeEntry();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

