/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.ui.dndexplorer;

import com.freescale.s32ds.cdt.core.EclipseUtils;
import com.freescale.s32ds.ui.dndexplorer.ADnDExplorerContentProvider;
import com.freescale.s32ds.ui.dndexplorer.ADnDExplorerLabelProvider;
import com.freescale.s32ds.ui.dndexplorer.ADragSourceListener;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.cview.IncludeRefContainer;
import org.eclipse.cdt.internal.ui.cview.IncludeReferenceProxy;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class ADnDExplorer
extends ViewPart
implements ISelectionListener {
    private FilteredTree filteredTree;
    protected IProject project;
    private Map<IProject, TreeViewerState> viewerStates;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        ISelectionService service = this.getSite().getWorkbenchWindow().getSelectionService();
        service.addSelectionListener((ISelectionListener)this);
        this.viewerStates = new HashMap<IProject, TreeViewerState>();
    }

    public void createPartControl(Composite parent) {
        this.filteredTree = new FilteredTree(parent, 772, (PatternFilter)new SubstringPatternFilter(), true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getTreeViewer());
        this.setContentProvider(this.newContentProvider());
        this.setLabelProvider(this.newLabelProvider());
        this.setDragSourceListener(this.newDragSourceListener());
    }

    public void setFocus() {
        this.getTreeViewer().getControl().setFocus();
    }

    public void dispose() {
        ISelectionService service = this.getSite().getWorkbenchWindow().getSelectionService();
        service.removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public TreeViewer getTreeViewer() {
        return this.filteredTree.getViewer();
    }

    protected FilteredTree getFilteredTree() {
        return this.filteredTree;
    }

    protected abstract ADnDExplorerContentProvider newContentProvider();

    protected abstract ADnDExplorerLabelProvider newLabelProvider();

    protected abstract ADragSourceListener newDragSourceListener();

    protected void setContentProvider(ITreeContentProvider cp) {
        this.getTreeViewer().setContentProvider((IContentProvider)cp);
    }

    protected void setLabelProvider(ColumnLabelProvider lp) {
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)lp);
    }

    protected void setDragSourceListener(DragSourceListener dsl) {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this.getTreeViewer().addDragSupport(ops, transfers, dsl);
    }

    protected void addDoubleClickListener(IDoubleClickListener dcl) {
        this.getTreeViewer().addDoubleClickListener(dcl);
    }

    protected ITextEditor getTextEditor(ITranslationUnit tu) throws PartInitException {
        URI uri = URI.create(tu.getElementName());
        if (!new File(uri).exists()) {
            this.reportFileNotFound(new Path(uri.getPath()).toOSString());
            return null;
        }
        IFileStore fileStore = EFS.getLocalFileSystem().getStore(tu.getLocationURI());
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return (ITextEditor)IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
    }

    protected IEditorPart getActiveEditor() {
        IWorkbenchPage page = this.getSite().getWorkbenchWindow().getActivePage();
        return page.getActiveEditor();
    }

    protected IEditorInput getEditorInput() {
        IEditorPart editor = this.getActiveEditor();
        return editor != null ? editor.getEditorInput() : null;
    }

    protected IResource getEditorInputResource(IEditorInput input) {
        return input != null ? (IResource)input.getAdapter(IResource.class) : null;
    }

    protected abstract Object getData();

    protected void updateTree(IProject selectedProject) {
        this.storeViewerState();
        this.project = selectedProject;
        if (this.project != null) {
            this.getTreeViewer().setInput(this.getData());
            this.restoreViewerState();
        } else {
            this.getTreeViewer().setInput(null);
        }
    }

    protected void expandTree() {
        this.getTreeViewer().expandAll();
    }

    protected IProject getActiveProjectFromSelection(ISelection selection) {
        IProject selectedProject = this.getProjectFromSelection(selection);
        return selectedProject != null && this.isProjectValid(selectedProject) ? selectedProject : null;
    }

    private IProject getProjectFromSelection(ISelection selection) {
        Object element;
        if (selection instanceof ITextSelection) {
            IResource resource = this.getEditorInputResource(this.getEditorInput());
            return resource != null ? resource.getProject() : this.project;
        }
        if (selection instanceof ITreeSelection && (element = ((ITreeSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Object resource = adaptable.getAdapter(IResource.class);
            if (resource instanceof IResource) {
                return ((IResource)resource).getProject();
            }
            resource = adaptable.getAdapter(ICElement.class);
            if (resource instanceof ICElement) {
                ICProject cproject = ((ICElement)resource).getCProject();
                return cproject != null ? cproject.getProject() : this.project;
            }
            resource = adaptable.getAdapter(IWorkbenchAdapter.class);
            if (resource instanceof IncludeReferenceProxy) {
                ICProject cproject = ((IncludeReferenceProxy)resource).getIncludeRefContainer().getCProject();
                return cproject != null ? cproject.getProject() : this.project;
            }
            if (resource instanceof IncludeRefContainer) {
                ICProject cproject = ((IncludeRefContainer)resource).getCProject();
                return cproject != null ? cproject.getProject() : this.project;
            }
        }
        return this.project;
    }

    private boolean isProjectValid(IProject project) {
        boolean isValid = false;
        try {
            isValid = project.isAccessible() && !"RemoteSystemsTempFiles".equals(project.getName()) && (project.hasNature("org.eclipse.cdt.core.cnature") || project.hasNature("org.eclipse.cdt.core.ccnature"));
        }
        catch (CoreException coreException) {}
        return isValid;
    }

    private void reportFileNotFound(String fileName) {
        Shell shell = EclipseUtils.getShell();
        shell.getDisplay().syncExec(() -> MessageDialog.openError((Shell)shell, (String)"File not found", (String)String.format("File %s not found", fileName)));
    }

    private void storeViewerState() {
        if (this.project != null) {
            this.viewerStates.put(this.project, new TreeViewerState(this.getTreeViewer().getExpandedElements(), this.getTreeViewer().getSelection()));
        }
    }

    private void restoreViewerState() {
        TreeViewerState treeViewerState;
        if (this.project != null && (treeViewerState = this.viewerStates.get(this.project)) != null) {
            this.getTreeViewer().setExpandedElements(treeViewerState.getExpandedElements());
            this.getTreeViewer().setSelection(treeViewerState.getSelection());
        }
    }

    class SubstringPatternFilter
    extends PatternFilter {
        private String pattern = "";

        SubstringPatternFilter() {
        }

        public void setPattern(String patternString) {
            this.pattern = patternString;
            super.setPattern(patternString);
        }

        private String getPattern() {
            return this.pattern;
        }

        protected boolean wordMatches(String text) {
            if (text != null && text.toLowerCase().contains(this.getPattern().toLowerCase())) {
                return true;
            }
            return super.wordMatches(text);
        }
    }

    class TreeViewerState {
        private ISelection selection;
        private Object[] expandedElements;

        TreeViewerState(Object[] expandedElements, ISelection selection) {
            this.expandedElements = expandedElements;
            this.selection = selection;
        }

        Object[] getExpandedElements() {
            return this.expandedElements;
        }

        ISelection getSelection() {
            return this.selection;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.expandedElements);
            result = 31 * result + (this.selection == null ? 0 : this.selection.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TreeViewerState other = (TreeViewerState)obj;
            if (!Arrays.equals(this.expandedElements, other.expandedElements)) {
                return false;
            }
            return !(this.selection == null ? other.selection != null : !this.selection.equals(other.selection));
        }
    }
}

