/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.model.registry;

import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.ParameterType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ParameterRegistry {
    private final Map<String, ParameterType> parameterTypeMap = new HashMap<String, ParameterType>();
    private final Map<String, Parameter> parameterMap = new HashMap<String, Parameter>();

    public Map<String, ParameterType> getParameterTypeMap() {
        return Collections.unmodifiableMap(this.parameterTypeMap);
    }

    public Map<String, Parameter> getParameterMap() {
        return Collections.unmodifiableMap(this.parameterMap);
    }

    public ParameterType registerType(ParameterType parameterType) {
        String tag = parameterType.getTag();
        ParameterType p = this.parameterTypeMap.get(tag);
        if (p != null) {
            return p;
        }
        this.parameterTypeMap.put(tag, parameterType);
        return parameterType;
    }

    public ParameterType getParameterType(String tag) {
        return this.parameterTypeMap.get(tag);
    }

    public Collection<ParameterType> getParameterTypes() {
        return this.parameterTypeMap.values();
    }

    public Parameter register(Parameter parameter) {
        String id = parameter.getId();
        Parameter p = this.parameterMap.get(id);
        if (p != null) {
            return p;
        }
        this.parameterMap.put(id, parameter);
        return parameter;
    }

    public Parameter getParameter(String id) {
        return this.parameterMap.get(id);
    }

    public Collection<Parameter> getParameters() {
        return this.parameterMap.values();
    }
}

