/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.tools;

import com.freescale.s32ds.cross.core.tools.ExtensionLoader;
import com.freescale.s32ds.cross.core.tools.ExternalTool;
import com.freescale.s32ds.cross.core.tools.ExternalToolRunnerHelper;
import com.freescale.s32ds.cross.core.tools.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.managedbuilder.buildmodel.IBuildCommand;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;

public class Preprocessor
extends ExternalTool {
    public IStatus preprocessFiles(List<IFile> files, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            Map<IProject, List<IFile>> projectMap = Preprocessor.arrangeFilesByProject(files);
            monitor.beginTask("", files.size());
            for (List<IFile> filesInProject : projectMap.values()) {
                IProject project = filesInProject.get(0).getProject();
                monitor.subTask(Messages.getString("Preprocessor.message.Preprocessing_files_in_project", project.getName()));
                this.preprocessFilesForOneProject(filesInProject, monitor);
            }
        }
        finally {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public void preprocessFilesForOneProject(List<IFile> files, IProgressMonitor monitor) throws CoreException {
        IProject project = files.get(0).getProject();
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        if (buildInfo == null) {
            return;
        }
        IConfiguration configuration = buildInfo.getDefaultConfiguration();
        Map<String, String> environment = Preprocessor.calculateEnvironment(configuration);
        IPath pathToWorkingDirectory = configuration.getBuilder().getBuildLocation();
        try {
            ExternalToolRunnerHelper externalToolRunnerHelper = new ExternalToolRunnerHelper(project);
            externalToolRunnerHelper.greeting(Messages.getString("Preprocessor.message.Preprocessing_selected_files_of_configuration_in_project", new String[]{configuration.toString(), project.getName()}));
            for (IFile file : files) {
                if (monitor.isCanceled()) break;
                ITool compiler = buildInfo.getToolFromInputExtension(file.getFileExtension());
                if (compiler == null) {
                    return;
                }
                ITool preprocessor = Preprocessor.getPreprocessor(configuration, compiler);
                if (preprocessor == null) {
                    return;
                }
                String outputFileExtension = Preprocessor.getOutputFileExtension(preprocessor);
                IPath pathToInputFile = file.getLocation();
                IPath relativePathToInputFile = pathToInputFile.makeRelativeTo(pathToWorkingDirectory);
                File outputDirectory = new File(String.valueOf(pathToWorkingDirectory.toString()) + File.separator + file.getProjectRelativePath().removeLastSegments(1).toString());
                if (!outputDirectory.exists()) {
                    outputDirectory.mkdirs();
                }
                try {
                    String[] preprocessorFlags = preprocessor.getToolCommandFlags(pathToInputFile, null);
                    String[] compilerFlags = compiler.getToolCommandFlags(pathToInputFile, null);
                    preprocessorFlags = Preprocessor.concat(preprocessorFlags, compilerFlags);
                    String[] inputResources = new String[]{relativePathToInputFile.toOSString()};
                    IManagedCommandLineGenerator generator = preprocessor.getCommandLineGenerator();
                    IManagedCommandLineInfo cmdLineInfo = generator.generateCommandLineInfo(preprocessor, preprocessor.getToolCommand(), preprocessorFlags, preprocessor.getOutputFlag(), preprocessor.getOutputPrefix(), outputDirectory.toString(), inputResources, preprocessor.getCommandLinePattern());
                    String cmdLine = cmdLineInfo.getCommandLine();
                    String resolvedCommandLine = ManagedBuildManager.getBuildMacroProvider().resolveValue(cmdLine, "", " ", 1, (Object)new FileContextData(null, null, null, (IBuildObject)preprocessor));
                    IBuildCommand buildCommand = Preprocessor.createCommandFromString(resolvedCommandLine, pathToWorkingDirectory, environment);
                    String inputFileNameWithoutExtension = Preprocessor.getInputFileName(pathToInputFile);
                    if (inputFileNameWithoutExtension.length() < 3) {
                        inputFileNameWithoutExtension = String.valueOf(inputFileNameWithoutExtension) + "tmp";
                    }
                    File redirectionFile = File.createTempFile(inputFileNameWithoutExtension, "." + outputFileExtension, outputDirectory);
                    externalToolRunnerHelper.setLaunchParameters((ICommandLauncher)new CommandLauncher(), buildCommand.getCommand(), buildCommand.getArgs(), pathToWorkingDirectory, Preprocessor.mapToStringArray(environment));
                    externalToolRunnerHelper.prepareStreams(new FileOutputStream(redirectionFile));
                    int state = externalToolRunnerHelper.execute(monitor);
                    if (state != -1) {
                        externalToolRunnerHelper.refreshProject(configuration.getName());
                        this.openFileInEditor(redirectionFile);
                    }
                }
                catch (BuildException e) {
                    e.printStackTrace();
                }
                monitor.worked(1);
            }
            externalToolRunnerHelper.close();
            externalToolRunnerHelper.goodbye(Messages.getString("Preprocessor.message.Preprocessing"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static ITool getPreprocessor(IConfiguration configuration, ITool tool) {
        ITool[] tools;
        String id = ExtensionLoader.getInstance().getPreprocessor(tool);
        if (id != null && (tools = configuration.getToolsBySuperClassId(id)).length > 0) {
            return tools[0];
        }
        return null;
    }
}

