/*
 * Decompiled with CFR 0.152.
 */
package com.pemicro.forms.chip.widget;

import com.pemicro.forms.chip.ChipStyle;
import com.pemicro.forms.chip.data.ChipData;
import java.util.concurrent.Semaphore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;

public class ControlWindow {
    public static Semaphore controlSemaphore = new Semaphore(1, true);
    private final boolean PIN_NAME_CONTROLLABLE = false;
    private Canvas controlCanvas;
    private Label instructions;
    private Canvas infoCanvas;
    private Label pinNumLabel;
    private Combo pinNumCombo;
    private Label pinNameLabel;
    private Text pinNameText;
    private Canvas digitalControlCanvas;
    private Button pinValueHighButton;
    private Button pinValueLowButton;
    private Label dataTypeLabel;
    private Combo dataTypeCombo;
    private Button pinDirectionInButton;
    private Button pinDirectionOutButton;
    private Canvas analogControlCanvas;
    private Label analogMinValueLabel;
    private Scale analogValueScale;
    private Label analogMaxValueLabel;
    private Label analogCurrentValueLabel;
    private int pinID;
    private int pinNumber;
    private String pinName;
    private int dataType;
    private int digitalValue;
    private int direction;
    private int analogMinValue;
    private int analogMaxValue;
    private int analogCurrentValue;
    private int pinSelection = Integer.MAX_VALUE;

    public ControlWindow(Composite parent, ChipData chipData) {
        this.controlCanvas = new Canvas(parent, 0);
        this.controlCanvas.setVisible(true);
        this.controlCanvas.setBackgroundMode(1);
        this.controlCanvas.setBackground(ChipStyle.BACKGROUND_COLOR);
        this.infoCanvas = new Canvas((Composite)this.controlCanvas, 0);
        this.infoCanvas.setLocation(0, 0);
        this.pinNumLabel = new Label((Composite)this.infoCanvas, 64);
        this.pinNumLabel.setText("Pin");
        this.pinNumLabel.setForeground(ChipStyle.TEXT_COLOR);
        this.pinNumLabel.pack();
        this.pinNumLabel.setLocation(0, 0);
        if (chipData.getChipType() == 0) {
            this.pinNumLabel.setLocation(100, 0);
        }
        this.pinNumCombo = new Combo((Composite)this.infoCanvas, 8);
        this.pinNumCombo.setText("");
        this.pinNumCombo.setBackground(ChipStyle.CHIP_WINDOW_WHITE_COLOR);
        this.pinNumCombo.pack();
        this.pinNumCombo.setLocation(ChipStyle.getXOffset((Control)this.pinNumCombo, (Control)this.pinNumLabel, 5), this.pinNumLabel.getLocation().y);
        this.pinNumLabel.setLocation(this.pinNumLabel.getLocation().x, ChipStyle.centerY((Control)this.pinNumLabel, (Control)this.pinNumCombo));
        this.pinNameLabel = new Label((Composite)this.infoCanvas, 64);
        this.pinNameLabel.setText("Name:");
        this.pinNameLabel.setForeground(ChipStyle.TEXT_COLOR);
        this.pinNameLabel.pack();
        this.pinNameLabel.setLocation(this.pinNumCombo.getLocation().x + this.pinNumCombo.getSize().x + 5, this.pinNumCombo.getLocation().y);
        this.pinNameText = new Text((Composite)this.infoCanvas, 0);
        this.pinNameText.setText("PTA0");
        this.pinNameText.setBackground(ChipStyle.CHIP_WINDOW_WHITE_COLOR);
        this.pinNameText.setSize(50, 20);
        this.pinNameText.setLocation(this.pinNameLabel.getLocation().x + this.pinNameLabel.getSize().x + 5, this.pinNameLabel.getLocation().y);
        this.pinNameLabel.setSize(0, 0);
        this.pinNameText.setSize(0, 0);
        this.pinNameLabel.setVisible(false);
        this.pinNameText.setVisible(false);
        this.dataTypeLabel = new Label((Composite)this.infoCanvas, 64);
        this.dataTypeLabel.setText("Type");
        this.dataTypeLabel.setForeground(ChipStyle.TEXT_COLOR);
        this.dataTypeLabel.pack();
        this.dataTypeLabel.setLocation(ChipStyle.getXOffset((Control)this.dataTypeLabel, (Control)this.pinNumCombo, 5), this.pinNumLabel.getLocation().y);
        this.dataTypeLabel.setVisible(chipData.getChipType() == 1);
        this.dataTypeCombo = new Combo((Composite)this.infoCanvas, 8);
        this.dataTypeCombo.add("Digital I/O");
        this.dataTypeCombo.add("Analog I/O");
        this.dataTypeCombo.select(0);
        this.dataTypeCombo.setBackground(ChipStyle.CHIP_WINDOW_WHITE_COLOR);
        this.dataTypeCombo.pack();
        this.dataTypeCombo.setLocation(ChipStyle.getXOffset((Control)this.dataTypeCombo, (Control)this.dataTypeLabel, 5), 0);
        this.dataTypeCombo.setVisible(chipData.getChipType() == 1);
        this.infoCanvas.pack();
        GridLayout layout = new GridLayout(2, true);
        this.digitalControlCanvas = new Canvas((Composite)this.controlCanvas, 0);
        this.digitalControlCanvas.setLayout((Layout)layout);
        this.digitalControlCanvas.setVisible(this.dataTypeCombo.getText().toLowerCase().contains("digital"));
        this.digitalControlCanvas.setLocation(0, ChipStyle.getYOffset((Control)this.digitalControlCanvas, (Control)this.infoCanvas, 5));
        GridData data = new GridData(4, 4, true, true);
        this.pinValueHighButton = new Button((Composite)this.digitalControlCanvas, 0);
        this.pinValueHighButton.setText("1");
        this.pinValueHighButton.setLocation(0, 0);
        this.pinValueHighButton.setLayoutData((Object)data);
        data = new GridData(4, 4, true, true);
        this.pinValueLowButton = new Button((Composite)this.digitalControlCanvas, 0);
        this.pinValueLowButton.setText("0");
        this.pinValueLowButton.setLocation(ChipStyle.getXOffset((Control)this.pinValueLowButton, (Control)this.pinValueHighButton, 0), this.pinValueHighButton.getLocation().y);
        this.pinValueLowButton.setLayoutData((Object)data);
        data = new GridData(4, 4, true, true);
        this.pinDirectionInButton = new Button((Composite)this.digitalControlCanvas, 0);
        this.pinDirectionInButton.setText("In");
        this.pinDirectionInButton.setLocation(this.pinValueHighButton.getLocation().x, ChipStyle.getYOffset((Control)this.pinDirectionInButton, (Control)this.pinValueHighButton, 0));
        this.pinDirectionInButton.setLayoutData((Object)data);
        data = new GridData(4, 4, true, true);
        this.pinDirectionOutButton = new Button((Composite)this.digitalControlCanvas, 0);
        this.pinDirectionOutButton.setText("Out");
        this.pinDirectionOutButton.setLocation(ChipStyle.getXOffset((Control)this.pinDirectionOutButton, (Control)this.pinDirectionInButton, 0), this.pinDirectionInButton.getLocation().y);
        this.pinDirectionOutButton.setLayoutData((Object)data);
        this.digitalControlCanvas.pack();
        this.analogControlCanvas = new Canvas((Composite)this.controlCanvas, 0);
        this.analogControlCanvas.setVisible(this.dataTypeCombo.getText().toLowerCase().contains("analog"));
        this.analogControlCanvas.setSize(200, 100);
        this.analogControlCanvas.setLocation(0, ChipStyle.getYOffset((Control)this.analogControlCanvas, (Control)this.infoCanvas, 5));
        this.analogMinValueLabel = new Label((Composite)this.analogControlCanvas, 64);
        this.analogMinValueLabel.setText("0.00 V");
        this.analogMinValueLabel.pack();
        this.analogMinValueLabel.setForeground(ChipStyle.TEXT_COLOR);
        this.analogMinValueLabel.setLocation(0, 0);
        this.analogValueScale = new Scale((Composite)this.analogControlCanvas, 256);
        this.analogValueScale.setSize(100, 20);
        this.analogValueScale.setLocation(ChipStyle.getXOffset((Control)this.analogValueScale, (Control)this.analogMinValueLabel, 0), 0);
        this.analogValueScale.setMaximum(330);
        this.analogValueScale.setMinimum(0);
        this.analogValueScale.setIncrement(1);
        this.analogValueScale.setPageIncrement(33);
        this.analogMinValueLabel.setLocation(0, ChipStyle.centerY((Control)this.analogMinValueLabel, (Control)this.analogValueScale));
        this.analogMaxValueLabel = new Label((Composite)this.analogControlCanvas, 64);
        this.analogMaxValueLabel.setText("3.30 V");
        this.analogMaxValueLabel.pack();
        this.analogMaxValueLabel.setForeground(ChipStyle.TEXT_COLOR);
        this.analogMaxValueLabel.setLocation(ChipStyle.getXOffset((Control)this.analogMaxValueLabel, (Control)this.analogValueScale, 0), ChipStyle.centerY((Control)this.analogMaxValueLabel, (Control)this.analogValueScale));
        this.analogCurrentValueLabel = new Label((Composite)this.analogControlCanvas, 64);
        this.analogCurrentValueLabel.setText("0.00 V");
        this.analogCurrentValueLabel.pack();
        this.analogCurrentValueLabel.setForeground(ChipStyle.TEXT_COLOR);
        this.analogCurrentValueLabel.setLocation(ChipStyle.centerX((Control)this.analogCurrentValueLabel, (Control)this.analogValueScale), ChipStyle.getYOffset((Control)this.analogCurrentValueLabel, (Control)this.analogValueScale, 0));
        this.analogControlCanvas.pack();
        this.controlCanvas.pack();
        this.analogControlCanvas.setLocation(ChipStyle.centerX((Control)this.analogControlCanvas, (Control)this.controlCanvas), this.analogControlCanvas.getBounds().y);
        if (chipData.getChipType() == 1) {
            this.digitalControlCanvas.setLocation(ChipStyle.centerX((Control)this.digitalControlCanvas, (Control)this.controlCanvas), this.digitalControlCanvas.getBounds().y);
        } else {
            this.digitalControlCanvas.setLocation(ChipStyle.centerX((Control)this.digitalControlCanvas, (Control)this.controlCanvas), this.digitalControlCanvas.getBounds().y);
        }
        this.instructions = new Label((Composite)this.controlCanvas, 0);
        this.instructions.moveAbove((Control)this.controlCanvas);
        this.instructions.setText("Click a pin to modify");
        this.instructions.pack();
        this.instructions.setLocation(ChipStyle.centerX((Control)this.instructions, (Control)this.controlCanvas), 0);
        this.instructions.setForeground(ChipStyle.TEXT_COLOR);
        this.infoCanvas.setVisible(false);
        this.analogControlCanvas.setVisible(false);
        this.digitalControlCanvas.setVisible(false);
        this.instructions.setVisible(true);
    }

    public Label getAnalogCurrentValueLabel() {
        return this.analogCurrentValueLabel;
    }

    public void setAnalogCurrentValueLabel(Label analogCurrentValueLabel) {
        this.analogCurrentValueLabel = analogCurrentValueLabel;
    }

    public Scale getAnalogValueScale() {
        return this.analogValueScale;
    }

    public void setAnalogValueScale(Scale analogValueScale) {
        this.analogValueScale = analogValueScale;
    }

    public Button getPinValueHighButton() {
        return this.pinValueHighButton;
    }

    public void setPinValueHighButton(Button pinValueHighButton) {
        this.pinValueHighButton = pinValueHighButton;
    }

    public Button getPinValueLowButton() {
        return this.pinValueLowButton;
    }

    public void setPinValueLowButton(Button pinValueLowButton) {
        this.pinValueLowButton = pinValueLowButton;
    }

    public Button getPinDirectionInButton() {
        return this.pinDirectionInButton;
    }

    public void setPinDirectionInButton(Button pinDirectionInButton) {
        this.pinDirectionInButton = pinDirectionInButton;
    }

    public Button getPinDirectionOutButton() {
        return this.pinDirectionOutButton;
    }

    public void setPinDirectionOutButton(Button pinDirectionOutButton) {
        this.pinDirectionOutButton = pinDirectionOutButton;
    }

    public Point getSize() {
        return this.controlCanvas.getSize();
    }

    public void setSize(int width, int height) {
        this.controlCanvas.setSize(width, height);
    }

    public Point getLocation() {
        return this.controlCanvas.getLocation();
    }

    public void setLocation(int x, int y) {
        this.controlCanvas.setLocation(x, y);
    }

    public void setPinSelection(int pinSelection) {
        this.pinSelection = pinSelection;
    }

    public int getPinSelection() {
        return this.pinSelection;
    }

    public int getPinID() {
        return this.pinID;
    }

    public void setPinID(int pinID) {
        this.pinID = pinID;
    }

    public int getPinNumber() {
        return this.pinNumber;
    }

    public void setPinNumber(int pinNumber) {
        this.pinNumber = pinNumber;
        this.pinNumCombo.select(this.pinNumCombo.indexOf(Integer.toString(pinNumber)));
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
        this.dataTypeCombo.select(dataType);
        this.digitalControlCanvas.setVisible(this.dataTypeCombo.getText().toLowerCase().contains("digital"));
        this.analogControlCanvas.setVisible(this.dataTypeCombo.getText().toLowerCase().contains("analog"));
    }

    public int getDigitalValue() {
        return this.digitalValue;
    }

    public void setDigitalValue(int digitalValue) {
        this.digitalValue = digitalValue;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public String getPinName() {
        return this.pinName;
    }

    public void setPinName(String pinName) {
        this.pinName = pinName;
        this.pinNameText.setText(pinName);
    }

    public int getAnalogMinValue() {
        return this.analogMinValue;
    }

    public void setAnalogMinValue(int analogMinValue) {
        this.analogMinValue = analogMinValue;
        this.analogValueScale.setMinimum(analogMinValue);
        this.analogMinValueLabel.setText(String.format("%.2f V", Float.valueOf((float)analogMinValue / 100.0f)));
        this.analogMinValueLabel.pack();
    }

    public int getAnalogMaxValue() {
        return this.analogMaxValue;
    }

    public void setAnalogMaxValue(int analogMaxValue) {
        this.analogMaxValue = analogMaxValue;
        this.analogValueScale.setMaximum(analogMaxValue);
        this.analogMaxValueLabel.setText(String.format("%.2f V", Float.valueOf((float)analogMaxValue / 100.0f)));
        this.analogMaxValueLabel.pack();
    }

    public int getAnalogCurrentValue() {
        return this.analogCurrentValue;
    }

    public void setAnalogCurrentValue(int analogCurrentValue) {
        this.analogCurrentValue = analogCurrentValue;
        this.analogValueScale.setSelection(analogCurrentValue);
        this.analogCurrentValueLabel.setText(String.format("%.2f V", Float.valueOf((float)analogCurrentValue / 100.0f)));
        this.analogCurrentValueLabel.pack();
    }

    public void show() {
        this.instructions.setVisible(false);
        this.infoCanvas.setVisible(true);
    }

    public void hide() {
        this.instructions.setVisible(true);
        this.infoCanvas.setVisible(false);
        this.digitalControlCanvas.setVisible(false);
        this.analogControlCanvas.setVisible(false);
    }

    public void setFocus() {
        this.pinNumCombo.setFocus();
    }

    public Combo getPinNumCombo() {
        return this.pinNumCombo;
    }

    public Combo getDataTypeCombo() {
        return this.dataTypeCombo;
    }

    public void dispose() {
        this.controlCanvas.dispose();
    }

    public Canvas getCanvas() {
        return this.controlCanvas;
    }
}

