/* GNUC Startup library
 *    Copyright  2015 Freescale semiConductor Inc. All Rights Reserved.
 *
 * $Date: 2015/04/07 06:41:34 $
 * $Revision: 1.0 $
 */


/*
 *	init_bss.c	-	clear bss
 *
 */

void init_data_bss(void)
{
	extern char __START_BSS[];
	extern char __END_BSS[];

	unsigned long len = __END_BSS - __START_BSS;
  unsigned long dst = (unsigned long) __START_BSS;

	const int size_int = sizeof(int);
	const int mask_int = sizeof(int)-1;

	const int size_short = sizeof(short);
	const int mask_short = sizeof(short)-1;

	const int size_char = sizeof(char);

	if( len == 0)
	{
		return;
	}


	while( len > 0)
	{

		if( !(dst & mask_int) && len >= size_int)
		{
			*((int *)dst)  = 0;
			dst += size_int;
			len -= size_int;
		}
		else if( !(dst & mask_short) && len >= size_short)
		{
			*((short *)dst)  = 0;
			dst += size_short;
			len -= size_short;
		}
		else
		{
			*((char *)dst)  = 0;
			dst += size_char;
			len -= size_char;
		}
	}
}

