/*========================================================================*
 * COPYRIGHT:                                                             *
 *  Freescale Semiconductor, INC. All Rights Reserved. You are hereby     *
 *  granted a copyright license to use, modify, and distribute the        *
 *  SOFTWARE so long as this entire notice is retained without alteration *
 *  in any modified and/or redistributed versions, and that such modified *
 *  versions are clearly identified as such. No licenses are granted by   *
 *  implication, estoppel or otherwise under any patentsor trademarks     *
 *  of Freescale Semiconductor, Inc. This software is provided on an      *
 *  "AS IS" basis and without warranty.                                   *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, Freescale          *
 *  Semiconductor DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED,    *
 *  INCLUDING IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A      *
 *  PARTICULAR PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD  *
 *  TO THE SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY     *
 *  ACCOMPANYING WRITTEN MATERIALS.                                       *
 *                                                                        *
 *  To the maximum extent permitted by applicable law, IN NO EVENT        *
 *  SHALL Freescale Semiconductor BE LIABLE FOR ANY DAMAGES WHATSOEVER    *
 *  (INCLUDING WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS,  *
 *  BUSINESS INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER         *
 *  PECUNIARY LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.  *
 *                                                                        *
 *  Freescale Semiconductor assumes no responsibility for the             *
 *  maintenance and support of this software                              *
 *                                                                        *
 **************************************************************************/


.globl Reset_Handler

        .section .text
Reset_Handler:
        
        /* set up stack pointer */
        .extern __StackTop
        ldr     r0, =__StackTop
        mov     sp, r0

        /* disable CM4 watchdog */
        ldr     r0, =0x40088010
        ldr     r1, =0xC520
        str     r1, [r0]
        ldr     r1, =0xD928
        str     r1, [r0]
        sub     r0, r0, #16
        ldr     r1, =0xFF00010A
        str     r1, [r0]

        /* enable permissions for masters to access peripherals */
        
        ldr     r0, =0x40000000
        ldr     r1, =0x77777777
        str     r1, [r0]
        ldr     r0, =0x40080000
        str     r1, [r0]
        ldr     r0, =0x40000004
        ldr     r1, =0x77000000
        str     r1, [r0]
        ldr     r0, =0x40080004
        str     r1, [r0]

#if defined (__VFP_FP__) && !defined(__SOFTFP__)
        .extern init_FPU
        bl init_FPU
#endif /* #if defined (__VFP_FP__) && !defined(__SOFTFP__)*/

        .extern init_data
        bl      init_data
