; ---------------------------------------------------------------------------------------
;  @file:    startup_MAC57D54H_M4.s
;  @purpose: CMSIS Cortex-M4 Core Device Startup File
;            MAC57D54H
; ---------------------------------------------------------------------------------------
;
; Copyright (c) 1997 - 2015 , Freescale Semiconductor, Inc.
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without modification,
; are permitted provided that the following conditions are met:
;
; o Redistributions of source code must retain the above copyright notice, this list
;   of conditions and the following disclaimer.
;
; o Redistributions in binary form must reproduce the above copyright notice, this
;   list of conditions and the following disclaimer in the documentation and/or
;   other materials provided with the distribution.
;
; o Neither the name of Freescale Semiconductor, Inc. nor the names of its
;   contributors may be used to endorse or promote products derived from this
;   software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
; DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
; ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
; ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
; (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
;*****************************************************************************
;* Version: GCC for ARM Embedded Processors                                  *
;*****************************************************************************
    .file "startup_MAC57D54H_M4.s"
    .text

    .need DefaultISR
    .globl DefaultISR

    .thumb

    .section .isr_vector, "a"
    .align 2
    .globl __isr_vector
__isr_vector:
         .long   __StackTop                                      ; Top of Stack
        .long     Reset_Handler

        .long     NMI_Handler                                   ;NMI Handler
        .long     HardFault_Handler                             ;Hard Fault Handler
        .long     MemManage_Handler                             ;MPU Fault Handler
        .long     BusFault_Handler                              ;Bus Fault Handler
        .long     UsageFault_Handler                            ;Usage Fault Handler
        .long 0                            ; Reserved 
        .long 0                            ; Reserved 
        .long 0                            ; Reserved 
        .long 0                            ; Reserved 
        .long exception_trap               ; SVCall 
        .long 0                            ; Reserved 
        .long 0                            ; Reserved 
        .long exception_trap               ; PendSV 
        .long exception_trap                ; SysTick 

        ; 112 interrupts 
        .long interrupt_trap
        .long exception_trap
        .long exception_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap
        .long interrupt_trap

    .size    __isr_vector, . - __isr_vector

    .text
    .thumb

; Reset Handler
    .thumb
    .align 4
    .globl   Reset_Handler
    .weak    Reset_Handler
    .type    Reset_Handler, $function
Reset_Handler:
    cpsid   i               ; Mask interrupts

    ; Init the rest of the registers
    ldr     r1,=0
    ldr     r2,=0
    ldr     r3,=0
    ldr     r4,=0
    ldr     r5,=0
    ldr     r6,=0
    ldr     r7,=0
    mov     r8,r7
    mov     r9,r7
    mov     r10,r7
    mov     r11,r7
    mov     r12,r7

    ; Initialize the stack pointer
    ldr     r0,=__StackTop
    mov     r13,r0

    
    ; disable CM4 watchdog 
    ldr     r0, =0x40088010
    ldr     r1, =0xc520
    str     r1, [r0]
    ldr     r1, =0xd928
    str     r1, [r0]
    sub     r0, r0, #16
    ldr     r1, =0xff00010a
    str     r1, [r0]
    
    ; enable permissions for masters to access peripherals
    ldr     r0, =0x40000000
    ldr     r1, =0x77777777
    str     r1, [r0]
    ldr     r0, =0x40080000
    str     r1, [r0]
    ldr     r0, =0x40000004
    ldr     r1, =0x77000000
    str     r1, [r0]
    ldr     r0, =0x40080004
    str     r1, [r0]

    ;; Init .data and .bss sections
    ldr     r0, =init_data_bss
    blx     r0
    cpsie   i               ; Unmask interrupts

#if (defined(__FPU_USED))
        bl init_FPU
#endif

