/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core;

import java.util.stream.Stream;

public enum OSFamily {
    WINDOWS("windows", OSFamily.osStartsWith("win")),
    LINUX("linux", OSFamily.osStartsWith("linux")),
    OSX("osx", OSFamily.osStartsWith("mac")),
    OTHER("other", false);

    public static final OSFamily current;
    public final String family;
    private final boolean isCurrent;

    static {
        current = Stream.of(OSFamily.values()).filter(f -> f.isCurrent).findAny().orElse(OTHER);
    }

    private OSFamily(String family, boolean isCurrent) {
        this.family = family;
        this.isCurrent = isCurrent;
    }

    public boolean isCurrent() {
        return this.equals((Object)current);
    }

    private static boolean osStartsWith(String prefix) {
        return System.getProperty("os.name").toLowerCase().startsWith(prefix);
    }
}

