/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core;

import com.nxp.s32ds.ext.rcp.p2.core.Messages;
import com.nxp.s32ds.ext.rcp.p2.core.utils.Util;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.touchpoint.natives.ClosedBackupStoreException;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.LazyBackupStore;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.spi.Touchpoint;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.osgi.util.NLS;

public class UnnativeTouchpoint
extends Touchpoint {
    private static Map<IProfile, IBackupStore> backups = new WeakHashMap<IProfile, IBackupStore>();

    public IStatus initializeOperand(IProfile profile, Map<String, Object> parameters) {
        IProvisioningAgent agent = (IProvisioningAgent)parameters.get("agent");
        IArtifactKey artifactKey = (IArtifactKey)parameters.get("artifact");
        if (!parameters.containsKey("artifact.location") && artifactKey != null) {
            try {
                IFileArtifactRepository downloadCache = Util.getDownloadCacheRepo(agent);
                File fileLocation = downloadCache.getArtifactFile(artifactKey);
                if (fileLocation != null && fileLocation.exists()) {
                    parameters.put("artifact.location", fileLocation.getAbsolutePath());
                }
            }
            catch (ProvisionException e) {
                return e.getStatus();
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus initializePhase(IProgressMonitor monitor, IProfile profile, String phaseId, Map<String, Object> touchpointParameters) {
        touchpointParameters.put("backup", UnnativeTouchpoint.getBackupStore(profile));
        return null;
    }

    public String qualifyAction(String actionId) {
        return "com.nxp.s32ds.ext.rcp.p2.core." + actionId;
    }

    public IStatus prepare(IProfile profile) {
        return super.prepare(profile);
    }

    public IStatus commit(IProfile profile) {
        IBackupStore store = UnnativeTouchpoint.getBackupStore(profile);
        store.discard();
        return Status.OK_STATUS;
    }

    public static String escape(String toEscape) {
        StringBuffer buffer = new StringBuffer();
        int length = toEscape.length();
        int i = 0;
        while (i < length) {
            char ch = toEscape.charAt(i);
            switch (ch) {
                case '\"': 
                case '%': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    buffer.append("%" + ch + ";");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public IStatus rollback(IProfile profile) {
        IStatus returnStatus = Status.OK_STATUS;
        IBackupStore store = UnnativeTouchpoint.getBackupStore(profile);
        try {
            store.restore();
        }
        catch (IOException e) {
            returnStatus = new Status(4, "com.nxp.s32ds.ext.rcp.p2.core", NLS.bind((String)Messages.failed_backup_restore, (Object)store.getBackupName()), (Throwable)e);
        }
        catch (ClosedBackupStoreException e) {
            returnStatus = new Status(4, "com.nxp.s32ds.ext.rcp.p2.core", NLS.bind((String)Messages.failed_backup_restore, (Object)store.getBackupName()), (Throwable)e);
        }
        UnnativeTouchpoint.clearProfileState(profile);
        return returnStatus;
    }

    private static synchronized void clearProfileState(IProfile profile) {
        backups.remove(profile);
    }

    public static synchronized IBackupStore getBackupStore(IProfile profile) {
        if (profile == null) {
            return null;
        }
        IBackupStore store = backups.get(profile);
        if (store == null) {
            store = new LazyBackupStore(UnnativeTouchpoint.escape(profile.getProfileId()));
            backups.put(profile, store);
        }
        return store;
    }
}

