/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.errorParsers;

import com.freescale.s32ds.cdt.core.IFSLErrorParser3;
import com.freescale.s32ds.cdt.core.errorParsers.CommonErrorParser;
import com.freescale.s32ds.cdt.core.errorParsers.Messages;
import com.freescale.s32ds.cdt.core.errorParsers.MwErrorPattern;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class S32DSGNULinkerErrorParser
extends CommonErrorParser
implements IFSLErrorParser3 {
    private static final MwErrorPattern[] patterns = new MwErrorPattern[]{S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_INVALID_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_CANNOT_PATTERN", 0, 1), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_ERRORS_ENLINKEROCESSING_FILE_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_SYMBOL_MISSING_FROM_MAIN_HASH_TABLE_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_COULD_NOT_READ_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_UNRESOLVE_SYMBOL_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_UNDEFINED_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_NONCONSTATNT_EXPRESSION_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_ATTEMPT_TO_OPEN_PATTERN", 0, 1), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_ATTEMPT_STATIC_LINK_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_ATTEMPT_FILE_NOT_RECOGNIZED_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_MEMBER_IS_NOT_AN_OBJECT_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_NOT_FOUND_FOR_INSERT_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_SECTION_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_SECTION_WILL_NOT_FIT_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_REGION_OVERFLOWED_BY_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_CAN`T_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_ERROR_PATTERN", 0, 3), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_ERROR_IN_DLL", 0, 1), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_RELOCATEBLE_LINKING_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_ARCHITECTURE_OF_INPUT_LINKING_PATTERN", 1, 2), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_FAILED_PATTERN", 0, 1), S32DSGNULinkerErrorParser.createLinkerErrorPattern("S32DS_GNU_LINKER_UNABLE_TO_PATTERN", 1, 2)};
    private final List<ProblemMarkerInfo> fErrors = new ArrayList<ProblemMarkerInfo>();

    private static MwErrorPattern createLinkerErrorPattern(String patternt, int fileGroup, int descriptionGroup) {
        return new MwErrorPattern(Messages.getString(patternt, null), fileGroup, 0, descriptionGroup, 0, 2, 0);
    }

    public boolean processLine(String line, ErrorParserManager eoParser) {
        MwErrorPattern[] mwErrorPatternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            MwErrorPattern pattern = mwErrorPatternArray[n2];
            Matcher matcher = pattern.getMatcher(line);
            if (matcher.find()) {
                return this.recordError(line, pattern, matcher, eoParser);
            }
            ++n2;
        }
        return false;
    }

    private boolean recordError(String line, MwErrorPattern pattern, Matcher matcher, ErrorParserManager parser) {
        String errorCode;
        int severity = pattern.getSeverity(matcher);
        if (severity == -1) {
            return true;
        }
        String desc = pattern.getDesc(matcher);
        String filename = pattern.getFileName(matcher);
        String description = this.createComplexDesc(desc);
        IResource file = null;
        file = this.getFile(parser, filename);
        if (!this.mergeLastEntry(file, severity, 0, desc, errorCode = pattern.getErrorCode(matcher), parser.getProject())) {
            this.flush(parser);
            ProblemMarkerInfo problemMarkerInfo = new ProblemMarkerInfo(file, 0, description, severity, filename, null);
            this.fErrors.add(problemMarkerInfo);
            parser.addProblemMarker(problemMarkerInfo);
        }
        return true;
    }

    private IResource getFile(ErrorParserManager parser, String filename) {
        IFile file = null;
        if (filename != null && (file = parser.findFileName(filename)) == null) {
            file = parser.getProject();
        }
        return file;
    }

    private String createComplexDesc(String desc) {
        if (desc != null) {
            return "Ld error: " + desc.trim();
        }
        return null;
    }

    public boolean mergeLastEntry(IResource file, int severity, int lineNumber, String desc, String errorCode, IProject iProject) {
        if (this.fErrors.size() > 0 && file != null) {
            ProblemMarkerInfo mInfo = this.fErrors.get(this.fErrors.size() - 1);
            if (file.equals((Object)iProject) && file.equals((Object)mInfo.file)) {
                return false;
            }
            if (mInfo.file.equals((Object)file) && mInfo.lineNumber == lineNumber && errorCode == null) {
                if (severity > mInfo.severity) {
                    mInfo.severity = severity;
                    mInfo.description = String.valueOf(desc) + " (" + mInfo.description + ")";
                } else {
                    mInfo.description = mInfo.description.concat(" " + desc);
                }
                return true;
            }
        }
        return false;
    }

    public void flush(ErrorParserManager eoParser) {
        for (ProblemMarkerInfo info : this.fErrors) {
            eoParser.generateExternalMarker(info.file, info.lineNumber, info.description, info.severity, info.variableName, info.externalPath);
        }
        this.fErrors.clear();
    }

    public void shutdown() {
    }
}

