/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.core.updater.service.impl;

import com.nxp.s32ds.ext.ide.core.updater.service.impl.ProjectUpdaterServiceObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ProjectUpdaterServiceUtil {
    public static final String BUNDLE_ID = "com.nxp.s32ds.ext.core.updater.service";
    private static final String CC_NATURE = "org.eclipse.cdt.core.ccnature";
    private static final String C_NATURE = "org.eclipse.cdt.core.cnature";

    public static ProjectUpdaterServiceObject searchUpdateObject(IProject project, String cprojectFile, String search, String replace) {
        ProjectUpdaterServiceObject updateTcObject = new ProjectUpdaterServiceObject();
        IFile file = project.getFile(cprojectFile);
        Path path = Paths.get(file.getLocation().toOSString(), new String[0]);
        try {
            updateTcObject.setCprojectPath(path);
            ArrayList<String> fileContent = new ArrayList<String>(Files.readAllLines(path, StandardCharsets.UTF_8));
            int lineIndex = 0;
            for (String line : fileContent) {
                if (line.contains(search)) {
                    String correctedLine = line.replaceAll(search, replace);
                    fileContent.set(lineIndex, correctedLine);
                    updateTcObject.addToMapLines(lineIndex, correctedLine);
                }
                ++lineIndex;
            }
            if (updateTcObject.isContainsChanges()) {
                updateTcObject.setResultCProjectLines(fileContent);
            }
        }
        catch (IOException e) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, BUNDLE_ID, e.getMessage(), (Throwable)e));
        }
        return updateTcObject;
    }

    public static IStatus applyUpdateObject(ProjectUpdaterServiceObject updateObj) {
        try {
            if (updateObj.isContainsChanges()) {
                Files.write(updateObj.getCprojectPath(), updateObj.getResultCProjectLines(), StandardCharsets.UTF_8, new OpenOption[0]);
            }
        }
        catch (IOException e) {
            return new Status(4, BUNDLE_ID, e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public static boolean isCCPPNatureProject(IProject project) {
        return ProjectUpdaterServiceUtil.hasCNature(project) || ProjectUpdaterServiceUtil.hasCCNature(project);
    }

    private static boolean hasCNature(IProject project) {
        try {
            return project.isOpen() && project.hasNature(C_NATURE);
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
            return false;
        }
    }

    private static boolean hasCCNature(IProject project) {
        try {
            return project.isOpen() && project.hasNature(CC_NATURE);
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
            return false;
        }
    }
}

