/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.examples.core;

import com.nxp.s32ds.ext.ide.examples.core.IExampleObject;
import com.nxp.s32ds.ext.ide.examples.core.IVisualComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;

public class VisualComponent
implements IVisualComponent {
    String name;
    List<IVisualComponent> listCategory;
    List<IExampleObject> listObjects;

    public VisualComponent() {
        this.listObjects = new ArrayList<IExampleObject>();
        this.listCategory = new ArrayList<IVisualComponent>();
    }

    public VisualComponent(String name, List<IExampleObject> listChild, List<IVisualComponent> listCategory) {
        this.name = name;
        this.listObjects = listChild;
        this.listCategory = listCategory;
        if (this.listCategory == null) {
            this.listCategory = new ArrayList<IVisualComponent>();
        }
        if (this.listObjects == null) {
            this.listObjects = new ArrayList<IExampleObject>();
        }
    }

    @Override
    public String getVisualComponentName() {
        return this.name;
    }

    public void addChild(IExampleObject obj) {
        this.listObjects.add(obj);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public List<IVisualComponent> getGroups() {
        return this.listCategory;
    }

    @Override
    public List<IExampleObject> getChildObjects() {
        return this.listObjects;
    }

    public IVisualComponent findGroupByName(IVisualComponent rootNode, String categoryName) {
        Stack<IVisualComponent> stackElements = new Stack<IVisualComponent>();
        if (rootNode == null) {
            stackElements.add(this);
        } else {
            stackElements.add(rootNode);
        }
        while (!stackElements.isEmpty()) {
            IVisualComponent component = (IVisualComponent)stackElements.pop();
            if (component.getVisualComponentName().equals(categoryName)) {
                return component;
            }
            if (component.getGroups() == null || component.getGroups().isEmpty()) continue;
            stackElements.addAll(component.getGroups());
        }
        return null;
    }

    public void addNewItems(String group, IExampleObject object) {
        String[] groupSection = null;
        if (group.isEmpty()) {
            this.setChildObject(object);
            return;
        }
        try {
            groupSection = group.split(";");
        }
        catch (Exception exception) {
            groupSection = new String[]{group};
        }
        IVisualComponent nodeGroupComponent = null;
        String[] stringArray = groupSection;
        int n = groupSection.length;
        int n2 = 0;
        while (n2 < n) {
            String groupItemName = stringArray[n2];
            IVisualComponent groupComponent = this.findGroupByName(nodeGroupComponent, groupItemName);
            if (groupComponent == null && nodeGroupComponent == null) {
                nodeGroupComponent = new VisualComponent(groupItemName, null, null);
                this.listCategory.add(nodeGroupComponent);
            } else if (groupComponent == null && nodeGroupComponent != null) {
                VisualComponent subNodeGroupComponent = new VisualComponent(groupItemName, null, null);
                nodeGroupComponent.add(subNodeGroupComponent);
                nodeGroupComponent = subNodeGroupComponent;
            } else if (groupComponent != null) {
                nodeGroupComponent = groupComponent;
            }
            ++n2;
        }
        if (nodeGroupComponent != null) {
            nodeGroupComponent.setChildObject(object);
        }
    }

    @Override
    public void add(VisualComponent subNodeGroupComponent) {
        this.listCategory.add(subNodeGroupComponent);
    }

    @Override
    public void setChildObject(IExampleObject object) {
        this.listObjects.add(object);
        Collections.sort(this.listObjects, new Comparator<IExampleObject>(){

            @Override
            public int compare(IExampleObject gr1, IExampleObject gr2) {
                return gr1.getModelingComponent().getName().toLowerCase().compareTo(gr2.getModelingComponent().getName().toLowerCase());
            }
        });
    }
}

