/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt;

import com.freescale.s32ds.cdt.Activator;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.PlatformUI;

public class OpenUrlHandler
extends AbstractHandler {
    public static final String URL_PARAM_ID = "com.freescale.s32ds.cdt.openUrl.url.param";
    private static final Map<String, String> VARS = Collections.unmodifiableMap(new LinkedHashMap<String, String>(){
        {
            this.put("${eclipse_home}", Platform.getInstallLocation().getURL().toExternalForm());
        }
    });

    private static String resolveVars(String str) {
        for (Map.Entry<String, String> var : VARS.entrySet()) {
            str = str.replaceAll(Pattern.quote(var.getKey()), var.getValue());
        }
        return str;
    }

    public Object execute(ExecutionEvent event) {
        try {
            String path = OpenUrlHandler.resolveVars(event.getParameter(URL_PARAM_ID));
            if (path.startsWith("file:")) {
                path = path.substring("file:".length());
                while (path.startsWith("/")) {
                    path = path.substring(1);
                }
                path = "file:///" + path;
            }
            path = OpenUrlHandler.urlEncodeForSpaces(path.toCharArray());
            URL url = new URL(path);
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
        }
        catch (Throwable e) {
            Activator.log(e);
        }
        return null;
    }

    private static String urlEncodeForSpaces(char[] input) {
        StringBuilder encoded = new StringBuilder(input.length);
        int i = 0;
        while (i < input.length) {
            char c = input[i];
            if (c == ' ') {
                encoded.append("%20");
            } else {
                encoded.append(c);
            }
            ++i;
        }
        return encoded.toString();
    }
}

